/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.transport.jsonrpc;

import foundation.icon.icx.data.Address;
import foundation.icon.icx.data.Bytes;
import foundation.icon.icx.transport.jsonrpc.RpcArray;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import foundation.icon.icx.transport.jsonrpc.RpcValue;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigInteger;

public class RpcItemCreator {
    public static <T> RpcItem create(T item) {
        return RpcItemCreator.toRpcItem(item);
    }

    static <T> RpcItem toRpcItem(T item) {
        return item != null ? RpcItemCreator.toRpcItem(item.getClass(), item) : null;
    }

    static <T> RpcItem toRpcItem(Class<?> type, T item) {
        RpcValue rpcValue = RpcItemCreator.toRpcValue(item);
        if (rpcValue != null) {
            return rpcValue;
        }
        if (type.isArray()) {
            return RpcItemCreator.toRpcArray(item);
        }
        if (!type.isPrimitive()) {
            return RpcItemCreator.toRpcObject(item);
        }
        return null;
    }

    static RpcObject toRpcObject(Object object) {
        RpcObject.Builder builder = new RpcObject.Builder();
        RpcItemCreator.addObjectFields(builder, object, object.getClass().getDeclaredFields());
        RpcItemCreator.addObjectFields(builder, object, object.getClass().getFields());
        return builder.build();
    }

    static String getKeyFromObjectField(Field field) {
        return field.getName();
    }

    static void addObjectFields(RpcObject.Builder builder, Object parent, Field[] fields) {
        for (Field field : fields) {
            RpcItem rpcItem;
            String key = RpcItemCreator.getKeyFromObjectField(field);
            if (key.equals("this$0")) continue;
            Class<?> type = field.getType();
            Object fieldObject = null;
            try {
                field.setAccessible(true);
                fieldObject = field.get(parent);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (fieldObject == null && type.isInstance(fieldObject) || (rpcItem = RpcItemCreator.toRpcItem(type, fieldObject)) == null || rpcItem.isEmpty()) continue;
            builder.put(key, rpcItem);
        }
    }

    static RpcArray toRpcArray(Object obj) {
        Class<?> componentType = obj.getClass().getComponentType();
        if (componentType == Boolean.TYPE || !componentType.isPrimitive()) {
            RpcArray.Builder builder = new RpcArray.Builder();
            int length = Array.getLength(obj);
            for (int i = 0; i < length; ++i) {
                builder.add(RpcItemCreator.toRpcItem(Array.get(obj, i)));
            }
            return builder.build();
        }
        return null;
    }

    static RpcValue toRpcValue(Object object) {
        if (object.getClass().isAssignableFrom(Boolean.class)) {
            return new RpcValue((Boolean)object);
        }
        if (object.getClass().isAssignableFrom(String.class)) {
            return new RpcValue((String)object);
        }
        if (object.getClass().isAssignableFrom(BigInteger.class)) {
            return new RpcValue((BigInteger)object);
        }
        if (object.getClass().isAssignableFrom(byte[].class)) {
            return new RpcValue((byte[])object);
        }
        if (object.getClass().isAssignableFrom(Bytes.class)) {
            return new RpcValue((Bytes)object);
        }
        if (object.getClass().isAssignableFrom(Address.class)) {
            return new RpcValue((Address)object);
        }
        return null;
    }
}

