/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.transport.jsonrpc;

import foundation.icon.icx.data.Address;
import foundation.icon.icx.data.Bytes;
import foundation.icon.icx.transport.jsonrpc.RpcItem;
import java.math.BigInteger;

public class RpcValue
implements RpcItem {
    private String value;
    public static final RpcValue NULL = new RpcValue();

    public RpcValue(RpcValue value) {
        this.value = value.asString();
    }

    public RpcValue(Address value) {
        if (value.isMalformed()) {
            throw new IllegalArgumentException("Invalid address");
        }
        this.value = value.toString();
    }

    private RpcValue() {
        this.value = null;
    }

    public RpcValue(String value) {
        this.value = value;
    }

    public RpcValue(byte[] value) {
        this.value = new Bytes(value).toHexString(true);
    }

    public RpcValue(BigInteger value) {
        String sign = value.signum() == -1 ? "-" : "";
        this.value = sign + "0x" + value.abs().toString(16);
    }

    public RpcValue(boolean value) {
        this.value = value ? "0x1" : "0x0";
    }

    public RpcValue(Boolean value) {
        this((boolean)value);
    }

    public RpcValue(Bytes value) {
        this.value = value.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.value == null || this.value.isEmpty();
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RpcValue)) {
            return false;
        }
        RpcValue obj = (RpcValue)o;
        return this.value.equals(obj.value);
    }

    @Override
    public String asString() {
        return this.value;
    }

    @Override
    public byte[] asByteArray() {
        if (!this.value.startsWith("0x")) {
            throw new RpcItem.RpcValueException("The value is not hex string.");
        }
        if (this.value.length() % 2 != 0) {
            throw new RpcItem.RpcValueException("The hex value is not bytes format.");
        }
        if (this.value.length() == 2) {
            return new byte[0];
        }
        return new Bytes(this.value).toByteArray();
    }

    @Override
    public Address asAddress() {
        try {
            if (this.isEmpty()) {
                return null;
            }
            return new Address(this.value);
        }
        catch (IllegalArgumentException e) {
            return Address.createMalformedAddress(this.value);
        }
    }

    @Override
    public Bytes asBytes() {
        return new Bytes(this.value);
    }

    @Override
    public BigInteger asInteger() {
        if (!this.value.startsWith("0x") && !this.value.startsWith("-0x")) {
            throw new RpcItem.RpcValueException("The value is not hex string.");
        }
        try {
            String sign = "";
            if (this.value.charAt(0) == '-') {
                sign = this.value.substring(0, 1);
                this.value = this.value.substring(1);
            }
            String result = sign + Bytes.cleanHexPrefix(this.value);
            return new BigInteger(result, 16);
        }
        catch (NumberFormatException e) {
            throw new RpcItem.RpcValueException("The value is not hex string.");
        }
    }

    @Override
    public Boolean asBoolean() {
        switch (this.value) {
            case "0x0": {
                return false;
            }
            case "0x1": {
                return true;
            }
        }
        throw new RpcItem.RpcValueException("The value is not boolean format.");
    }

    public String toString() {
        return this.value;
    }
}

