/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.icx.transport.monitor;

import foundation.icon.icx.data.Address;
import foundation.icon.icx.data.EventNotification;
import foundation.icon.icx.transport.jsonrpc.RpcArray;
import foundation.icon.icx.transport.jsonrpc.RpcObject;
import foundation.icon.icx.transport.jsonrpc.RpcValue;
import foundation.icon.icx.transport.monitor.MonitorSpec;
import java.math.BigInteger;

public class EventMonitorSpec
extends MonitorSpec<EventNotification> {
    private final BigInteger height;
    private final EventFilter[] filters;
    private final boolean logs;
    private final long progressInterval;

    public EventMonitorSpec(BigInteger height, String event, Address addr, String[] indexed, String[] data) {
        this(height, event, addr, indexed, data, false);
    }

    public EventMonitorSpec(BigInteger height, String event, Address addr, String[] indexed, String[] data, boolean logs) {
        this(height, event, addr, indexed, data, logs, 0L);
    }

    public EventMonitorSpec(BigInteger height, String event, Address addr, String[] indexed, String[] data, boolean logs, long progressInterval) {
        this(height, new EventFilter[]{new EventFilter(event, addr, indexed, data)}, logs, progressInterval);
    }

    public EventMonitorSpec(BigInteger height, EventFilter[] filters, boolean logs, long progressInterval) {
        this.path = "event";
        this.height = height;
        this.filters = filters;
        this.logs = logs;
        this.progressInterval = progressInterval;
    }

    @Override
    public RpcObject getParams() {
        RpcObject.Builder builder = new RpcObject.Builder().put("height", new RpcValue(this.height));
        if (this.logs) {
            builder = builder.put("logs", new RpcValue(true));
        }
        if (this.filters.length == 1) {
            this.filters[0].apply(builder);
        } else {
            RpcArray.Builder arrBuilder = new RpcArray.Builder();
            for (EventFilter ef : this.filters) {
                RpcObject.Builder efBuilder = new RpcObject.Builder();
                ef.apply(efBuilder);
                arrBuilder.add(efBuilder.build());
            }
            builder = builder.put("eventFilters", arrBuilder.build());
        }
        if (this.progressInterval > 0L) {
            builder = builder.put("progressInterval", new RpcValue(BigInteger.valueOf(this.progressInterval)));
        }
        return builder.build();
    }

    @Override
    public Class<EventNotification> getNotificationClass() {
        return EventNotification.class;
    }

    public static class EventFilter {
        private final String event;
        private final Address addr;
        private String[] indexed;
        private String[] data;

        public EventFilter(String event, Address addr, String[] indexed, String[] data) {
            this.event = event;
            this.addr = addr;
            if (indexed != null && indexed.length > 0) {
                this.indexed = new String[indexed.length];
                System.arraycopy(indexed, 0, this.indexed, 0, indexed.length);
            }
            if (data != null && data.length > 0) {
                this.data = new String[data.length];
                System.arraycopy(data, 0, this.data, 0, data.length);
            }
        }

        public void apply(RpcObject.Builder builder) {
            RpcArray.Builder arrayBuilder;
            builder.put("event", new RpcValue(this.event));
            if (this.addr != null) {
                builder.put("addr", new RpcValue(this.addr));
            }
            if (this.data != null) {
                arrayBuilder = new RpcArray.Builder();
                for (String d : this.data) {
                    arrayBuilder.add(new RpcValue(d));
                }
                builder.put("data", arrayBuilder.build());
            }
            if (this.indexed != null) {
                arrayBuilder = new RpcArray.Builder();
                for (String d : this.indexed) {
                    arrayBuilder.add(new RpcValue(d));
                }
                builder.put("indexed", arrayBuilder.build());
            }
        }
    }
}

