/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.jsonrpc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import foundation.icon.icx.Wallet;
import foundation.icon.jsonrpc.IconStringConverter;
import java.util.Arrays;

public class Address
extends score.Address {
    public static final int LENGTH = 21;
    public static final int BODY_LENGTH = 20;
    private final Type type;
    private final String str;
    private final byte[] bytes;

    @JsonCreator
    public Address(String str) {
        this(Address.parse(str));
    }

    public Address(byte[] bytes) throws IllegalArgumentException {
        super(bytes);
        if (bytes == null) {
            throw new IllegalArgumentException("raw could not be null");
        }
        if (bytes.length != 21) {
            throw new IllegalArgumentException("invalid length");
        }
        this.type = Type.of(bytes[0]);
        this.bytes = bytes;
        this.str = this.type.str() + IconStringConverter.fromBytes(bytes).substring(4);
    }

    public Address(Type type, byte[] body) throws IllegalArgumentException {
        this(Address.concat(type.value(), body));
    }

    public boolean isContract() {
        return Type.CONTRACT.equals((Object)this.type);
    }

    public static byte[] concat(byte type, byte[] body) {
        byte[] copy = new byte[21];
        copy[0] = type;
        System.arraycopy(body, 0, copy, 1, 20);
        return copy;
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.bytes, 21);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof score.Address && this.toString().equals(obj.toString());
    }

    @JsonValue
    public String toString() {
        return this.str;
    }

    public static byte[] parse(String str) {
        if (str == null) {
            throw new IllegalArgumentException("string could not be null");
        }
        if (str.length() != 42) {
            throw new IllegalArgumentException("invalid length");
        }
        byte[] bytes = new byte[21];
        bytes[0] = Type.of(str.substring(0, 2)).value();
        System.arraycopy(IconStringConverter.toBytes(str.substring(2)), 0, bytes, 1, 20);
        return bytes;
    }

    public static Address of(Wallet wallet) {
        return Address.of(wallet.getAddress());
    }

    private static Address of(foundation.icon.icx.data.Address address) {
        return new Address(address.toString());
    }

    public static enum Type {
        EOA("hx", 0),
        CONTRACT("cx", 1);

        String str;
        byte value;

        private Type(String str, int value) {
            this.str = str;
            this.value = (byte)value;
        }

        String str() {
            return this.str;
        }

        byte value() {
            return this.value;
        }

        static Type of(byte value) {
            for (Type type : Type.values()) {
                if (type.value != value) continue;
                return type;
            }
            throw new IllegalArgumentException();
        }

        static Type of(String str) {
            for (Type type : Type.values()) {
                if (!type.str.equals(str)) continue;
                return type;
            }
            throw new IllegalArgumentException();
        }
    }
}

