/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.jsonrpc;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.Converter;
import foundation.icon.jsonrpc.Address;
import foundation.icon.jsonrpc.IconStringConverter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;

public class IconJsonModule
extends SimpleModule {
    public static final Version VERSION = VersionUtil.parseVersion((String)"0.1.0", (String)"foundation.icon", (String)"javaee-score-client");
    private final boolean isIncludeNonNull;

    public IconJsonModule() {
        this(true);
    }

    public IconJsonModule(boolean isIncludeNonNull) {
        super(VERSION);
        this.isIncludeNonNull = isIncludeNonNull;
        this.init();
    }

    private void init() {
        this.addSerializer(Character.TYPE, CharSerializer.CHAR);
        this.addSerializer(Character.class, CharSerializer.CHAR);
        this.addSerializer(Byte.TYPE, NumberSerializer.BYTE);
        this.addSerializer(Byte.class, NumberSerializer.BYTE);
        this.addSerializer(Long.TYPE, NumberSerializer.LONG);
        this.addSerializer(Long.class, NumberSerializer.LONG);
        this.addSerializer(Integer.TYPE, NumberSerializer.INTEGER);
        this.addSerializer(Integer.class, NumberSerializer.INTEGER);
        this.addSerializer(Short.TYPE, NumberSerializer.SHORT);
        this.addSerializer(Short.class, NumberSerializer.SHORT);
        this.addSerializer(BigInteger.class, NumberSerializer.BIG_INTEGER);
        this.addSerializer(Boolean.TYPE, BooleanSerializer.BOOLEAN);
        this.addSerializer(Boolean.class, BooleanSerializer.BOOLEAN);
        this.addSerializer(byte[].class, ByteArraySerializer.BYTE_ARRAY);
        this.addSerializer(score.Address.class, AddressSerializer.SCORE_ADDRESS);
        this.addSerializer(short[].class, ShortArraySerializer.SHORT_ARRAY);
        this.addSerializer(int[].class, IntArraySerializer.INT_ARRAY);
        this.addSerializer(long[].class, LongArraySerializer.LONG_ARRAY);
        this.addSerializer(char[].class, CharArraySerializer.CHAR_ARRAY);
        this.addSerializer(boolean[].class, BooleanArraySerializer.BOOLEAN_ARRAY);
        this.addDeserializer(Character.TYPE, CharDeserializer.CHAR);
        this.addDeserializer(Character.class, CharDeserializer.CHAR);
        this.addDeserializer(Byte.TYPE, NumberDeserializer.BYTE);
        this.addDeserializer(Byte.class, NumberDeserializer.BYTE);
        this.addDeserializer(Long.TYPE, NumberDeserializer.LONG);
        this.addDeserializer(Long.class, NumberDeserializer.LONG);
        this.addDeserializer(Integer.TYPE, NumberDeserializer.INTEGER);
        this.addDeserializer(Integer.class, NumberDeserializer.INTEGER);
        this.addDeserializer(Short.TYPE, NumberDeserializer.SHORT);
        this.addDeserializer(Short.class, NumberDeserializer.SHORT);
        this.addDeserializer(BigInteger.class, NumberDeserializer.BIG_INTEGER);
        this.addDeserializer(Boolean.TYPE, BooleanDeserializer.BOOLEAN);
        this.addDeserializer(Boolean.class, BooleanDeserializer.BOOLEAN);
        this.addDeserializer(byte[].class, ByteArrayDeserializer.BYTE_ARRAY);
        this.addDeserializer(score.Address.class, AddressDeserializer.SCORE_ADDRESS);
        this.addDeserializer(short[].class, ShortArrayDeserializer.SHORT_ARRAY);
        this.addDeserializer(int[].class, IntArrayDeserializer.INT_ARRAY);
        this.addDeserializer(long[].class, LongArrayDeserializer.LONG_ARRAY);
        this.addDeserializer(char[].class, CharArrayDeserializer.CHAR_ARRAY);
        this.addDeserializer(boolean[].class, BooleanArrayDeserializer.BOOLEAN_ARRAY);
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        if (this.isIncludeNonNull) {
            JsonInclude.Value value = JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.NON_NULL);
            context.configOverride(Long.class).setInclude(value);
            context.configOverride(Integer.class).setInclude(value);
            context.configOverride(Short.class).setInclude(value);
            context.configOverride(BigInteger.class).setInclude(value);
            context.configOverride(Boolean.class).setInclude(value);
            context.configOverride(byte[].class).setInclude(value);
        }
    }

    public static class AddressDeserializer<T>
    extends JsonDeserializer<T>
    implements Converter<String, T> {
        public static final AddressDeserializer<score.Address> SCORE_ADDRESS = new AddressDeserializer<score.Address>(Address::new);
        public static final AddressDeserializer<foundation.icon.icx.data.Address> SDK_ADDRESS = new AddressDeserializer<foundation.icon.icx.data.Address>(foundation.icon.icx.data.Address::new);
        private final Function<String, T> parseFunc;

        public AddressDeserializer(Function<String, T> parseFunc) {
            this.parseFunc = parseFunc;
        }

        public T convert(String value) {
            return this.parseFunc.apply(value);
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return typeFactory.constructType(String.class);
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructType(new TypeReference<T>(){});
        }

        public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return this.convert(p.getValueAsString());
        }
    }

    public static class ByteArrayDeserializer
    extends JsonDeserializer<byte[]>
    implements Converter<String, byte[]> {
        public static final ByteArrayDeserializer BYTE_ARRAY = new ByteArrayDeserializer();

        public byte[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                return this.convert(p.getValueAsString());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("fail to deserialize loc:%s err:%s", p.getCurrentLocation().toString(), e.getMessage()), e);
            }
        }

        public byte[] convert(String s) {
            return IconStringConverter.toBytes(s);
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return typeFactory.constructType(String.class);
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructArrayType(Byte.TYPE);
        }
    }

    public static class BooleanArrayDeserializer
    extends JsonDeserializer<boolean[]> {
        public static final BooleanArrayDeserializer BOOLEAN_ARRAY = new BooleanArrayDeserializer();

        public boolean[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String[] s = (String[])p.readValueAs(String[].class);
            boolean[] r = new boolean[s.length];
            for (int i = 0; i < s.length; ++i) {
                r[i] = IconStringConverter.toBoolean(s[i]);
            }
            return r;
        }
    }

    public static class BooleanDeserializer
    extends JsonDeserializer<Boolean>
    implements Converter<String, Boolean> {
        public static final BooleanDeserializer BOOLEAN = new BooleanDeserializer();

        public Boolean convert(String value) {
            return IconStringConverter.toBoolean(value);
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return typeFactory.constructType(Boolean.class);
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructType(String.class);
        }

        public Boolean deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            try {
                return this.convert(p.getValueAsString());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("fail to deserialize loc:%s err:%s", p.getCurrentLocation().toString(), e.getMessage()), e);
            }
        }
    }

    public static class CharArrayDeserializer
    extends JsonDeserializer<char[]> {
        public static final CharArrayDeserializer CHAR_ARRAY = new CharArrayDeserializer();

        public char[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String[] s = (String[])p.readValueAs(String[].class);
            char[] r = new char[s.length];
            for (int i = 0; i < s.length; ++i) {
                r[i] = (char)IconStringConverter.toBigInteger(s[i]).intValue();
            }
            return r;
        }
    }

    public static class CharDeserializer
    extends JsonDeserializer<Character>
    implements Converter<String, Character> {
        public static final CharDeserializer CHAR = new CharDeserializer();

        public Character convert(String value) {
            return Character.valueOf((char)NumberDeserializer.INTEGER.convert(value).intValue());
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return typeFactory.constructType(Boolean.class);
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructType(String.class);
        }

        public Character deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (p.currentToken().isNumeric()) {
                return Character.valueOf((char)p.getIntValue());
            }
            return this.convert(p.getValueAsString());
        }
    }

    public static class LongArrayDeserializer
    extends JsonDeserializer<long[]> {
        public static final LongArrayDeserializer LONG_ARRAY = new LongArrayDeserializer();

        public long[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String[] s = (String[])p.readValueAs(String[].class);
            long[] r = new long[s.length];
            for (int i = 0; i < s.length; ++i) {
                r[i] = IconStringConverter.toBigInteger(s[i]).longValue();
            }
            return r;
        }
    }

    public static class IntArrayDeserializer
    extends JsonDeserializer<int[]> {
        public static final IntArrayDeserializer INT_ARRAY = new IntArrayDeserializer();

        public int[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String[] s = (String[])p.readValueAs(String[].class);
            int[] r = new int[s.length];
            for (int i = 0; i < s.length; ++i) {
                r[i] = IconStringConverter.toBigInteger(s[i]).intValue();
            }
            return r;
        }
    }

    public static class ShortArrayDeserializer
    extends JsonDeserializer<short[]> {
        public static final ShortArrayDeserializer SHORT_ARRAY = new ShortArrayDeserializer();

        public short[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String[] s = (String[])p.readValueAs(String[].class);
            short[] r = new short[s.length];
            for (int i = 0; i < s.length; ++i) {
                r[i] = IconStringConverter.toBigInteger(s[i]).shortValue();
            }
            return r;
        }
    }

    public static class NumberDeserializer<T extends Number>
    extends JsonDeserializer<T>
    implements Converter<String, T> {
        public static final NumberDeserializer<Byte> BYTE = new NumberDeserializer<Byte>(Number::byteValue);
        public static final NumberDeserializer<Short> SHORT = new NumberDeserializer<Short>(Number::shortValue);
        public static final NumberDeserializer<Integer> INTEGER = new NumberDeserializer<Integer>(BigInteger::intValue);
        public static final NumberDeserializer<Long> LONG = new NumberDeserializer<Long>(BigInteger::longValue);
        public static final NumberDeserializer<BigInteger> BIG_INTEGER = new NumberDeserializer<BigInteger>(bi -> bi);
        private final Function<BigInteger, T> parseFunc;

        public NumberDeserializer(Function<BigInteger, T> parseFunc) {
            this.parseFunc = parseFunc;
        }

        public T convert(String s) {
            return (T)((Number)this.parseFunc.apply(IconStringConverter.toBigInteger(s)));
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return typeFactory.constructType(String.class);
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructType(new TypeReference<T>(){});
        }

        public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            if (p.currentToken().isNumeric()) {
                return (T)((Number)this.parseFunc.apply(p.getBigIntegerValue()));
            }
            return this.convert(p.getValueAsString());
        }
    }

    public static class AddressSerializer<T>
    extends JsonSerializer<T>
    implements Converter<T, String> {
        public static final AddressSerializer<score.Address> SCORE_ADDRESS = new AddressSerializer();
        public static final AddressSerializer<foundation.icon.icx.data.Address> SDK_ADDRESS = new AddressSerializer();

        public String convert(T value) {
            return value.toString();
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return typeFactory.constructType(new TypeReference<T>(){});
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructType(String.class);
        }

        public void serialize(T address, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString((String)this.convert((Object)address));
        }
    }

    public static class ByteArraySerializer
    extends JsonSerializer<byte[]>
    implements Converter<byte[], String> {
        public static final ByteArraySerializer BYTE_ARRAY = new ByteArraySerializer();

        public void serialize(byte[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(this.convert(value));
        }

        public String convert(byte[] value) {
            return IconStringConverter.fromBytes(value);
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return typeFactory.constructArrayType(Byte.TYPE);
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructType(String.class);
        }
    }

    public static class BooleanArraySerializer
    extends JsonSerializer<boolean[]> {
        public static final BooleanArraySerializer BOOLEAN_ARRAY = new BooleanArraySerializer();

        public void serialize(boolean[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartArray();
            for (boolean v : value) {
                gen.writeString(IconStringConverter.fromBoolean(v));
            }
            gen.writeEndArray();
        }
    }

    public static class BooleanSerializer
    extends JsonSerializer<Boolean>
    implements Converter<Boolean, String> {
        public static final BooleanSerializer BOOLEAN = new BooleanSerializer();

        public String convert(Boolean value) {
            return IconStringConverter.fromBoolean(value);
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return typeFactory.constructType(Boolean.class);
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructType(String.class);
        }

        public void serialize(Boolean value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            if (value != null) {
                gen.writeString(this.convert(value));
            }
        }
    }

    public static class CharArraySerializer
    extends JsonSerializer<char[]> {
        public static final CharArraySerializer CHAR_ARRAY = new CharArraySerializer();

        public void serialize(char[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartArray();
            for (char v : value) {
                gen.writeString(IconStringConverter.fromBigInteger(BigInteger.valueOf(v)));
            }
            gen.writeEndArray();
        }
    }

    public static class CharSerializer
    extends JsonSerializer<Character>
    implements Converter<Character, String> {
        public static final CharSerializer CHAR = new CharSerializer();

        public String convert(Character value) {
            return NumberSerializer.INTEGER.convert(Integer.valueOf(value.charValue()));
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return typeFactory.constructType(Character.class);
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructType(String.class);
        }

        public void serialize(Character value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(this.convert(value));
        }
    }

    public static class LongArraySerializer
    extends JsonSerializer<long[]> {
        public static final LongArraySerializer LONG_ARRAY = new LongArraySerializer();

        public void serialize(long[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartArray();
            for (long v : value) {
                gen.writeString(IconStringConverter.fromBigInteger(BigInteger.valueOf(v)));
            }
            gen.writeEndArray();
        }
    }

    public static class IntArraySerializer
    extends JsonSerializer<int[]> {
        public static final IntArraySerializer INT_ARRAY = new IntArraySerializer();

        public void serialize(int[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartArray();
            for (int v : value) {
                gen.writeString(IconStringConverter.fromBigInteger(BigInteger.valueOf(v)));
            }
            gen.writeEndArray();
        }
    }

    public static class ShortArraySerializer
    extends JsonSerializer<short[]> {
        public static final ShortArraySerializer SHORT_ARRAY = new ShortArraySerializer();

        public void serialize(short[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartArray();
            for (short v : value) {
                gen.writeString(IconStringConverter.fromBigInteger(BigInteger.valueOf(v)));
            }
            gen.writeEndArray();
        }
    }

    public static class NumberArraySerializer<T extends Number>
    extends JsonSerializer<T[]> {
        public static final Map<Class<?>, NumberArraySerializer<?>> map = Map.of(Short.TYPE, new NumberArraySerializer(), Integer.TYPE, new NumberArraySerializer(), Long.TYPE, new NumberArraySerializer());

        public void serialize(T[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            String[] s = (String[])Arrays.stream(value).map(v -> IconStringConverter.fromBigInteger(BigInteger.valueOf(v.longValue()))).toArray(String[]::new);
            gen.writeArray(s, 0, s.length);
        }
    }

    public static class NumberSerializer<T extends Number>
    extends JsonSerializer<T>
    implements Converter<T, String> {
        public static final NumberSerializer<Byte> BYTE = new NumberSerializer();
        public static final NumberSerializer<Short> SHORT = new NumberSerializer();
        public static final NumberSerializer<Integer> INTEGER = new NumberSerializer();
        public static final NumberSerializer<Long> LONG = new NumberSerializer();
        public static final NumberSerializer<BigInteger> BIG_INTEGER = new NumberSerializer();

        public String convert(T t) {
            return IconStringConverter.fromBigInteger(t instanceof BigInteger ? (BigInteger)t : BigInteger.valueOf(((Number)t).longValue()));
        }

        public JavaType getInputType(TypeFactory typeFactory) {
            return typeFactory.constructType(new TypeReference<T>(){});
        }

        public JavaType getOutputType(TypeFactory typeFactory) {
            return typeFactory.constructType(String.class);
        }

        public void serialize(T value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(this.convert(value));
        }
    }
}

