/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.jsonrpc;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import foundation.icon.jsonrpc.TypeReference;
import java.io.IOException;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;

public class JsonrpcClient {
    public static MediaType APPLICATION_JSON = MediaType.parse((String)"application/json");
    protected final String endpoint;
    protected final OkHttpClient httpClient;
    protected final ObjectMapper mapper;
    protected Headers customHeaders;
    protected boolean dumpJson;

    public JsonrpcClient(String endpoint) {
        this(endpoint, new OkHttpClient.Builder().build());
    }

    public JsonrpcClient(String endpoint, OkHttpClient httpClient) {
        this(endpoint, httpClient, new ObjectMapper());
    }

    public JsonrpcClient(String endpoint, ObjectMapper mapper) {
        this(endpoint, new OkHttpClient.Builder().build(), mapper);
    }

    public JsonrpcClient(String endpoint, OkHttpClient httpClient, ObjectMapper mapper) {
        this.endpoint = endpoint;
        this.httpClient = httpClient;
        this.mapper = mapper;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public OkHttpClient httpClient() {
        return this.httpClient;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public boolean isDumpJson() {
        return this.dumpJson;
    }

    public void setDumpJson(boolean dumpJson) {
        this.dumpJson = dumpJson;
    }

    public Headers getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Headers customHeaders) {
        this.customHeaders = customHeaders;
    }

    private Headers.Builder customHeadersBuilder() {
        return this.customHeaders == null ? new Headers.Builder() : this.customHeaders.newBuilder();
    }

    public void addCustomHeader(String name) {
        this.customHeaders = this.customHeadersBuilder().add(name).build();
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders = this.customHeadersBuilder().add(name, value).build();
    }

    public void setCustomHeader(String name, String value) {
        this.customHeaders = this.customHeadersBuilder().set(name, value).build();
    }

    public Object request(String method, Object param) {
        return this.request(Object.class, method, param);
    }

    public <T> T request(Class<T> resultType, String method, Object params) {
        return this.request(this.mapper.getTypeFactory().constructType(resultType), method, params);
    }

    public <T> T request(TypeReference<T> resultType, String method, Object params) {
        return this.request(this.mapper.getTypeFactory().constructType(resultType.getType()), method, params);
    }

    public <T> T request(JavaType resultType, String method, Object params) {
        Request.Builder builder = new Request.Builder().url(this.endpoint).post((RequestBody)new JsonrpcRequestBody(method, params, this.mapper, this.dumpJson));
        if (this.customHeaders != null) {
            builder.headers(this.customHeaders);
        }
        return this.request(builder.build(), resultType);
    }

    protected <T> T request(Request request, JavaType resultType) {
        Response response = null;
        try {
            response = this.httpClient.newCall(request).execute();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ResponseBody responseBody = response.body();
        if (responseBody != null) {
            JsonrpcResponse jsonrpcResponse = null;
            try {
                String json = responseBody.string();
                if (this.dumpJson) {
                    System.out.println(json);
                }
                jsonrpcResponse = (JsonrpcResponse)this.mapper.readValue(json, this.mapper.getTypeFactory().constructParametricType(JsonrpcResponse.class, new JavaType[]{resultType}));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            JsonrpcError error = jsonrpcResponse.getError();
            if (error != null) {
                throw error;
            }
            return jsonrpcResponse.result;
        }
        throw new RuntimeException("empty body");
    }

    public static class LongLikeSerializer
    extends JsonSerializer<Long> {
        public void serialize(Long aLong, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeNumber(((Number)aLong).intValue());
        }
    }

    public static class JsonrpcError
    extends RuntimeException {
        @JsonSerialize(using=LongLikeSerializer.class)
        @JsonDeserialize(using=NumberDeserializers.NumberDeserializer.class)
        private long code;
        private String message;
        private byte[] data;

        public long getCode() {
            return this.code;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class JsonrpcResponse<T> {
        String jsonrpc = "2.0";
        @JsonSerialize(using=LongLikeSerializer.class)
        @JsonDeserialize(using=NumberDeserializers.NumberDeserializer.class)
        long id;
        T result;
        JsonrpcError error;

        public String getJsonrpc() {
            return this.jsonrpc;
        }

        public long getId() {
            return this.id;
        }

        public T getResult() {
            return this.result;
        }

        public JsonrpcError getError() {
            return this.error;
        }
    }

    public static class JsonrpcRequest {
        String jsonrpc = "2.0";
        @JsonSerialize(using=LongLikeSerializer.class)
        @JsonDeserialize(using=NumberDeserializers.NumberDeserializer.class)
        long id = System.currentTimeMillis();
        String method;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        Object params;

        JsonrpcRequest(String method, Object params) {
            this.method = method;
            this.params = params;
        }

        public String getJsonrpc() {
            return this.jsonrpc;
        }

        public long getId() {
            return this.id;
        }

        public String getMethod() {
            return this.method;
        }

        public Object getParams() {
            return this.params;
        }
    }

    public static class JsonrpcRequestBody
    extends RequestBody {
        ObjectMapper mapper;
        boolean dumpJson;
        JsonrpcRequest request;

        JsonrpcRequestBody(String method, Object params, ObjectMapper mapper, boolean dumpJson) {
            this.request = new JsonrpcRequest(method, params);
            this.mapper = mapper;
            this.dumpJson = dumpJson;
        }

        public MediaType contentType() {
            return APPLICATION_JSON;
        }

        public void writeTo(BufferedSink bufferedSink) throws IOException {
            if (this.dumpJson) {
                byte[] bytes = this.mapper.writeValueAsBytes((Object)this.request);
                bufferedSink.write(bytes);
                System.out.println(new String(bytes));
            } else {
                this.mapper.writeValue(bufferedSink.outputStream(), (Object)this.request);
            }
        }
    }
}

