/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.jsonrpc.model;

import foundation.icon.jsonrpc.IconStringConverter;
import java.util.Map;
import java.util.Objects;

public class DeployData {
    private String contentType;
    private byte[] content;
    private Map<String, Object> params;

    public DeployData(String contentType, byte[] content, Map<String, Object> params) {
        Objects.requireNonNull(contentType, "contentType required not null");
        if (contentType.isEmpty()) {
            throw new IllegalArgumentException("contentType required not empty");
        }
        Objects.requireNonNull(content, "content required not null");
        if (content.length == 0) {
            throw new IllegalArgumentException("content required not empty");
        }
        this.contentType = contentType;
        this.content = content;
        this.params = params;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getContent() {
        return this.content;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DeployData{");
        sb.append("contentType='").append(this.contentType).append('\'');
        sb.append(", content=").append(IconStringConverter.fromBytes(this.content));
        sb.append(", params=").append(this.params);
        sb.append('}');
        return sb.toString();
    }
}

