/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.jsonrpc.model;

import foundation.icon.jsonrpc.Address;
import foundation.icon.jsonrpc.model.TransactionParam;
import java.math.BigInteger;
import java.util.Objects;

public class SendTransactionParam
extends TransactionParam {
    private BigInteger stepLimit;

    public SendTransactionParam(BigInteger nid, Address to, BigInteger value, String dataType, Object data) {
        super(nid, to, value, dataType, data);
        Objects.requireNonNull(nid, "nid required not null");
        Objects.requireNonNull(to, "to Address required not null");
        if (value != null && value.signum() == -1) {
            throw new IllegalArgumentException("nid must be positive");
        }
    }

    public BigInteger getStepLimit() {
        return this.stepLimit;
    }

    public void setStepLimit(BigInteger stepLimit) {
        this.stepLimit = stepLimit;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SendTransactionParam{");
        sb.append("stepLimit=").append(this.stepLimit);
        sb.append(", version=").append(this.version);
        sb.append(", from=").append((Object)this.from);
        sb.append(", to=").append((Object)this.to);
        sb.append(", value=").append(this.value);
        sb.append(", timestamp=").append(this.timestamp);
        sb.append(", nid=").append(this.nid);
        sb.append(", nonce=").append(this.nonce);
        sb.append(", dataType='").append(this.dataType).append('\'');
        sb.append(", data=").append(this.data);
        sb.append('}');
        return sb.toString();
    }
}

