/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.jsonrpc.model;

import foundation.icon.jsonrpc.Address;
import foundation.icon.jsonrpc.model.AbstractTransaction;
import java.math.BigInteger;

public class TransactionParam
extends AbstractTransaction {
    public static final BigInteger TIMESTAMP_MSEC_SCALE = BigInteger.valueOf(1000L);

    public static BigInteger currentTimestamp() {
        return TIMESTAMP_MSEC_SCALE.multiply(BigInteger.valueOf(System.currentTimeMillis()));
    }

    public TransactionParam(BigInteger nid, Address to, BigInteger value, String dataType, Object data) {
        this.nid = nid;
        this.to = to;
        this.value = value;
        this.dataType = dataType;
        this.data = data;
    }

    public void setFrom(Address from) {
        this.from = from;
    }

    public void setTimestamp(BigInteger timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TransactionParam{");
        sb.append("version=").append(this.version);
        sb.append(", from=").append((Object)this.from);
        sb.append(", to=").append((Object)this.to);
        sb.append(", value=").append(this.value);
        sb.append(", timestamp=").append(this.timestamp);
        sb.append(", nid=").append(this.nid);
        sb.append(", nonce=").append(this.nonce);
        sb.append(", dataType='").append(this.dataType).append('\'');
        sb.append(", data=").append(this.data);
        sb.append('}');
        return sb.toString();
    }
}

