/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.jsonrpc.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import foundation.icon.jsonrpc.Address;
import foundation.icon.jsonrpc.IconStringConverter;
import foundation.icon.jsonrpc.model.Hash;
import java.math.BigInteger;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TransactionResult {
    private Address to;
    private BigInteger cumulativeStepUsed;
    private BigInteger stepUsed;
    private BigInteger stepPrice;
    private List<EventLog> eventLogs;
    private byte[] logsBloom;
    private BigInteger status;
    private Failure failure;
    private Address scoreAddress;
    private Hash blockHash;
    private BigInteger blockHeight;
    private BigInteger txIndex;
    private Hash txHash;
    private Object stepUsedDetails;

    public Address getTo() {
        return this.to;
    }

    public BigInteger getCumulativeStepUsed() {
        return this.cumulativeStepUsed;
    }

    public BigInteger getStepUsed() {
        return this.stepUsed;
    }

    public BigInteger getStepPrice() {
        return this.stepPrice;
    }

    public List<EventLog> getEventLogs() {
        return this.eventLogs;
    }

    public byte[] getLogsBloom() {
        return this.logsBloom;
    }

    public BigInteger getStatus() {
        return this.status;
    }

    public Failure getFailure() {
        return this.failure;
    }

    public Address getScoreAddress() {
        return this.scoreAddress;
    }

    public Hash getBlockHash() {
        return this.blockHash;
    }

    public BigInteger getBlockHeight() {
        return this.blockHeight;
    }

    public BigInteger getTxIndex() {
        return this.txIndex;
    }

    public Hash getTxHash() {
        return this.txHash;
    }

    public Object getStepUsedDetails() {
        return this.stepUsedDetails;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TransactionResult{");
        sb.append("to=").append((Object)this.to);
        sb.append(", cumulativeStepUsed=").append(this.cumulativeStepUsed);
        sb.append(", stepUsed=").append(this.stepUsed);
        sb.append(", stepPrice=").append(this.stepPrice);
        sb.append(", eventLogs=").append(this.eventLogs);
        sb.append(", logsBloom=").append(IconStringConverter.fromBytes(this.logsBloom));
        sb.append(", status=").append(this.status);
        sb.append(", failure=").append(this.failure);
        sb.append(", scoreAddress=").append((Object)this.scoreAddress);
        sb.append(", blockHash=").append(this.blockHash);
        sb.append(", blockHeight=").append(this.blockHeight);
        sb.append(", txIndex=").append(this.txIndex);
        sb.append(", txHash=").append(this.txHash);
        sb.append(", stepUsedDetails=").append(this.stepUsedDetails);
        sb.append('}');
        return sb.toString();
    }

    public static class Failure {
        private BigInteger code;
        private String message;

        public BigInteger getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Failure{");
            sb.append("code=").append(this.code);
            sb.append(", message='").append(this.message).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    public static class EventLog {
        private Address scoreAddress;
        private List<String> indexed;
        private List<String> data;

        public Address getScoreAddress() {
            return this.scoreAddress;
        }

        public List<String> getIndexed() {
            return this.indexed;
        }

        public List<String> getData() {
            return this.data;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("EventLog{");
            sb.append("scoreAddress=").append((Object)this.scoreAddress);
            sb.append(", indexed=").append(this.indexed);
            sb.append(", data=").append(this.data);
            sb.append('}');
            return sb.toString();
        }
    }
}

