/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.score.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import foundation.icon.annotation_processor.AbstractProcessor;
import foundation.icon.annotation_processor.ProcessorUtil;
import foundation.icon.jsonrpc.Address;
import foundation.icon.jsonrpc.IconStringConverter;
import foundation.icon.jsonrpc.TypeReference;
import foundation.icon.jsonrpc.model.TransactionResult;
import foundation.icon.score.client.DefaultScoreClient;
import foundation.icon.score.client.ScoreClient;
import foundation.icon.score.client.Wallet;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import score.annotation.EventLog;
import score.annotation.External;
import score.annotation.Payable;

public class ScoreClientProcessor
extends AbstractProcessor {
    static final String METHOD_OF = "_of";
    static final String PARAM_PROPERTEIS = "properties";
    static final String PARAM_PREFIX = "prefix";
    static final String METHOD_DEPLOY = "_deploy";
    static final String PARAM_URL = "url";
    static final String PARAM_NID = "nid";
    static final String PARAM_STEP_LIMIT = "stepLimit";
    static final String PARAM_WALLET = "wallet";
    static final String PARAM_ADDRESS = "address";
    static final String PARAM_CLIENT = "client";
    static final String PARAM_SCORE_FILE_PATH = "scoreFilePath";
    static final String PARAM_PARAMS = "params";
    static final String PARAM_PAYABLE_VALUE = "valueForPayable";
    static final String PARAM_CONSUMER = "consumerFunc";
    static final String PARAM_TXR = "txr";
    static final String PARAM_FILTER = "filter";
    static final String METHOD_EVENT_LOGS = "eventLogs";
    static Map<TypeKind, TypeName> wrapperTypeNames = Map.of(TypeKind.BOOLEAN, TypeName.get(Boolean.class), TypeKind.BYTE, TypeName.get(Boolean.class), TypeKind.SHORT, TypeName.get(Byte.class), TypeKind.INT, TypeName.get(Integer.class), TypeKind.LONG, TypeName.get(Long.class), TypeKind.CHAR, TypeName.get(Character.class), TypeKind.FLOAT, TypeName.get(Float.class), TypeKind.DOUBLE, TypeName.get(Double.class));
    private static final Map<String, String> eventTypeStrings = Map.of("byte", "int", "char", "int", "short", "int", "int", "int", "long", "int", "java.math.BigInteger", "int", "java.lang.String", "str", "byte[]", "bytes", "boolean", "bool", "score.Address", "Address");
    private static final Map<String, String> eventConverts = Map.of("byte", "this.$L=$T.toBigInteger(%s).byteValue()", "char", "this.$L=(char)$T.toBigInteger(%s).intValue()", "short", "this.$L=$T.toBigInteger(%s).shortValue()", "int", "this.$L=$T.toBigInteger(%s).intValue()", "long", "this.$L=$T.toBigInteger(%s).longValue()", "java.math.BigInteger", "this.$L=$T.toBigInteger(%s)", "byte[]", "this.$L=$T.toBytes(%s)", "boolean", "this.$L=$T.toBoolean(%s)", "score.Address", "this.$L=$T.toAddress(%s)");

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> s = new HashSet<String>();
        s.add(ScoreClient.class.getCanonicalName());
        return s;
    }

    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean ret = false;
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotationElements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : annotationElements) {
                if (element.getKind().isInterface() || element.getKind().isClass() || element.getKind().isField()) {
                    this.messager.noteMessage("process %s %s", new Object[]{element.getKind(), element.asType(), element.getSimpleName()});
                    this.generateImplementClass(this.processingEnv.getFiler(), element);
                    ret = true;
                    continue;
                }
                throw new RuntimeException("not support, element:" + element);
            }
        }
        return ret;
    }

    private void generateImplementClass(Filer filer, Element element) {
        TypeElement typeElement;
        if (element instanceof TypeElement) {
            typeElement = (TypeElement)element;
        } else if (element instanceof VariableElement) {
            typeElement = super.getTypeElement(element.asType());
        } else {
            throw new RuntimeException("not support, element:" + element);
        }
        ClassName elementClassName = ClassName.get((TypeElement)typeElement);
        String suffix = element.getAnnotation(ScoreClient.class).suffix();
        ClassName className = ClassName.get((String)elementClassName.packageName(), (String)(elementClassName.simpleName() + suffix), (String[])new String[0]);
        TypeSpec typeSpec = this.typeSpec(className, typeElement);
        JavaFile javaFile = JavaFile.builder((String)className.packageName(), (TypeSpec)typeSpec).build();
        try {
            javaFile.writeTo(filer);
        }
        catch (IOException e) {
            this.messager.warningMessage("create javaFile error : %s", new Object[]{e.getMessage()});
        }
    }

    private TypeSpec typeSpec(ClassName className, TypeElement element) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass(DefaultScoreClient.class).addSuperinterfaces((Iterable)ProcessorUtil.getSuperinterfaces((TypeElement)element));
        if (element.getKind().isInterface()) {
            builder.addSuperinterface(element.asType());
        }
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder(String.class, (String)PARAM_URL, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(BigInteger.class, (String)PARAM_NID, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(Wallet.class, (String)PARAM_WALLET, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(Address.class, (String)PARAM_ADDRESS, (Modifier[])new Modifier[0]).build()).addStatement("super($L, $L, $L, $L)", new Object[]{PARAM_URL, PARAM_NID, PARAM_WALLET, PARAM_ADDRESS}).build());
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder(String.class, (String)PARAM_URL, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(BigInteger.class, (String)PARAM_NID, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(BigInteger.class, (String)PARAM_STEP_LIMIT, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(Wallet.class, (String)PARAM_WALLET, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(Address.class, (String)PARAM_ADDRESS, (Modifier[])new Modifier[0]).build()).addStatement("super($L, $L, $L, $L, $L)", new Object[]{PARAM_URL, PARAM_NID, PARAM_STEP_LIMIT, PARAM_WALLET, PARAM_ADDRESS}).build());
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder(DefaultScoreClient.class, (String)PARAM_CLIENT, (Modifier[])new Modifier[0]).build()).addStatement("super($L)", new Object[]{PARAM_CLIENT}).build());
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder(DefaultScoreClient.class, (String)PARAM_CLIENT, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(Wallet.class, (String)PARAM_WALLET, (Modifier[])new Modifier[0]).build()).addStatement("super($L, $L)", new Object[]{PARAM_CLIENT, PARAM_WALLET}).build());
        builder.addMethod(MethodSpec.methodBuilder((String)METHOD_OF).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(ParameterSpec.builder(Properties.class, (String)PARAM_PROPERTEIS, (Modifier[])new Modifier[0]).build()).addStatement("return _of(\"\", $L)", new Object[]{PARAM_PROPERTEIS}).returns((TypeName)className).build());
        builder.addMethod(MethodSpec.methodBuilder((String)METHOD_OF).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(ParameterSpec.builder(String.class, (String)PARAM_PREFIX, (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(Properties.class, (String)PARAM_PROPERTEIS, (Modifier[])new Modifier[0]).build()).addStatement("return new $T($T.of($L, $L))", new Object[]{className, DefaultScoreClient.class, PARAM_PREFIX, PARAM_PROPERTEIS}).returns((TypeName)className).build());
        builder.addMethods(this.overrideMethods(element));
        builder.addMethods(this.deployMethods(className, element));
        builder.addTypes(this.eventTypes(element));
        return builder.build();
    }

    private List<MethodSpec> overrideMethods(TypeElement element) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        TypeMirror superClass = element.getSuperclass();
        if (!superClass.getKind().equals((Object)TypeKind.NONE) && !superClass.toString().equals(Object.class.getName())) {
            this.messager.noteMessage("superClass[kind:%s, name:%s]", new Object[]{superClass.getKind().name(), superClass.toString()});
            List<MethodSpec> superMethods = this.overrideMethods(super.getTypeElement(element.getSuperclass()));
            this.addMethods(methods, superMethods, element);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement typeElement = super.getTypeElement(typeMirror);
            List<MethodSpec> infMethods = this.overrideMethods(typeElement);
            this.addMethods(methods, infMethods, element);
        }
        boolean mustGenerate = element.getKind().isInterface();
        for (Element element2 : element.getEnclosedElements()) {
            if (!ElementKind.METHOD.equals((Object)element2.getKind()) || !ProcessorUtil.hasModifier((Element)element2, (Modifier[])new Modifier[]{Modifier.PUBLIC}) || ProcessorUtil.hasModifier((Element)element2, (Modifier[])new Modifier[]{Modifier.STATIC})) continue;
            ExecutableElement ee = (ExecutableElement)element2;
            External external = ee.getAnnotation(External.class);
            EventLog eventLog = ee.getAnnotation(EventLog.class);
            if (external != null || mustGenerate) {
                boolean readonly;
                CodeBlock paramsCodeblock = this.paramsCodeblock(ee);
                MethodSpec methodSpec = this.methodSpec(ee, paramsCodeblock);
                this.addMethod(methods, methodSpec, element);
                boolean bl = external != null ? external.readonly() : (readonly = !methodSpec.returnType.equals((Object)TypeName.VOID));
                if (!readonly && eventLog == null) {
                    this.addMethod(methods, this.consumerMethodSpec(methodSpec, paramsCodeblock, false), element);
                }
                if (ee.getAnnotation(Payable.class) != null) {
                    if (readonly) {
                        this.messager.warningMessage("Method annotated @Payable cannot be readonly '%s' in %s", new Object[]{ee, element.getQualifiedName()});
                    } else {
                        this.addMethod(methods, this.payableMethodSpec(methodSpec, paramsCodeblock), element);
                        this.addMethod(methods, this.consumerMethodSpec(methodSpec, paramsCodeblock, true), element);
                    }
                }
            }
            if (eventLog == null) continue;
            this.addMethod(methods, this.eventConsumerMethodSpec(ee), element);
        }
        return methods;
    }

    private void addMethods(List<MethodSpec> methods, List<MethodSpec> methodSpecs, TypeElement element) {
        for (MethodSpec methodSpec : methodSpecs) {
            this.addMethod(methods, methodSpec, element);
        }
    }

    private void addMethod(List<MethodSpec> methods, MethodSpec methodSpec, TypeElement element) {
        if (methodSpec != null) {
            MethodSpec conflictMethod = ProcessorUtil.getConflictMethod(methods, (MethodSpec)methodSpec);
            if (conflictMethod != null) {
                methods.remove(conflictMethod);
                if (element.getKind().isInterface()) {
                    this.messager.warningMessage("Redeclare '%s %s(%s)' in %s", new Object[]{conflictMethod.returnType.toString(), conflictMethod.name, ProcessorUtil.parameterSpecToString((List)conflictMethod.parameters), element.getQualifiedName()});
                }
            }
            methods.add(methodSpec);
        }
    }

    private CodeBlock paramsCodeblock(ExecutableElement element) {
        if (element == null || element.getParameters() == null || element.getParameters().size() == 0) {
            return null;
        }
        List parameterSpecs = ProcessorUtil.getParameterSpecs((ExecutableElement)element);
        Set<String> nameSet = parameterSpecs.stream().map(v -> v.name).collect(Collectors.toSet());
        String paramsName = ScoreClientProcessor.newParameterName(nameSet, PARAM_PARAMS);
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.addStatement("$T<$T,$T> $L = new $T<>()", new Object[]{Map.class, String.class, Object.class, paramsName, HashMap.class});
        for (ParameterSpec ps : parameterSpecs) {
            builder.addStatement("$L.put(\"$L\",$L)", new Object[]{paramsName, ps.name, ps.name});
        }
        return builder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MethodSpec methodSpec(ExecutableElement ee, CodeBlock paramsCodeblock) {
        boolean isExternal;
        if (ee.getAnnotation(EventLog.class) != null) {
            return this.notSupportedMethod(ee, "not supported EventLog method", null);
        }
        String methodName = ee.getSimpleName().toString();
        TypeMirror returnType = ee.getReturnType();
        TypeName returnTypeName = TypeName.get((TypeMirror)returnType);
        External external = ee.getAnnotation(External.class);
        List parameterSpecs = ProcessorUtil.getParameterSpecs((ExecutableElement)ee);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(ProcessorUtil.getModifiers((Element)ee, (Modifier[])new Modifier[]{Modifier.ABSTRACT, Modifier.DEFAULT})).addParameters((Iterable)parameterSpecs).returns(returnTypeName);
        String params = "null";
        if (paramsCodeblock != null) {
            builder.addCode(paramsCodeblock);
            params = ScoreClientProcessor.newParameterNameMap(parameterSpecs, PARAM_PARAMS).get(PARAM_PARAMS);
        }
        boolean isVoid = returnTypeName.equals((Object)TypeName.VOID);
        boolean bl = external != null ? !external.readonly() : (isExternal = isVoid);
        if (isExternal) {
            if (!isVoid) return this.notSupportedMethod(ee, "not supported response of writable method in ScoreClient", CodeBlock.builder().add("$L($T<$T> $L, ...)", new Object[]{methodName, Consumer.class, TransactionResult.class, PARAM_CONSUMER}).build());
            builder.addStatement("super._send(\"$L\", $L)", new Object[]{methodName, params});
            if (ee.getAnnotation(Payable.class) == null) return builder.build();
            builder.addJavadoc("To payable, use $L($T $L, ...)", new Object[]{methodName, BigInteger.class, PARAM_PAYABLE_VALUE});
            return builder.build();
        } else {
            if (isVoid) return this.notSupportedMethod(ee, "not supported, void of readonly method in ScoreClient", null);
            if (returnType.getKind().isPrimitive()) {
                builder.addStatement("return super._call($T.class, \"$L\", $L)", new Object[]{wrapperTypeNames.get((Object)returnType.getKind()), methodName, params});
                return builder.build();
            } else if (returnType.getKind().equals((Object)TypeKind.DECLARED) && ((DeclaredType)returnType).getTypeArguments().size() > 0) {
                builder.addStatement("return super._call(new $T<$T>(){}, \"$L\", $L)", new Object[]{TypeReference.class, returnTypeName, methodName, params});
                return builder.build();
            } else {
                builder.addStatement("return super._call($T.class, \"$L\", $L)", new Object[]{returnTypeName, methodName, params});
            }
        }
        return builder.build();
    }

    private MethodSpec payableMethodSpec(MethodSpec methodSpec, CodeBlock paramsCodeblock) {
        Map<String, String> paramNameMap = ScoreClientProcessor.newParameterNameMap(methodSpec.parameters, PARAM_PAYABLE_VALUE, PARAM_PARAMS);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodSpec.name).addModifiers((Iterable)methodSpec.modifiers).addParameter(BigInteger.class, paramNameMap.get(PARAM_PAYABLE_VALUE), new Modifier[0]).addParameters((Iterable)methodSpec.parameters).returns(TypeName.VOID);
        String params = "null";
        if (paramsCodeblock != null) {
            builder.addCode(paramsCodeblock);
            params = paramNameMap.get(PARAM_PARAMS);
        }
        builder.addStatement("super._send($L, \"$L\", $L)", new Object[]{paramNameMap.get(PARAM_PAYABLE_VALUE), methodSpec.name, params});
        return builder.build();
    }

    private MethodSpec consumerMethodSpec(MethodSpec methodSpec, CodeBlock paramsCodeblock, boolean isPayable) {
        Map<String, String> paramNameMap = ScoreClientProcessor.newParameterNameMap(methodSpec.parameters, PARAM_CONSUMER, PARAM_PAYABLE_VALUE, PARAM_PARAMS);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodSpec.name).addModifiers((Iterable)methodSpec.modifiers).addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get(Consumer.class, (Type[])new Type[]{TransactionResult.class}), (String)paramNameMap.get(PARAM_CONSUMER), (Modifier[])new Modifier[0]).build()).returns(TypeName.VOID);
        String params = "null";
        if (paramsCodeblock != null) {
            builder.addCode(paramsCodeblock);
            params = paramNameMap.get(PARAM_PARAMS);
        }
        if (isPayable) {
            builder.addParameter(BigInteger.class, paramNameMap.get(PARAM_PAYABLE_VALUE), new Modifier[0]).addStatement("$L.accept(super._send($L, \"$L\", $L))", new Object[]{paramNameMap.get(PARAM_CONSUMER), paramNameMap.get(PARAM_PAYABLE_VALUE), methodSpec.name, params});
        } else {
            builder.addStatement("$L.accept(super._send(\"$L\", $L))", new Object[]{paramNameMap.get(PARAM_CONSUMER), methodSpec.name, params});
        }
        return builder.addParameters((Iterable)methodSpec.parameters).build();
    }

    private MethodSpec notSupportedMethod(ExecutableElement ee, String msg, CodeBlock instead) {
        String methodName = ee.getSimpleName().toString();
        TypeName returnTypeName = TypeName.get((TypeMirror)ee.getReturnType());
        return MethodSpec.methodBuilder((String)methodName).addModifiers(ProcessorUtil.getModifiers((Element)ee, (Modifier[])new Modifier[]{Modifier.ABSTRACT, Modifier.DEFAULT})).addParameters((Iterable)ProcessorUtil.getParameterSpecs((ExecutableElement)ee)).returns(returnTypeName).addStatement("throw new $T(\"$L\")", new Object[]{RuntimeException.class, msg}).addJavadoc("@deprecated Do not use this method, this is generated only for preventing compile error.\n Instead, use $L\n", new Object[]{instead != null ? instead : "N/A"}).addJavadoc("@throws $L(\"$L\")", new Object[]{RuntimeException.class.getName(), msg}).addAnnotation(Deprecated.class).build();
    }

    private List<MethodSpec> deployMethods(ClassName className, TypeElement element) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        if (element.getKind().isInterface()) {
            methods.add(this.deployMethodSpec(className, null, null));
            methods.add(this.ofMethodSpec(className, null, null));
        } else {
            for (Element element2 : element.getEnclosedElements()) {
                if (!ElementKind.CONSTRUCTOR.equals((Object)element2.getKind()) || !ProcessorUtil.hasModifier((Element)element2, (Modifier[])new Modifier[]{Modifier.PUBLIC})) continue;
                ExecutableElement ee = (ExecutableElement)element2;
                List parameterSpecs = ProcessorUtil.getParameterSpecs((ExecutableElement)ee);
                CodeBlock paramsCodeblock = this.paramsCodeblock(ee);
                methods.add(this.deployMethodSpec(className, parameterSpecs, paramsCodeblock));
                if (parameterSpecs.size() <= 0) continue;
                methods.add(this.ofMethodSpec(className, parameterSpecs, paramsCodeblock));
            }
        }
        return methods;
    }

    static String newParameterName(Set<String> nameSet, String name) {
        return nameSet != null && nameSet.contains(name) ? ScoreClientProcessor.newParameterName(nameSet, "_" + name) : name;
    }

    static Map<String, String> newParameterNameMap(List<ParameterSpec> parameterSpecs, String ... names) {
        Set<String> nameSet = parameterSpecs == null ? null : parameterSpecs.stream().map(v -> v.name).collect(Collectors.toSet());
        HashMap<String, String> nameMap = new HashMap<String, String>();
        for (String name : names) {
            nameMap.put(name, ScoreClientProcessor.newParameterName(nameSet, name));
        }
        return nameMap;
    }

    private MethodSpec deployMethodSpec(ClassName className, List<ParameterSpec> parameterSpecs, CodeBlock paramsCodeblock) {
        Map<String, String> paramNameMap = ScoreClientProcessor.newParameterNameMap(parameterSpecs, PARAM_URL, PARAM_NID, PARAM_WALLET, PARAM_SCORE_FILE_PATH, PARAM_PARAMS);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)METHOD_DEPLOY).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(ParameterSpec.builder(String.class, (String)paramNameMap.get(PARAM_URL), (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(BigInteger.class, (String)paramNameMap.get(PARAM_NID), (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(Wallet.class, (String)paramNameMap.get(PARAM_WALLET), (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(String.class, (String)paramNameMap.get(PARAM_SCORE_FILE_PATH), (Modifier[])new Modifier[0]).build()).returns((TypeName)className);
        if (parameterSpecs == null) {
            builder.addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, Object.class}), (String)PARAM_PARAMS, (Modifier[])new Modifier[0]).build());
        } else {
            builder.addParameters(parameterSpecs);
        }
        if (paramsCodeblock != null) {
            builder.addCode(paramsCodeblock);
        }
        builder.addStatement("return new $T($T._deploy($L,$L,$L,$L,$L))", new Object[]{className, DefaultScoreClient.class, paramNameMap.get(PARAM_URL), paramNameMap.get(PARAM_NID), paramNameMap.get(PARAM_WALLET), paramNameMap.get(PARAM_SCORE_FILE_PATH), paramsCodeblock != null || parameterSpecs == null ? paramNameMap.get(PARAM_PARAMS) : "null"}).build();
        return builder.build();
    }

    private MethodSpec ofMethodSpec(ClassName className, List<ParameterSpec> parameterSpecs, CodeBlock paramsCodeblock) {
        Map<String, String> paramNameMap = ScoreClientProcessor.newParameterNameMap(parameterSpecs, PARAM_PREFIX, PARAM_PROPERTEIS, PARAM_PARAMS);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)METHOD_OF).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(ParameterSpec.builder(String.class, (String)paramNameMap.get(PARAM_PREFIX), (Modifier[])new Modifier[0]).build()).addParameter(ParameterSpec.builder(Properties.class, (String)paramNameMap.get(PARAM_PROPERTEIS), (Modifier[])new Modifier[0]).build()).returns((TypeName)className);
        if (parameterSpecs == null) {
            builder.addParameter(ParameterSpec.builder((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, Object.class}), (String)PARAM_PARAMS, (Modifier[])new Modifier[0]).build());
        } else {
            builder.addParameters(parameterSpecs);
        }
        if (paramsCodeblock != null) {
            builder.addCode(paramsCodeblock);
        }
        builder.addStatement("return new $T($T.of($L, $L, $L))", new Object[]{className, DefaultScoreClient.class, paramNameMap.get(PARAM_PREFIX), paramNameMap.get(PARAM_PROPERTEIS), paramsCodeblock != null || parameterSpecs == null ? paramNameMap.get(PARAM_PARAMS) : "null"}).build();
        return builder.build();
    }

    private List<TypeSpec> eventTypes(TypeElement element) {
        ArrayList<TypeSpec> types = new ArrayList<TypeSpec>();
        TypeMirror superClass = element.getSuperclass();
        if (!superClass.getKind().equals((Object)TypeKind.NONE) && !superClass.toString().equals(Object.class.getName())) {
            this.messager.noteMessage("superClass[kind:%s, name:%s]", new Object[]{superClass.getKind().name(), superClass.toString()});
            List<TypeSpec> superEvents = this.eventTypes(super.getTypeElement(element.getSuperclass()));
            this.addEventTypes(types, superEvents, element);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement infElement = super.getTypeElement(typeMirror);
            List<TypeSpec> infEvents = this.eventTypes(infElement);
            this.addEventTypes(types, infEvents, element);
        }
        for (Element element2 : element.getEnclosedElements()) {
            ExecutableElement ee;
            EventLog eventLog;
            if (!ElementKind.METHOD.equals((Object)element2.getKind()) || !ProcessorUtil.hasModifier((Element)element2, (Modifier[])new Modifier[]{Modifier.PUBLIC}) || ProcessorUtil.hasModifier((Element)element2, (Modifier[])new Modifier[]{Modifier.STATIC}) || (eventLog = (ee = (ExecutableElement)element2).getAnnotation(EventLog.class)) == null) continue;
            TypeSpec eventTypeSpec = this.eventTypeSpec(ee, element);
            this.addEventType(types, eventTypeSpec, element);
        }
        return types;
    }

    private void addEventTypes(List<TypeSpec> types, List<TypeSpec> typeSpecs, TypeElement element) {
        for (TypeSpec typeSpec : typeSpecs) {
            this.addEventType(types, typeSpec, element);
        }
    }

    private void addEventType(List<TypeSpec> types, TypeSpec typeSpec, TypeElement element) {
        if (typeSpec != null) {
            for (TypeSpec type : types) {
                if (!type.name.equals(typeSpec.name)) continue;
                this.messager.warningMessage("Redeclare '%s' in %s", new Object[]{type.name, element.getQualifiedName()});
                types.remove(type);
                break;
            }
            types.add(typeSpec);
        }
    }

    private TypeSpec eventTypeSpec(ExecutableElement ee, Element element) {
        String methodName = ee.getSimpleName().toString();
        String className = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        String FIELD_SIGNATURE = "SIGNATURE";
        String FIELD_INDEXED = "INDEXED";
        String PARAM_EVENTLOG = "el";
        String EVENTLOG_INDEXED = "indexed";
        String EVENTLOG_DATA = "data";
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addParameter(TransactionResult.EventLog.class, PARAM_EVENTLOG, new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("$T<String> $L = $L.getIndexed()", new Object[]{List.class, EVENTLOG_INDEXED, PARAM_EVENTLOG}).addStatement("$T<String> $L = $L.getData()", new Object[]{List.class, EVENTLOG_DATA, PARAM_EVENTLOG});
        StringJoiner joiner = new StringJoiner(",");
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        ArrayList<MethodSpec> getters = new ArrayList<MethodSpec>();
        int indexed = ee.getAnnotation(EventLog.class).indexed();
        boolean isIndex = true;
        int i = 1;
        for (VariableElement variableElement : ee.getParameters()) {
            ParameterSpec ps = ParameterSpec.get((VariableElement)variableElement);
            String eventTypeString = eventTypeStrings.get(ps.type.toString());
            if (eventTypeString == null) {
                throw new RuntimeException("not allowed event parameter type, element:" + element + ", method:" + methodName + ", argument:" + ps);
            }
            joiner.add(eventTypeString);
            fields.add(FieldSpec.builder((TypeName)ps.type, (String)ps.name, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            if (isIndex && i > indexed) {
                isIndex = false;
                i = 0;
            }
            String argGetter = String.format("%s.get(%d)", isIndex ? EVENTLOG_INDEXED : EVENTLOG_DATA, i++);
            if (ps.type.toString().equals("java.lang.String")) {
                constructorBuilder.addStatement("this.$L=$L", new Object[]{ps.name, argGetter});
            } else {
                constructorBuilder.addStatement(String.format(eventConverts.get(ps.type.toString()), argGetter), new Object[]{ps.name, IconStringConverter.class});
            }
            getters.add(MethodSpec.methodBuilder((String)("get" + ps.name.substring(0, 1).toUpperCase() + ps.name.substring(1))).returns(ps.type).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return this.$L", new Object[]{ps.name}).build());
        }
        builder.addField(FieldSpec.builder(String.class, (String)FIELD_SIGNATURE, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("\"$L($L)\"", new Object[]{methodName, joiner.toString()}).build());
        builder.addField(FieldSpec.builder(Integer.TYPE, (String)FIELD_INDEXED, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$L", new Object[]{indexed}).build());
        builder.addFields(fields);
        builder.addMethod(constructorBuilder.build());
        builder.addMethods(getters);
        ParameterizedTypeName listEventType = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)className)});
        builder.addMethod(MethodSpec.methodBuilder((String)METHOD_EVENT_LOGS).addParameter(TransactionResult.class, PARAM_TXR, new Modifier[0]).addParameter(Address.class, PARAM_ADDRESS, new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Predicate.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)className)}), PARAM_FILTER, new Modifier[0]).returns((TypeName)listEventType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addStatement("return $T.eventLogs($L, $L, $L, $L::new, $L)", new Object[]{DefaultScoreClient.class, PARAM_TXR, FIELD_SIGNATURE, PARAM_ADDRESS, className, PARAM_FILTER}).build());
        return builder.build();
    }

    private MethodSpec eventConsumerMethodSpec(ExecutableElement ee) {
        String methodName = ee.getSimpleName().toString();
        String className = methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
        TypeVariableName classTypeName = TypeVariableName.get((String)className);
        ParameterizedTypeName listEventType = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{classTypeName});
        return MethodSpec.methodBuilder((String)methodName).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{listEventType}), PARAM_CONSUMER, new Modifier[0]).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Predicate.class), (TypeName[])new TypeName[]{classTypeName}), PARAM_FILTER, new Modifier[0]).returns((TypeName)ParameterizedTypeName.get(Consumer.class, (Type[])new Type[]{TransactionResult.class})).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return ($L) -> $L.accept($L.$L($L, this.address, $L))", new Object[]{PARAM_TXR, PARAM_CONSUMER, className, METHOD_EVENT_LOGS, PARAM_TXR, PARAM_FILTER}).build();
    }
}

