/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.score.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import foundation.icon.annotation_processor.AbstractProcessor;
import foundation.icon.annotation_processor.ProcessorUtil;
import foundation.icon.score.client.ScoreInterface;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import score.Address;
import score.Context;
import score.annotation.EventLog;
import score.annotation.External;
import score.annotation.Payable;

public class ScoreInterfaceProcessor
extends AbstractProcessor {
    static final String MEMBER_ADDRESS = "address";
    static final String PARAM_PAYABLE_VALUE = "valueForPayable";

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
    }

    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> s = new HashSet<String>();
        s.add(ScoreInterface.class.getCanonicalName());
        return s;
    }

    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean ret = false;
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotationElements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : annotationElements) {
                if (element.getKind().isInterface() || element.getKind().isClass()) {
                    this.messager.noteMessage("process %s %s", new Object[]{element.getKind(), element.asType(), element.getSimpleName()});
                    this.generateImplementClass(this.processingEnv.getFiler(), (TypeElement)element);
                    ret = true;
                    continue;
                }
                throw new RuntimeException("not support, element:" + element);
            }
        }
        return ret;
    }

    private void generateImplementClass(Filer filer, Element element) {
        if (!(element instanceof TypeElement)) {
            throw new RuntimeException("not support, element:" + element);
        }
        TypeElement typeElement = (TypeElement)element;
        ClassName elementClassName = ClassName.get((TypeElement)typeElement);
        String suffix = element.getAnnotation(ScoreInterface.class).suffix();
        ClassName className = ClassName.get((String)elementClassName.packageName(), (String)(elementClassName.simpleName() + suffix), (String[])new String[0]);
        TypeSpec typeSpec = this.typeSpec(className, typeElement);
        JavaFile javaFile = JavaFile.builder((String)className.packageName(), (TypeSpec)typeSpec).build();
        try {
            javaFile.writeTo(filer);
        }
        catch (IOException e) {
            this.messager.warningMessage("create javaFile error : %s", new Object[]{e.getMessage()});
        }
    }

    private TypeSpec typeSpec(ClassName className, TypeElement element) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterfaces((Iterable)ProcessorUtil.getSuperinterfaces((TypeElement)element));
        if (element.getKind().isInterface()) {
            builder.addSuperinterface(element.asType());
        }
        builder.addField(Address.class, MEMBER_ADDRESS, new Modifier[]{Modifier.PROTECTED, Modifier.FINAL});
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder(Address.class, (String)MEMBER_ADDRESS, (Modifier[])new Modifier[0]).build()).addStatement("this.$L = $L", new Object[]{MEMBER_ADDRESS, MEMBER_ADDRESS}).build());
        String addressGetter = element.getAnnotation(ScoreInterface.class).addressGetter();
        builder.addMethod(MethodSpec.methodBuilder((String)addressGetter).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Address.class).addStatement("return this.$L", new Object[]{MEMBER_ADDRESS}).build());
        List<MethodSpec> methods = this.overrideMethods(element);
        builder.addMethods(methods);
        return builder.build();
    }

    private List<MethodSpec> overrideMethods(TypeElement element) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        TypeMirror superClass = element.getSuperclass();
        if (!superClass.getKind().equals((Object)TypeKind.NONE) && !superClass.toString().equals(Object.class.getName())) {
            this.messager.noteMessage("superClass[kind:%s, name:%s]", new Object[]{superClass.getKind().name(), superClass.toString()});
            List<MethodSpec> superMethods = this.overrideMethods(super.getTypeElement(element.getSuperclass()));
            this.addMethods(methods, superMethods, element);
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement typeElement = super.getTypeElement(typeMirror);
            List<MethodSpec> infMethods = this.overrideMethods(typeElement);
            this.addMethods(methods, infMethods, element);
        }
        boolean mustGenerate = element.getKind().isInterface();
        for (Element element2 : element.getEnclosedElements()) {
            boolean readonly;
            ExecutableElement ee;
            External external;
            if (!ElementKind.METHOD.equals((Object)element2.getKind()) || !ProcessorUtil.hasModifier((Element)element2, (Modifier[])new Modifier[]{Modifier.PUBLIC}) || ProcessorUtil.hasModifier((Element)element2, (Modifier[])new Modifier[]{Modifier.STATIC}) || (external = (ee = (ExecutableElement)element2).getAnnotation(External.class)) == null && !mustGenerate) continue;
            MethodSpec methodSpec = this.methodSpec(ee);
            this.addMethod(methods, methodSpec, element);
            boolean bl = external != null ? external.readonly() : (readonly = !methodSpec.returnType.equals((Object)TypeName.VOID));
            if (ee.getAnnotation(Payable.class) == null) continue;
            if (readonly) {
                this.messager.warningMessage("Method annotated @Payable cannot be readonly '%s' in %s", new Object[]{ee, element.getQualifiedName()});
                continue;
            }
            this.addMethod(methods, this.payableMethodSpec(ee, methodSpec), element);
        }
        return methods;
    }

    private void addMethods(List<MethodSpec> methods, List<MethodSpec> methodSpecs, TypeElement element) {
        for (MethodSpec methodSpec : methodSpecs) {
            this.addMethod(methods, methodSpec, element);
        }
    }

    private void addMethod(List<MethodSpec> methods, MethodSpec methodSpec, TypeElement element) {
        if (methodSpec != null) {
            MethodSpec conflictMethod = ProcessorUtil.getConflictMethod(methods, (MethodSpec)methodSpec);
            if (conflictMethod != null) {
                methods.remove(conflictMethod);
                this.messager.warningMessage("Redeclare '%s %s(%s)' in %s", new Object[]{conflictMethod.returnType.toString(), conflictMethod.name, ProcessorUtil.parameterSpecToString((List)conflictMethod.parameters), element.getQualifiedName()});
            }
            methods.add(methodSpec);
        }
    }

    private String callParameters(ExecutableElement element) {
        StringJoiner variables = new StringJoiner(", ");
        variables.add(String.format("this.%s", MEMBER_ADDRESS));
        variables.add(String.format("\"%s\"", element.getSimpleName().toString()));
        for (VariableElement variableElement : element.getParameters()) {
            variables.add("(Object)" + variableElement.getSimpleName().toString());
        }
        return variables.toString();
    }

    private MethodSpec methodSpec(ExecutableElement ee) {
        if (ee.getAnnotation(EventLog.class) != null) {
            return this.notSupportedMethod(ee, "not supported EventLog method");
        }
        String methodName = ee.getSimpleName().toString();
        TypeMirror returnType = ee.getReturnType();
        TypeName returnTypeName = TypeName.get((TypeMirror)returnType);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addModifiers(ProcessorUtil.getModifiers((Element)ee, (Modifier[])new Modifier[]{Modifier.ABSTRACT, Modifier.DEFAULT})).addParameters((Iterable)ProcessorUtil.getParameterSpecs((ExecutableElement)ee)).returns(returnTypeName);
        String callParameters = this.callParameters(ee);
        if (returnTypeName.equals((Object)TypeName.VOID)) {
            builder.addStatement("$T.call($L)", new Object[]{Context.class, callParameters});
        } else if (returnType.getKind().equals((Object)TypeKind.DECLARED) && ((DeclaredType)returnType).getTypeArguments().size() > 0) {
            builder.addStatement("return ($T)$T.call($L)", new Object[]{returnTypeName, Context.class, callParameters});
        } else {
            builder.addStatement("return $T.call($T.class, $L)", new Object[]{Context.class, returnTypeName, callParameters});
        }
        return builder.build();
    }

    static String newParameterName(Set<String> nameSet, String name) {
        return nameSet != null && nameSet.contains(name) ? ScoreInterfaceProcessor.newParameterName(nameSet, "_" + name) : name;
    }

    static Map<String, String> newParameterNameMap(List<ParameterSpec> parameterSpecs, String ... names) {
        Set<String> nameSet = parameterSpecs == null ? null : parameterSpecs.stream().map(v -> v.name).collect(Collectors.toSet());
        HashMap<String, String> nameMap = new HashMap<String, String>();
        for (String name : names) {
            nameMap.put(name, ScoreInterfaceProcessor.newParameterName(nameSet, name));
        }
        return nameMap;
    }

    private MethodSpec payableMethodSpec(ExecutableElement ee, MethodSpec methodSpec) {
        Map<String, String> paramNameMap = ScoreInterfaceProcessor.newParameterNameMap(methodSpec.parameters, PARAM_PAYABLE_VALUE);
        String paramPayableValue = paramNameMap.get(PARAM_PAYABLE_VALUE);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodSpec.name).addModifiers((Iterable)methodSpec.modifiers).addParameter(BigInteger.class, paramPayableValue, new Modifier[0]).addParameters((Iterable)methodSpec.parameters).returns(methodSpec.returnType);
        String callParameters = this.callParameters(ee);
        TypeMirror returnType = ee.getReturnType();
        if (methodSpec.returnType.equals((Object)TypeName.VOID)) {
            builder.addStatement("$T.call($L, $L)", new Object[]{Context.class, paramPayableValue, callParameters});
        } else if (returnType.getKind().equals((Object)TypeKind.DECLARED) && ((DeclaredType)returnType).getTypeArguments().size() > 0) {
            builder.addStatement("return ($T)$T.call($L, $L)", new Object[]{methodSpec.returnType, Context.class, paramPayableValue, callParameters});
        } else {
            builder.addStatement("return $T.call($T.class, $L, $L)", new Object[]{Context.class, methodSpec.returnType, paramPayableValue, callParameters});
        }
        return builder.build();
    }

    private MethodSpec notSupportedMethod(ExecutableElement ee, String msg) {
        String methodName = ee.getSimpleName().toString();
        TypeName returnTypeName = TypeName.get((TypeMirror)ee.getReturnType());
        return MethodSpec.methodBuilder((String)methodName).addModifiers(ProcessorUtil.getModifiers((Element)ee, (Modifier[])new Modifier[]{Modifier.ABSTRACT, Modifier.DEFAULT})).addParameters((Iterable)ProcessorUtil.getParameterSpecs((ExecutableElement)ee)).returns(returnTypeName).addStatement("throw new $T(\"$L\")", new Object[]{RuntimeException.class, msg}).addJavadoc("@deprecated Do not use this method, this is generated only for preventing compile error. $L\n", new Object[]{msg}).addJavadoc("@throws $L", new Object[]{RuntimeException.class.getName()}).addAnnotation(Deprecated.class).build();
    }
}

