/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.score.client;

import foundation.icon.icx.KeyWallet;
import foundation.icon.icx.crypto.KeystoreException;
import foundation.icon.jsonrpc.Address;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class Wallet {
    private final KeyWallet wallet;
    private final byte[] publicKey;
    private final Address address;

    public Wallet(KeyWallet wallet) {
        this.wallet = wallet;
        this.publicKey = wallet.getPublicKey().toByteArray();
        this.address = new Address(wallet.getAddress().toString());
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public Address getAddress() {
        return this.address;
    }

    public byte[] sign(byte[] data) {
        return this.wallet.sign(data);
    }

    public KeyWallet getWallet() {
        return this.wallet;
    }

    public static Wallet load(String password, File file) {
        try {
            return new Wallet(KeyWallet.load((String)password, (File)file));
        }
        catch (KeystoreException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Wallet generate() {
        try {
            return new Wallet(KeyWallet.create());
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }
}

