/*
 * Decompiled with CFR 0.152.
 */
package scorex.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import scorex.util.AbstractList;

public class ArrayList<E>
extends AbstractList<E>
implements List<E> {
    private Object[] elementData;
    private int size;

    public ArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elementData = new Object[initialCapacity];
    }

    public ArrayList() {
        this(10);
    }

    public ArrayList(Collection<? extends E> c) {
        this.elementData = c.toArray();
        this.size = this.elementData.length;
    }

    public void trimToSize() {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (this.size < oldCapacity) {
            Object[] oldData = this.elementData;
            this.elementData = new Object[this.size];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    public void ensureCapacity(int minCapacity) {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object elem) {
        return this.indexOf(elem) >= 0;
    }

    @Override
    public int indexOf(Object elem) {
        if (elem == null) {
            for (int i = 0; i < this.size; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (!elem.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object elem) {
        if (elem == null) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = this.size - 1; i >= 0; --i) {
                if (!elem.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size];
        System.arraycopy(this.elementData, 0, result, 0, this.size);
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    private void rangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private void rangeCheckForAdd(int index) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private E elementData(int index) {
        return (E)this.elementData[index];
    }

    @Override
    public E get(int index) {
        this.rangeCheck(index);
        return this.elementData(index);
    }

    @Override
    public E set(int index, E element) {
        this.rangeCheck(index);
        E oldValue = this.elementData(index);
        this.elementData[index] = element;
        return oldValue;
    }

    @Override
    public boolean add(E e) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = e;
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.rangeCheckForAdd(index);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elementData, index, this.elementData, index + 1, this.size - index);
        this.elementData[index] = element;
        ++this.size;
    }

    @Override
    public E remove(int index) {
        this.rangeCheck(index);
        E oldValue = this.elementData(index);
        this.fastRemove(index);
        return oldValue;
    }

    @Override
    public boolean remove(Object o) {
        if (o == null) {
            for (int index = 0; index < this.size; ++index) {
                if (this.elementData[index] != null) continue;
                this.fastRemove(index);
                return true;
            }
        } else {
            for (int index = 0; index < this.size; ++index) {
                if (!o.equals(this.elementData[index])) continue;
                this.fastRemove(index);
                return true;
            }
        }
        return false;
    }

    private void fastRemove(int index) {
        ++this.modCount;
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacity(this.size + numNew);
        System.arraycopy(a, 0, this.elementData, this.size, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.rangeCheckForAdd(index);
        Object[] a = c.toArray();
        int numNew = a.length;
        this.ensureCapacity(this.size + numNew);
        int numMoved = this.size - index;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index, this.elementData, index + numNew, numMoved);
        }
        System.arraycopy(a, 0, this.elementData, index, numNew);
        this.size += numNew;
        return numNew != 0;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        ++this.modCount;
        int numMoved = this.size - toIndex;
        System.arraycopy(this.elementData, toIndex, this.elementData, fromIndex, numMoved);
        int newSize = this.size - (toIndex - fromIndex);
        while (this.size != newSize) {
            this.elementData[--this.size] = null;
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.batchRemove(c, false);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.batchRemove(c, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean batchRemove(Collection<?> c, boolean complement) {
        boolean modified;
        int w;
        block8: {
            int r;
            Object[] elementData = this.elementData;
            w = 0;
            modified = false;
            try {
                for (r = 0; r < this.size; ++r) {
                    if (c.contains(elementData[r]) != complement) continue;
                    elementData[w++] = elementData[r];
                }
                if (r == this.size) break block8;
            }
            catch (Throwable throwable) {
                if (r != this.size) {
                    System.arraycopy(elementData, r, elementData, w, this.size - r);
                    w += this.size - r;
                }
                if (w != this.size) {
                    for (int i = w; i < this.size; ++i) {
                        elementData[i] = null;
                    }
                    this.modCount += this.size - w;
                    this.size = w;
                    modified = true;
                }
                throw throwable;
            }
            System.arraycopy(elementData, r, elementData, w, this.size - r);
            w += this.size - r;
        }
        if (w != this.size) {
            for (int i = w; i < this.size; ++i) {
                elementData[i] = null;
            }
            this.modCount += this.size - w;
            this.size = w;
            modified = true;
        }
        return modified;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        ArrayList.subListRangeCheck(fromIndex, toIndex, this.size);
        return new SubList(this, 0, fromIndex, toIndex);
    }

    static void subListRangeCheck(int fromIndex, int toIndex, int size) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > size) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
    }

    private class SubList
    extends AbstractList<E> {
        private final AbstractList<E> parent;
        private final int parentOffset;
        private final int offset;
        private int size;

        SubList(AbstractList<E> parent, int offset, int fromIndex, int toIndex) {
            this.parent = parent;
            this.parentOffset = fromIndex;
            this.offset = offset + fromIndex;
            this.size = toIndex - fromIndex;
            this.modCount = ArrayList.this.modCount;
        }

        @Override
        public E set(int index, E e) {
            this.rangeCheck(index);
            this.checkForComodification();
            Object oldValue = ArrayList.this.elementData(this.offset + index);
            ArrayList.this.elementData[this.offset + index] = e;
            return oldValue;
        }

        @Override
        public E get(int index) {
            this.rangeCheck(index);
            this.checkForComodification();
            return ArrayList.this.elementData(this.offset + index);
        }

        @Override
        public int size() {
            this.checkForComodification();
            return this.size;
        }

        @Override
        public void add(int index, E e) {
            this.rangeCheckForAdd(index);
            this.checkForComodification();
            this.parent.add(this.parentOffset + index, e);
            this.modCount = this.parent.modCount;
            ++this.size;
        }

        @Override
        public E remove(int index) {
            this.rangeCheck(index);
            this.checkForComodification();
            Object result = this.parent.remove(this.parentOffset + index);
            this.modCount = this.parent.modCount;
            --this.size;
            return result;
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.checkForComodification();
            this.parent.removeRange(this.parentOffset + fromIndex, this.parentOffset + toIndex);
            this.modCount = this.parent.modCount;
            this.size -= toIndex - fromIndex;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.addAll(this.size, c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            this.rangeCheckForAdd(index);
            int cSize = c.size();
            if (cSize == 0) {
                return false;
            }
            this.checkForComodification();
            this.parent.addAll(this.parentOffset + index, c);
            this.modCount = this.parent.modCount;
            this.size += cSize;
            return true;
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            this.checkForComodification();
            this.rangeCheckForAdd(index);
            return new ListIterator<E>(){
                int cursor;
                int lastRet;
                int expectedModCount;
                {
                    this.cursor = index;
                    this.lastRet = -1;
                    this.expectedModCount = ArrayList.this.modCount;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor != SubList.this.size;
                }

                @Override
                public E next() {
                    this.checkForComodification();
                    int i = this.cursor;
                    if (i >= SubList.this.size) {
                        throw new NoSuchElementException();
                    }
                    Object[] elementData = ArrayList.this.elementData;
                    if (SubList.this.offset + i >= elementData.length) {
                        throw new RuntimeException();
                    }
                    this.cursor = i + 1;
                    this.lastRet = i;
                    return elementData[SubList.this.offset + this.lastRet];
                }

                @Override
                public boolean hasPrevious() {
                    return this.cursor != 0;
                }

                @Override
                public E previous() {
                    this.checkForComodification();
                    int i = this.cursor - 1;
                    if (i < 0) {
                        throw new NoSuchElementException();
                    }
                    Object[] elementData = ArrayList.this.elementData;
                    if (SubList.this.offset + i >= elementData.length) {
                        throw new RuntimeException();
                    }
                    this.cursor = i;
                    this.lastRet = i;
                    return elementData[SubList.this.offset + this.lastRet];
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        SubList.this.remove(this.lastRet);
                        this.cursor = this.lastRet;
                        this.lastRet = -1;
                        this.expectedModCount = ArrayList.this.modCount;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new RuntimeException();
                    }
                }

                @Override
                public void set(E e) {
                    if (this.lastRet < 0) {
                        throw new IllegalStateException();
                    }
                    this.checkForComodification();
                    try {
                        ArrayList.this.set(SubList.this.offset + this.lastRet, e);
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new RuntimeException();
                    }
                }

                @Override
                public void add(E e) {
                    this.checkForComodification();
                    try {
                        int i = this.cursor;
                        SubList.this.add(i, e);
                        this.cursor = i + 1;
                        this.lastRet = -1;
                        this.expectedModCount = ArrayList.this.modCount;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new RuntimeException();
                    }
                }

                final void checkForComodification() {
                    if (this.expectedModCount != ArrayList.this.modCount) {
                        throw new RuntimeException();
                    }
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            ArrayList.subListRangeCheck(fromIndex, toIndex, this.size);
            return new SubList(this, this.offset, fromIndex, toIndex);
        }

        private void rangeCheck(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
            }
        }

        private void rangeCheckForAdd(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(index));
            }
        }

        private String outOfBoundsMsg(int index) {
            return "Index: " + index + ", Size: " + this.size;
        }

        private void checkForComodification() {
            if (ArrayList.this.modCount != this.modCount) {
                throw new RuntimeException();
            }
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            int i = this.cursor - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            Object[] elementData = ArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new RuntimeException();
            }
            this.cursor = i;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayList.this.set(this.lastRet, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new RuntimeException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int i = this.cursor;
                ArrayList.this.add(i, e);
                this.cursor = i + 1;
                this.lastRet = -1;
                this.expectedModCount = ArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new RuntimeException();
            }
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = ArrayList.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ArrayList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            int i = this.cursor;
            if (i >= ArrayList.this.size) {
                throw new NoSuchElementException();
            }
            Object[] elementData = ArrayList.this.elementData;
            if (i >= elementData.length) {
                throw new RuntimeException();
            }
            this.cursor = i + 1;
            this.lastRet = i;
            return elementData[this.lastRet];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ArrayList.this.remove(this.lastRet);
                this.cursor = this.lastRet;
                this.lastRet = -1;
                this.expectedModCount = ArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new RuntimeException();
            }
        }

        final void checkForComodification() {
            if (ArrayList.this.modCount != this.expectedModCount) {
                throw new RuntimeException();
            }
        }
    }
}

