/*
 * Decompiled with CFR 0.152.
 */
package scorex.util;

import java.util.NoSuchElementException;

public class StringTokenizer {
    private int currentPosition = 0;
    private int newPosition = -1;
    private final int maxPosition;
    private final String str;
    private final String delimiters;

    public StringTokenizer(String str, String delim) {
        this.str = str;
        this.maxPosition = str.length();
        this.delimiters = delim;
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    public String nextToken() {
        this.currentPosition = this.newPosition >= 0 ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        return this.str.substring(start, this.currentPosition);
    }

    public int countTokens() {
        int count = 0;
        int currpos = this.currentPosition;
        while (currpos < this.maxPosition && (currpos = this.skipDelimiters(currpos)) < this.maxPosition) {
            currpos = this.scanToken(currpos);
            ++count;
        }
        return count;
    }

    private int skipDelimiters(int startPos) {
        char c;
        int position;
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        for (position = startPos; position < this.maxPosition && this.delimiters.indexOf(c = this.str.charAt(position)) >= 0; ++position) {
        }
        return position;
    }

    private int scanToken(int startPos) {
        char c;
        int position;
        for (position = startPos; position < this.maxPosition && this.delimiters.indexOf(c = this.str.charAt(position)) < 0; ++position) {
        }
        return position;
    }
}

