/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.tooling.deploy;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarInputStream;
import org.aion.avm.tooling.deploy.ClassDependencyVisitor;
import org.aion.avm.tooling.deploy.DependencyCollector;
import org.aion.avm.tooling.deploy.SignatureDependencyVisitor;
import org.aion.avm.utilities.JarBuilder;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class JarOptimizer {
    private static final boolean loggingEnabled = false;
    private final boolean preserveDebugInfo;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Input the path to the jar file.");
            System.exit(0);
        }
        JarOptimizer optimizer = new JarOptimizer(false);
        try (FileInputStream fileInputStream = new FileInputStream(args[0]);){
            byte[] optimizedJarBytes = optimizer.optimize(fileInputStream.readAllBytes());
            int pathLength = args[0].lastIndexOf("/") + 1;
            String outputJarName = args[0].substring(0, pathLength) + "minimized_" + args[0].substring(pathLength);
            optimizer.writeOptimizedJar(outputJarName, optimizedJarBytes);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public JarOptimizer(boolean preserveDebugInfo) {
        this.preserveDebugInfo = preserveDebugInfo;
    }

    public byte[] optimize(byte[] jarBytes) {
        HashSet<String> visitedClasses = new HashSet<String>();
        try {
            JarInputStream jarReader = new JarInputStream((InputStream)new ByteArrayInputStream(jarBytes), true);
            String mainClassName = Utilities.extractMainClassName((JarInputStream)jarReader, (Utilities.NameStyle)Utilities.NameStyle.DOT_NAME);
            Map classMap = Utilities.extractClasses((JarInputStream)jarReader, (Utilities.NameStyle)Utilities.NameStyle.DOT_NAME);
            this.traverse(mainClassName, visitedClasses, classMap);
            return this.buildOptimizedJar(visitedClasses, classMap, mainClassName);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public byte[] optimize(byte[] jarBytes, Collection<String> rootClasses) {
        HashSet<String> visitedClasses = new HashSet<String>();
        try {
            JarInputStream jarReader = new JarInputStream((InputStream)new ByteArrayInputStream(jarBytes), true);
            String mainClassName = Utilities.extractMainClassName((JarInputStream)jarReader, (Utilities.NameStyle)Utilities.NameStyle.DOT_NAME);
            Map classMap = Utilities.extractClasses((JarInputStream)jarReader, (Utilities.NameStyle)Utilities.NameStyle.DOT_NAME);
            for (String c : rootClasses) {
                this.traverse(c, visitedClasses, classMap);
            }
            return this.buildOptimizedJar(visitedClasses, classMap, mainClassName);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void traverse(String className, Set<String> visitedClasses, Map<String, byte[]> classMap) {
        visitedClasses.add(className);
        Set<String> referencedClasses = this.visitClass(className, classMap);
        for (String c : referencedClasses) {
            if (!classMap.containsKey(c) || visitedClasses.contains(c)) continue;
            this.traverse(c, visitedClasses, classMap);
        }
    }

    private Set<String> visitClass(String className, Map<String, byte[]> classMap) {
        DependencyCollector dependencyCollector = new DependencyCollector();
        ClassReader reader = new ClassReader(classMap.get(className));
        SignatureDependencyVisitor signatureVisitor = new SignatureDependencyVisitor(dependencyCollector);
        ClassWriter writer = new ClassWriter(1);
        ClassDependencyVisitor classVisitor = new ClassDependencyVisitor(signatureVisitor, dependencyCollector, writer, this.preserveDebugInfo);
        reader.accept((ClassVisitor)classVisitor, 0);
        classMap.put(className, writer.toByteArray());
        return dependencyCollector.getDependencies();
    }

    private byte[] buildOptimizedJar(final Set<String> visitedClasses, Map<String, byte[]> classMap, String mainClassName) {
        classMap.entrySet().removeIf(e -> !visitedClasses.contains(e.getKey()));
        for (String className : visitedClasses) {
            ClassReader reader = new ClassReader(classMap.get(className));
            ClassWriter writer = new ClassWriter(1);
            ClassVisitor classVisitor = new ClassVisitor(458752, (ClassVisitor)writer){

                public void visitNestHost(String nestHost) {
                    if (visitedClasses.contains(Utilities.internalNameToFullyQualifiedName((String)nestHost))) {
                        super.visitNestHost(nestHost);
                    }
                }

                public void visitNestMember(String nestMember) {
                    if (visitedClasses.contains(Utilities.internalNameToFullyQualifiedName((String)nestMember))) {
                        super.visitNestMember(nestMember);
                    }
                }

                public void visitInnerClass(String name, String outerName, String innerName, int access) {
                }
            };
            reader.accept(classVisitor, 0);
            classMap.replace(className, writer.toByteArray());
        }
        JarOptimizer.assertTrue(classMap.entrySet().size() == visitedClasses.size());
        byte[] mainClassBytes = classMap.get(mainClassName);
        classMap.remove(mainClassName, mainClassBytes);
        return JarBuilder.buildJarForExplicitClassNamesAndBytecode((String)mainClassName, (byte[])mainClassBytes, classMap, (Class[])new Class[0]);
    }

    private void writeOptimizedJar(String jarName, byte[] jarBytes) {
        try {
            DataOutputStream dout = new DataOutputStream(new FileOutputStream(jarName));
            dout.write(jarBytes);
            dout.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Successfully created jar. \n" + jarName);
    }

    private static void assertTrue(boolean flag) {
        if (!flag) {
            throw new AssertionError((Object)"Case must be true");
        }
    }

    private static /* synthetic */ void lambda$buildOptimizedJar$0(Set visitedClasses, String key, byte[] value) {
        if (!visitedClasses.contains(key)) {
            System.out.println(" - " + key);
        }
    }
}

