/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.tooling.abi;

import foundation.icon.ee.score.EEPType;
import foundation.icon.ee.struct.StructDB;
import foundation.icon.ee.tooling.abi.ABICompilerException;
import foundation.icon.ee.types.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import score.annotation.EventLog;
import score.annotation.External;
import score.annotation.Optional;
import score.annotation.Payable;

public class ABICompilerMethodVisitor
extends MethodVisitor {
    private final int access;
    private final String methodName;
    private final String methodDescriptor;
    private final List<String> paramNames = new ArrayList<String>();
    private boolean[] optional;
    private int flags;
    private int indexed;
    private boolean isOnInstall = false;
    private boolean isFallback = false;
    private boolean isEventLog = false;
    private MethodVisitor pmv = null;
    private final StructDB structDB;
    private final boolean stripLineNumber;
    private static final int MAX_INDEXED_COUNT = 3;
    private static final Set<String> reservedEventNames = Set.of("ICXTransfer", "ICXBurned", "DepositAdded", "DepositWithdrawn");

    public ABICompilerMethodVisitor(int access, String methodName, String methodDescriptor, MethodVisitor mv, StructDB structDB, boolean stripLineNumber) {
        super(458752, mv);
        this.access = access;
        this.methodName = methodName;
        this.methodDescriptor = methodDescriptor;
        if (methodName.equals("<init>") && this.checkIfPublicAndNonStatic(access)) {
            if (Type.getReturnType((String)methodDescriptor) != Type.VOID_TYPE) {
                throw new ABICompilerException("<init> method must have void return type", methodName);
            }
            this.isOnInstall = true;
        } else if (methodName.equals("fallback") && this.checkIfPublicAndNonStatic(access)) {
            if (Type.getReturnType((String)methodDescriptor) != Type.VOID_TYPE) {
                throw new ABICompilerException("fallback method must have void return type", methodName);
            }
            if (Type.getArgumentTypes((String)methodDescriptor).length != 0) {
                throw new ABICompilerException("fallback method cannot take arguments", methodName);
            }
            this.isFallback = true;
        }
        this.structDB = structDB;
        this.stripLineNumber = stripLineNumber;
    }

    public void visitParameter(String name, int access) {
        if (access == 0) {
            this.paramNames.add(name);
        }
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        if (Type.getType((String)descriptor).getClassName().equals(External.class.getName())) {
            if (!this.checkIfPublicAndNonStatic(this.access)) {
                throw new ABICompilerException("@External methods must be public and non-static", this.methodName);
            }
            this.checkArgumentsAndReturnType();
            this.flags |= 2;
            return new AnnotationVisitor(458752){

                public void visit(String name, Object value) {
                    if ("readonly".equals(name) && Boolean.TRUE.equals(value)) {
                        ABICompilerMethodVisitor.this.flags |= 1;
                    }
                }
            };
        }
        if (Type.getType((String)descriptor).getClassName().equals(Payable.class.getName())) {
            if (!this.checkIfPublicAndNonStatic(this.access)) {
                throw new ABICompilerException("@Payable methods must be public and non-static", this.methodName);
            }
            this.flags |= 4;
            return null;
        }
        if (Type.getType((String)descriptor).getClassName().equals(EventLog.class.getName())) {
            Type[] args;
            boolean isStatic;
            boolean bl = isStatic = (this.access & 8) != 0;
            if (isStatic) {
                throw new ABICompilerException("@EventLog methods must be non-static", this.methodName);
            }
            if (Type.getReturnType((String)this.methodDescriptor) != Type.VOID_TYPE) {
                throw new ABICompilerException("@EventLog methods must have void return type", this.methodName);
            }
            if (reservedEventNames.contains(this.methodName)) {
                throw new ABICompilerException("Reserved event log name", this.methodName);
            }
            if (this.isFallback()) {
                throw new ABICompilerException("fallback method cannot be eventlog", this.methodName);
            }
            for (Type t : args = Type.getArgumentTypes((String)this.methodDescriptor)) {
                if (EEPType.isValidEventParameterType((Type)t)) continue;
                throw new ABICompilerException("Bad argument type for @EventLog method", this.methodName);
            }
            this.isEventLog = true;
            return new AnnotationVisitor(458752){

                public void visit(String name, Object value) {
                    if ("indexed".equals(name) && value instanceof Integer) {
                        ABICompilerMethodVisitor.this.indexed = (Integer)value;
                    }
                }
            };
        }
        return super.visitAnnotation(descriptor, visible);
    }

    public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
        this.optional = new boolean[parameterCount];
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
        if (Type.getType((String)descriptor).getClassName().equals(Optional.class.getName())) {
            this.optional[parameter] = true;
        }
        return null;
    }

    public void visitCode() {
        super.visitCode();
        if (this.isEventLog()) {
            this.pmv = this.mv;
            this.mv = null;
        }
    }

    private void emitSetValueArrayElementString(int index, String value) {
        super.visitInsn(89);
        if (index <= 5) {
            super.visitInsn(3 + index);
        } else {
            super.visitIntInsn(16, index);
        }
        super.visitLdcInsn((Object)value);
        super.visitInsn(83);
    }

    private void emitSetValueArrayElementByArg(int index, Type argType, int argPos) {
        super.visitInsn(89);
        if (index <= 5) {
            super.visitInsn(3 + index);
        } else {
            super.visitIntInsn(16, index);
        }
        switch (argType.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                super.visitVarInsn(21, argPos);
                super.visitInsn(133);
                super.visitMethodInsn(184, "java/math/BigInteger", "valueOf", "(J)Ljava/math/BigInteger;", false);
                break;
            }
            case 7: {
                super.visitVarInsn(22, argPos);
                super.visitMethodInsn(184, "java/math/BigInteger", "valueOf", "(J)Ljava/math/BigInteger;", false);
                break;
            }
            case 9: 
            case 10: {
                super.visitVarInsn(25, argPos);
                break;
            }
            default: {
                assert (false) : "bad param type " + argType + " for @EventLog";
                break;
            }
        }
        super.visitInsn(83);
    }

    private static String getEventParamType(Type type) {
        switch (type.getSort()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                return "int";
            }
            case 1: {
                return "bool";
            }
            case 9: {
                if (type.getDescriptor().equals("[B")) {
                    return "bytes";
                }
            }
            case 10: {
                if (type.getDescriptor().equals("Ljava/lang/String;")) {
                    return "str";
                }
                if (type.getDescriptor().equals("Ljava/math/BigInteger;")) {
                    return "int";
                }
                if (!type.getDescriptor().equals("Lscore/Address;")) break;
                return "Address";
            }
        }
        assert (false) : "bad param type " + type + " for @EventLog";
        return null;
    }

    private String getEventSignature(Type[] args) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.methodName);
        sb.append("(");
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(ABICompilerMethodVisitor.getEventParamType(args[i]));
        }
        sb.append(")");
        return sb.toString();
    }

    private void emitEventLogBody(Type[] args, int argsSize) {
        int i;
        int argPos = 1;
        super.visitIntInsn(16, this.indexed + 1);
        super.visitTypeInsn(189, "java/lang/Object");
        this.emitSetValueArrayElementString(0, this.getEventSignature(args));
        for (i = 0; i < this.indexed; ++i) {
            this.emitSetValueArrayElementByArg(i + 1, args[i], argPos);
            argPos += args[i].getSize();
        }
        super.visitVarInsn(58, argsSize + 1);
        super.visitIntInsn(16, args.length - this.indexed);
        super.visitTypeInsn(189, "java/lang/Object");
        for (i = 0; i < args.length - this.indexed; ++i) {
            this.emitSetValueArrayElementByArg(i, args[this.indexed + i], argPos);
            argPos += args[this.indexed + i].getSize();
        }
        super.visitVarInsn(58, argsSize + 2);
        super.visitVarInsn(25, argsSize + 1);
        super.visitVarInsn(25, argsSize + 2);
        super.visitMethodInsn(184, "score/Context", "logEvent", "([Ljava/lang/Object;[Ljava/lang/Object;)V", false);
        super.visitInsn(177);
        super.visitMaxs(0, 0);
    }

    public void visitEnd() {
        if (this.isOnInstall() && this.flags != 0) {
            throw new ABICompilerException("<init> method cannot be annotated", this.methodName);
        }
        if (this.isFallback() && this.isExternal()) {
            throw new ABICompilerException("fallback method cannot be external", this.methodName);
        }
        if (this.isPayable() && this.isReadonly()) {
            throw new ABICompilerException("Method annotated @Payable cannot be readonly", this.methodName);
        }
        if (this.isEventLog() && this.flags != 0) {
            throw new ABICompilerException("Method annotated @EventLog cannot have other annotations", this.methodName);
        }
        if ((this.isOnInstall() || this.isExternal() || this.isEventLog()) && this.paramNames.size() != Type.getArgumentTypes((String)this.methodDescriptor).length) {
            throw new ABICompilerException("Method parameters size mismatch (must compile with '-parameters')", this.methodName);
        }
        if (this.pmv != null) {
            this.mv = this.pmv;
            this.pmv = null;
        }
        if (this.isEventLog()) {
            boolean TRACE = false;
            Type[] args = Type.getArgumentTypes((String)this.methodDescriptor);
            if (args.length >= 127) {
                throw new ABICompilerException("Too many args in @EventLog method", this.methodName);
            }
            int argsSize = (Type.getArgumentsAndReturnSizes((String)this.methodDescriptor) >> 2) - 1;
            this.emitEventLogBody(args, argsSize);
        }
        super.visitEnd();
    }

    private boolean checkIfPublicAndNonStatic(int access) {
        boolean isPublic = (access & 1) != 0;
        boolean isStatic = (access & 8) != 0;
        return isPublic && !isStatic;
    }

    private void checkArgumentsAndReturnType() {
        for (Type type : Type.getArgumentTypes((String)this.methodDescriptor)) {
            if (this.structDB.isValidParamType(type)) continue;
            throw new ABICompilerException(type.getClassName() + " is not an allowed parameter type", this.methodName);
        }
        Type returnType = Type.getReturnType((String)this.methodDescriptor);
        if (!this.structDB.isValidReturnType(returnType)) {
            throw new ABICompilerException(returnType.getClassName() + " is not an allowed return type", this.methodName);
        }
    }

    public Method getCallableMethodInfo() {
        if (this.isExternal() || this.isOnInstall()) {
            Type[] types;
            int output;
            Type type = Type.getReturnType((String)this.methodDescriptor);
            try {
                output = this.structDB.getEEPTypeFromReturnType(type);
            }
            catch (IllegalArgumentException e) {
                throw new ABICompilerException("Invalid return type: " + type.getClassName(), this.methodName);
            }
            int optionalCount = 0;
            if (this.optional != null) {
                for (int i = this.optional.length - 1; i >= 0; --i) {
                    if (!this.optional[i]) continue;
                    if (i < this.optional.length - 1 && !this.optional[i + 1]) {
                        throw new ABICompilerException("Non-optional parameter follows @Optional parameter", this.methodName);
                    }
                    ++optionalCount;
                }
            }
            for (Type t : types = Type.getArgumentTypes((String)this.methodDescriptor)) {
                this.structDB.addParameterType(t);
            }
            this.structDB.addReturnType(type);
            return Method.newFunction((String)this.methodName, (int)this.flags, (int)optionalCount, (Method.Parameter[])this.getMethodParameters(), (int)output, (String)type.getDescriptor());
        }
        if (this.isFallback() && this.isPayable()) {
            return Method.newFallback();
        }
        if (this.isEventLog()) {
            Method.Parameter[] params = this.getMethodParameters();
            if (this.indexed < 0 || this.indexed > params.length || this.indexed > 3) {
                throw new ABICompilerException("Invalid indexed count=" + this.indexed, this.methodName);
            }
            return Method.newEvent((String)this.methodName, (int)this.indexed, (Method.Parameter[])params);
        }
        return null;
    }

    private Method.Parameter[] getMethodParameters() {
        Type[] types = Type.getArgumentTypes((String)this.methodDescriptor);
        Method.Parameter[] params = new Method.Parameter[types.length];
        for (int i = 0; i < types.length; ++i) {
            params[i] = new Method.Parameter(this.paramNames.get(i), types[i].getDescriptor(), this.structDB.getDetailFromParameterType(types[i]), this.optional != null && this.optional[i]);
        }
        return params;
    }

    public boolean isExternal() {
        return (this.flags & 2) != 0;
    }

    public boolean isReadonly() {
        return (this.flags & 1) != 0;
    }

    public boolean isPayable() {
        return (this.flags & 4) != 0;
    }

    public boolean isOnInstall() {
        return this.isOnInstall;
    }

    public boolean isFallback() {
        return this.isFallback;
    }

    public boolean isEventLog() {
        return this.isEventLog;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getDescriptor() {
        return this.methodDescriptor;
    }

    public void visitLineNumber(int line, Label start) {
        if (this.stripLineNumber) {
            return;
        }
        super.visitLineNumber(line, start);
    }
}

