/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.tooling.deploy;

import org.aion.avm.tooling.deploy.DependencyCollector;
import org.aion.avm.tooling.deploy.MethodDependencyVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class ClassDependencyVisitor
extends ClassVisitor {
    private final DependencyCollector dependencyCollector;
    private final SignatureVisitor signatureVisitor;
    private final boolean preserveDebugInfo;

    public ClassDependencyVisitor(SignatureVisitor signatureVisitor, DependencyCollector dependencyCollector, ClassWriter writer, boolean preserveDebugInfo) {
        super(458752, (ClassVisitor)writer);
        this.dependencyCollector = dependencyCollector;
        this.signatureVisitor = signatureVisitor;
        this.preserveDebugInfo = preserveDebugInfo;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (signature == null) {
            this.dependencyCollector.addType(superName);
            if (interfaces != null) {
                for (String i : interfaces) {
                    this.dependencyCollector.addType(i);
                }
            }
        } else {
            new SignatureReader(signature).accept(this.signatureVisitor);
        }
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        if (signature == null) {
            this.dependencyCollector.addDescriptor(descriptor);
        } else {
            new SignatureReader(signature).acceptType(this.signatureVisitor);
        }
        return super.visitField(access, name, descriptor, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (signature == null) {
            this.dependencyCollector.addMethodDescriptor(descriptor);
        } else {
            new SignatureReader(signature).accept(this.signatureVisitor);
        }
        if (exceptions != null) {
            for (String ex : exceptions) {
                this.dependencyCollector.addType(ex);
            }
        }
        MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
        return new MethodDependencyVisitor(mv, this.signatureVisitor, this.dependencyCollector, this.preserveDebugInfo);
    }
}

