/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.tooling.deploy;

import org.aion.avm.tooling.deploy.DependencyCollector;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class MethodDependencyVisitor
extends MethodVisitor {
    private final DependencyCollector dependencyCollector;
    private final SignatureVisitor signatureVisitor;
    private final boolean preserveDebugInfo;

    public MethodDependencyVisitor(MethodVisitor mv, SignatureVisitor signatureVisitor, DependencyCollector dependencyCollector, boolean preserveDebugInfo) {
        super(458752, mv);
        this.dependencyCollector = dependencyCollector;
        this.signatureVisitor = signatureVisitor;
        this.preserveDebugInfo = preserveDebugInfo;
    }

    public void visitTypeInsn(int opcode, String type) {
        this.dependencyCollector.addType(type);
        super.visitTypeInsn(opcode, type);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.dependencyCollector.addType(owner);
        super.visitFieldInsn(opcode, owner, name, descriptor);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        this.dependencyCollector.addType(owner);
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.dependencyCollector.addType(type);
        super.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        this.dependencyCollector.addDescriptor(descriptor);
        super.visitMultiANewArrayInsn(descriptor, numDimensions);
    }

    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        if (signature == null) {
            this.dependencyCollector.addDescriptor(descriptor);
        } else {
            new SignatureReader(signature).acceptType(this.signatureVisitor);
        }
        if (this.preserveDebugInfo) {
            super.visitLocalVariable(name, descriptor, signature, start, end, index);
        }
    }

    public void visitLdcInsn(Object value) {
        if (value instanceof Type) {
            Type t = (Type)value;
            String desc = null;
            if (t.getSort() == 10) {
                desc = t.getDescriptor();
            } else if (t.getSort() == 9) {
                desc = t.getElementType().getDescriptor();
            }
            if (desc != null) {
                this.dependencyCollector.addDescriptor(desc);
            }
        }
        super.visitLdcInsn(value);
    }

    public void visitLineNumber(int line, Label start) {
        if (this.preserveDebugInfo) {
            super.visitLineNumber(line, start);
        }
    }
}

