/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.tooling.deploy.eliminator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aion.avm.tooling.deploy.eliminator.AllowlistPopulator;
import org.aion.avm.tooling.deploy.eliminator.ClassDependencyVisitor;
import org.aion.avm.tooling.deploy.eliminator.ClassInfo;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class JarDependencyCollector {
    private final List<ClassDependencyVisitor> classVisitors = new ArrayList<ClassDependencyVisitor>();
    private final Map<String, ClassInfo> classInfoMap = AllowlistPopulator.getClassInfoMap();

    public static Map<String, ClassInfo> getClassInfoMap(Map<String, byte[]> classMap) {
        JarDependencyCollector jarDependencyCollector = new JarDependencyCollector(classMap);
        return jarDependencyCollector.getClassInfoMap();
    }

    private JarDependencyCollector(Map<String, byte[]> classMap) {
        for (Map.Entry<String, byte[]> entry : classMap.entrySet()) {
            this.visitClass(entry.getKey(), entry.getValue());
        }
        this.setParentsAndChildren();
    }

    private void visitClass(String classSlashName, byte[] classBytes) {
        ClassReader reader = new ClassReader(classBytes);
        ClassDependencyVisitor classVisitor = new ClassDependencyVisitor(classSlashName);
        this.classVisitors.add(classVisitor);
        reader.accept((ClassVisitor)classVisitor, 0);
        ClassInfo classInfo = new ClassInfo(classSlashName, classVisitor.isInterface(), classVisitor.isAbstract(), classVisitor.getMethodMap(), classVisitor.getAlwaysReachables());
        this.classInfoMap.put(classSlashName, classInfo);
    }

    private void setParentsAndChildren() {
        for (ClassDependencyVisitor visitor : this.classVisitors) {
            String classSlashName = visitor.getClassSlashName();
            String superSlashName = visitor.getSuperSlashName();
            String[] interfaces = visitor.getInterfaces();
            ClassInfo classInfo = this.classInfoMap.get(classSlashName);
            if (null == superSlashName && !classSlashName.equals("java/lang/Object")) {
                throw new RuntimeException("All classes except Object must have a superclass");
            }
            ClassInfo superInfo = this.classInfoMap.get(superSlashName);
            if (superInfo != null) {
                classInfo.setSuperclass(superInfo);
                superInfo.addToChildren(classInfo);
                classInfo.addToParents(superInfo);
            } else {
                System.err.println("<Warning> Unsupported JCL class detected: " + superSlashName);
            }
            if (null == interfaces) continue;
            for (String interfaceName : interfaces) {
                ClassInfo interfaceInfo = this.classInfoMap.get(interfaceName);
                if (interfaceInfo == null) {
                    throw new IllegalArgumentException("Unusable interface " + interfaceName);
                }
                interfaceInfo.addToChildren(classInfo);
                classInfo.addToParents(interfaceInfo);
            }
        }
    }

    private Map<String, ClassInfo> getClassInfoMap() {
        return this.classInfoMap;
    }
}

