/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.tooling.deploy.eliminator;

import foundation.icon.ee.struct.Member;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.aion.avm.tooling.deploy.eliminator.ClassInfo;
import org.aion.avm.tooling.deploy.eliminator.JarDependencyCollector;
import org.aion.avm.tooling.deploy.eliminator.MethodInfo;
import org.aion.avm.tooling.deploy.eliminator.MethodInvocation;

public class MethodReachabilityDetector {
    private final Map<String, ClassInfo> classInfoMap;
    private final Queue<MethodInfo> methodQueue;

    public static Map<String, ClassInfo> getClassInfoMap(String mainClassName, Map<String, byte[]> classMap, Map<String, List<Member>> keptMethods) throws Exception {
        MethodReachabilityDetector detector = new MethodReachabilityDetector(mainClassName, classMap, keptMethods);
        return detector.getClassInfoMap();
    }

    private MethodReachabilityDetector(String mainClassName, Map<String, byte[]> classMap, Map<String, List<Member>> keptMethods) throws Exception {
        this.classInfoMap = JarDependencyCollector.getClassInfoMap(classMap);
        ClassInfo mainClassInfo = this.classInfoMap.get(mainClassName);
        if (null == mainClassInfo) {
            throw new Exception("Main class info not found for class " + mainClassName);
        }
        this.methodQueue = new LinkedList<MethodInfo>();
        for (Map.Entry<String, List<Member>> e : keptMethods.entrySet()) {
            ClassInfo ci = this.classInfoMap.get(e.getKey());
            if (ci == null) continue;
            for (Member m : e.getValue()) {
                MethodInfo mi = null;
                for (ClassInfo cci = ci; cci != null && (mi = cci.getMethodMap().get(m.getMethodID())) == null; cci = cci.getSuperclass()) {
                }
                assert (mi != null);
                mi.isReachable = true;
                this.methodQueue.add(mi);
            }
        }
        for (ClassInfo classInfo : this.classInfoMap.values()) {
            this.methodQueue.addAll(classInfo.getAlwaysReachables());
        }
        this.traverse();
    }

    private void traverse() throws Exception {
        while (!this.methodQueue.isEmpty()) {
            MethodInfo methodInfo = this.methodQueue.remove();
            if (!methodInfo.isReachable) {
                throw new Exception("This method should have been marked as reachable!");
            }
            block5: for (MethodInvocation invocation : methodInfo.methodInvocations) {
                ClassInfo ownerClass = this.classInfoMap.get(invocation.className);
                if (null == ownerClass) continue;
                MethodInfo calledMethod = ownerClass.getMethodMap().get(invocation.methodIdentifier);
                if (ownerClass.isSystemClass() && null == calledMethod) {
                    throw new UnsupportedOperationException("Unsupported JCL method detected: " + invocation.className + "#" + invocation.methodIdentifier);
                }
                switch (invocation.invocationOpcode) {
                    case 183: {
                        calledMethod = ownerClass.getConcreteImplementation(invocation.methodIdentifier);
                        this.enqueue(calledMethod);
                        continue block5;
                    }
                    case 182: 
                    case 184: 
                    case 185: 
                    case 186: {
                        this.enqueueSelfAndChildren(ownerClass, invocation.methodIdentifier);
                        continue block5;
                    }
                }
                throw new Exception("This is not an invoke method opcode");
            }
        }
    }

    private void enqueueSelfAndChildren(ClassInfo classInfo, String methodId) {
        MethodInfo methodInfo = classInfo.getDeclaration(methodId);
        if (null == methodInfo) {
            throw new IllegalArgumentException("No declaration found for " + methodId + ", corrupt jar suspected");
        }
        this.enqueue(methodInfo);
        if (!methodInfo.isStatic) {
            for (ClassInfo childClassInfo : classInfo.getChildren()) {
                MethodInfo childMethodInfo = childClassInfo.getMethodMap().get(methodId);
                if (null != childMethodInfo) {
                    this.enqueue(childMethodInfo);
                    continue;
                }
                if (!classInfo.isInterface() || childClassInfo.isInterface() || childClassInfo.isAbstract()) continue;
                MethodInfo concreteImplInfo = childClassInfo.getConcreteImplementation(methodId);
                if (null == concreteImplInfo) {
                    throw new IllegalArgumentException("No implementation found for " + methodId + ", corrupt jar suspected");
                }
                this.enqueue(concreteImplInfo);
            }
        }
    }

    private void enqueue(MethodInfo methodInfo) {
        if (!methodInfo.isReachable) {
            methodInfo.isReachable = true;
            this.methodQueue.add(methodInfo);
        }
    }

    private Map<String, ClassInfo> getClassInfoMap() {
        return this.classInfoMap;
    }
}

