/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.tooling.deploy.eliminator;

import java.util.HashSet;
import java.util.Set;
import org.aion.avm.tooling.deploy.eliminator.MethodInvocation;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;

public class MethodDependencyVisitor
extends MethodVisitor {
    private final String methodIdentifier;
    private final Set<MethodInvocation> methodsCalled = new HashSet<MethodInvocation>();
    private final boolean isStatic;

    public MethodDependencyVisitor(String methodName, String methodDescriptor, int access, MethodVisitor mv) {
        super(458752, mv);
        this.methodIdentifier = methodName + methodDescriptor;
        this.isStatic = (access & 8) != 0;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        this.methodsCalled.add(new MethodInvocation(owner, name + desc, opcode));
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        if (name.equals("apply") || name.equals("run")) {
            Handle ownerHandle = (Handle)bsmArgs[1];
            this.methodsCalled.add(new MethodInvocation(ownerHandle.getOwner(), ownerHandle.getName() + ownerHandle.getDesc(), 186));
        } else if (!name.equals("makeConcatWithConstants")) {
            throw new UnsupportedOperationException("Unsupported invokedynamic instruction: " + name);
        }
    }

    public Set<MethodInvocation> getMethodsCalled() {
        return this.methodsCalled;
    }

    public String getMethodIdentifier() {
        return this.methodIdentifier;
    }

    public boolean isStatic() {
        return this.isStatic;
    }
}

