/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.tooling.deploy.renamer;

import foundation.icon.ee.struct.Member;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aion.avm.tooling.deploy.eliminator.ClassInfo;
import org.aion.avm.tooling.deploy.renamer.NameGenerator;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class FieldRenamer {
    private static final boolean printEnabled = false;

    public static Map<String, String> renameFields(Map<String, ClassNode> classMap, Map<String, ClassInfo> classInfoMap, Map<String, List<Member>> keptFieldsMap) {
        HashMap<String, String> newFieldsMappingsForRemapper = new HashMap<String, String>();
        NameGenerator generator = new NameGenerator();
        for (Map.Entry<String, ClassNode> e : classMap.entrySet()) {
            String className = e.getKey();
            List fieldNodes = e.getValue().fields;
            List<Object> keptFields = keptFieldsMap.get(className);
            if (keptFields == null) {
                keptFields = List.of();
            }
            for (FieldNode f : fieldNodes) {
                if (keptFields.stream().anyMatch(m -> f.name.equals(m.getName())) || newFieldsMappingsForRemapper.containsKey(FieldRenamer.makeFullFieldName(className, f.name))) continue;
                String newName = generator.getNextMethodOrFieldName(null);
                newFieldsMappingsForRemapper.put(FieldRenamer.makeFullFieldName(className, f.name), newName);
                FieldRenamer.printInfo(className, f.name, newName);
                for (ClassInfo c : classInfoMap.get(className).getChildren()) {
                    newFieldsMappingsForRemapper.put(FieldRenamer.makeFullFieldName(c.getClassName(), f.name), newName);
                    FieldRenamer.printInfo(c.getClassName(), f.name, newName);
                }
            }
        }
        return newFieldsMappingsForRemapper;
    }

    private static String makeFullFieldName(String className, String fieldName) {
        return className + "." + fieldName;
    }

    private static void printInfo(String className, String oldName, String newName) {
    }
}

