/*
 * Decompiled with CFR 0.152.
 */
package com.iconloop.score.test;

import java.io.Serializable;
import java.util.Arrays;
import score.Address;
import score.impl.TypeConverter;

public class Event {
    private final Address contract;
    private final Object[] indexed;
    private final Object[] data;
    public static final Object[] EMPTY = new Object[0];

    public Event(Address contract, Object[] indexed, Object[] data) {
        if (contract != null && !contract.isContract()) {
            throw new IllegalArgumentException("invalid contract address");
        }
        if (indexed == null || indexed.length < 1 || indexed.length > 4) {
            throw new IllegalArgumentException("invalid indexed parameter: length=" + (Serializable)(indexed != null ? Integer.valueOf(indexed.length) : "null"));
        }
        this.contract = contract;
        this.indexed = indexed;
        this.data = data == null ? EMPTY : data;
        for (Object obj : this.indexed) {
            if (TypeConverter.isValidEventValue(obj)) continue;
            throw new IllegalArgumentException("invalid value type " + obj.getClass());
        }
        for (Object obj : this.data) {
            if (TypeConverter.isValidEventValue(obj)) continue;
            throw new IllegalArgumentException("invalid value type " + obj.getClass());
        }
    }

    public int numberOfIndexed() {
        return this.indexed.length;
    }

    public int numberOfData() {
        return this.data.length;
    }

    public Address getContract() {
        return this.contract;
    }

    public Object getIndexed(int idx) {
        return this.indexed[idx];
    }

    public Object getData(int idx) {
        return this.data[idx];
    }

    private boolean match(Event log, boolean ignoreNull) {
        byte[] mv;
        byte[] mo;
        Object v2;
        Object v1;
        int i;
        if (this == log) {
            return true;
        }
        if (this.indexed.length != log.indexed.length || this.data.length != log.data.length) {
            return false;
        }
        if (this.contract != null ? !this.contract.equals(log.contract) : !ignoreNull && log.contract != null) {
            return false;
        }
        for (i = 0; i < this.indexed.length; ++i) {
            v1 = this.indexed[i];
            if (v1 == null && ignoreNull) continue;
            v2 = log.indexed[i];
            mo = TypeConverter.toBytes(v1);
            if (Arrays.equals(mo, mv = TypeConverter.toBytes(v2))) continue;
            return false;
        }
        for (i = 0; i < this.data.length; ++i) {
            v1 = this.data[i];
            if (v1 == null && ignoreNull) continue;
            v2 = log.data[i];
            mo = TypeConverter.toBytes(v1);
            if (Arrays.equals(mo, mv = TypeConverter.toBytes(v2))) continue;
            return false;
        }
        return true;
    }

    public boolean match(Event log) {
        return this.match(log, true);
    }

    public boolean equals(Object log) {
        if (log == null || this.getClass() != log.getClass()) {
            return false;
        }
        return this.match((Event)log, false);
    }

    public String toString() {
        return "Event(caller=" + this.contract + ",indexed=" + Arrays.toString(this.indexed) + ",data=" + Arrays.toString(this.data) + ")";
    }
}

