/*
 * Decompiled with CFR 0.152.
 */
package com.iconloop.score.test;

import com.iconloop.score.test.Account;
import com.iconloop.score.test.Event;
import com.iconloop.score.test.GenerateTScore;
import com.iconloop.score.test.GenerateTScores;
import com.iconloop.score.test.Score;
import com.iconloop.score.test.ServiceManager;
import com.iconloop.score.test.TExternal;
import com.iconloop.score.test.TOptional;
import com.iconloop.score.test.TScore;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import foundation.icon.annotation_processor.AbstractProcessor;
import foundation.icon.annotation_processor.ProcessorUtil;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import score.Context;
import score.annotation.EventLog;
import score.annotation.External;
import score.annotation.Optional;
import score.annotation.Payable;
import score.impl.TypeConverter;

public class GenerateTScoreProcessor
extends AbstractProcessor {
    private Set<ClassName> processed = new HashSet<ClassName>();
    private static final Map<String, String> eventTypeStrings = Map.of("byte", "int", "char", "int", "short", "int", "int", "int", "long", "int", "java.math.BigInteger", "int", "java.lang.String", "str", "byte[]", "bytes", "boolean", "bool", "score.Address", "Address");
    static TypeName externalAnnName = TypeName.get(TExternal.class);
    static TypeName optionalAnnName = TypeName.get(TOptional.class);
    static TypeName eventAnnName = TypeName.get(EventLog.class);

    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> s = new HashSet<String>();
        s.add(GenerateTScores.class.getCanonicalName());
        s.add(GenerateTScore.class.getCanonicalName());
        return s;
    }

    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    static AnnotationMirror getAnnotationMirror(Element element, Class<? extends Annotation> annClass) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!TypeName.get((TypeMirror)annotationMirror.getAnnotationType()).toString().equals(annClass.getName())) continue;
            return annotationMirror;
        }
        return null;
    }

    static Object getAnnotationValue(AnnotationMirror am, String annMethod) {
        Objects.requireNonNull(am);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : am.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(annMethod)) continue;
            return entry.getValue().getValue();
        }
        return null;
    }

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean ret = false;
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotationElements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : annotationElements) {
                GenerateTScores annContainer = element.getAnnotation(GenerateTScores.class);
                if (annContainer != null) {
                    GenerateTScore[] anns = annContainer.value();
                    List ams = (List)GenerateTScoreProcessor.getAnnotationValue(GenerateTScoreProcessor.getAnnotationMirror(element, GenerateTScores.class), "value");
                    if (ams == null || anns.length != ams.size()) {
                        throw new RuntimeException("invalid list of AnnotationMirror element:" + element);
                    }
                    for (int i = 0; i < ams.size(); ++i) {
                        AnnotationMirror am = (AnnotationMirror)ams.get(i);
                        DeclaredType clazz = (DeclaredType)GenerateTScoreProcessor.getAnnotationValue(am, "value");
                        if (clazz == null) {
                            throw new RuntimeException("value is required, element:" + element);
                        }
                        this.generateImplementClass(anns[i], (TypeElement)clazz.asElement());
                    }
                } else {
                    GenerateTScore ann = element.getAnnotation(GenerateTScore.class);
                    DeclaredType clazz = (DeclaredType)GenerateTScoreProcessor.getAnnotationValue(GenerateTScoreProcessor.getAnnotationMirror(element, GenerateTScore.class), "value");
                    TypeElement typeElement2 = clazz == null ? (TypeElement)element : (TypeElement)clazz.asElement();
                    this.generateImplementClass(ann, typeElement2);
                }
                ret = true;
            }
        }
        return ret;
    }

    private void generateImplementClass(GenerateTScore ann, TypeElement typeElement) {
        if (!typeElement.getKind().isClass()) {
            throw new RuntimeException("not support, element:" + typeElement);
        }
        ClassName className = ClassName.get((String)ClassName.get((TypeElement)typeElement).packageName(), (String)(this.generateClassSimpleName(typeElement) + ann.suffix()), (String[])new String[0]);
        if (this.processed.contains(className)) {
            return;
        }
        this.processed.add(className);
        this.messager.noteMessage("process %s to %s", new Object[]{typeElement.asType(), className});
        TypeSpec typeSpec = this.typeSpec(className, typeElement);
        JavaFile javaFile = JavaFile.builder((String)className.packageName(), (TypeSpec)typeSpec).build();
        try {
            javaFile.writeTo(this.processingEnv.getFiler());
        }
        catch (IOException e) {
            this.messager.warningMessage("create javaFile error : %s", new Object[]{e.getMessage()});
        }
    }

    private String generateClassSimpleName(TypeElement typeElement) {
        if (typeElement.getNestingKind().isNested()) {
            return this.generateClassSimpleName((TypeElement)typeElement.getEnclosingElement()) + typeElement.getSimpleName().toString();
        }
        return typeElement.getSimpleName().toString();
    }

    private TypeSpec typeSpec(ClassName className, TypeElement typeElement) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(TScore.class).superclass(typeElement.asType());
        for (Element element : typeElement.getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.CONSTRUCTOR)) continue;
            ExecutableElement ee = (ExecutableElement)element;
            builder.addMethod(MethodSpec.constructorBuilder().addModifiers(ee.getModifiers()).addParameters((Iterable)ProcessorUtil.getParameterSpecs((ExecutableElement)ee)).addStatement("super($L)", new Object[]{this.paramJoin(this.paramNames(ee))}).build());
        }
        builder.addMethods(this.overrideMethods(typeElement));
        builder.addType(this.clientTypeSpec(className, builder.methodSpecs));
        return builder.build();
    }

    private List<MethodSpec> overrideMethods(TypeElement typeElement) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        TypeMirror superClass = typeElement.getSuperclass();
        if (!superClass.getKind().equals((Object)TypeKind.NONE) && !superClass.toString().equals(Object.class.getName())) {
            this.messager.noteMessage("superClass[kind:%s, name:%s]", new Object[]{superClass.getKind().name(), superClass.toString()});
            List<MethodSpec> superMethods = this.overrideMethods(super.getTypeElement(superClass));
            this.addMethods(methods, superMethods, typeElement);
        }
        for (Element element : typeElement.getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.METHOD)) continue;
            ExecutableElement ee = (ExecutableElement)element;
            this.addMethod(methods, this.eventMethodSpec(ee, typeElement), typeElement);
            this.addMethod(methods, this.externalMethodSpec(ee, typeElement), typeElement);
        }
        return methods;
    }

    private MethodSpec eventMethodSpec(ExecutableElement ee, TypeElement typeElement) {
        EventLog ann = ee.getAnnotation(EventLog.class);
        if (ann != null) {
            List<String> params = this.paramNames(ee);
            if (ann.indexed() < 0 || ann.indexed() > params.size()) {
                throw new IndexOutOfBoundsException(String.format("indexed in %s.%s", typeElement.getSimpleName(), ee.getSimpleName()));
            }
            ArrayList<String> indexed = new ArrayList<String>();
            indexed.add(this.eventSignature(ee));
            MethodSpec.Builder builder = MethodSpec.overriding((ExecutableElement)ee).addAnnotation(AnnotationSpec.builder(EventLog.class).addMember("indexed", "$L", new Object[]{ann.indexed()}).build());
            if (ann.indexed() > 0) {
                indexed.addAll(params.subList(0, ann.indexed()));
                params = params.subList(ann.indexed(), params.size());
            }
            builder.addStatement("$T.logEvent($T.asEventObjects($L), $T.asEventObjects($L))", new Object[]{Context.class, TypeConverter.class, this.objectArray(indexed), TypeConverter.class, this.objectArray(params)});
            return builder.build();
        }
        return null;
    }

    private MethodSpec externalMethodSpec(ExecutableElement ee, TypeElement typeElement) {
        External ann = ee.getAnnotation(External.class);
        if (ann != null) {
            boolean payable;
            boolean readonly = ann.readonly();
            boolean bl = payable = ee.getAnnotation(Payable.class) != null;
            if (readonly && payable) {
                throw new RuntimeException(String.format("readonly method cannot be payable, %s.%s", typeElement.getSimpleName(), ee.getSimpleName()));
            }
            boolean mustOptional = false;
            ArrayList<ParameterSpec> params = new ArrayList<ParameterSpec>();
            for (VariableElement variableElement : ee.getParameters()) {
                ParameterSpec param;
                if (variableElement.getAnnotation(Optional.class) != null) {
                    param = ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)variableElement.asType()), (String)variableElement.getSimpleName().toString(), (Modifier[])new Modifier[0]).addModifiers(variableElement.getModifiers()).addAnnotation(TOptional.class).build();
                    mustOptional = true;
                } else {
                    if (mustOptional) {
                        throw new RuntimeException(String.format("parameter should be optional, %s of %s.%s", variableElement.getSimpleName(), typeElement.getSimpleName(), ee.getSimpleName()));
                    }
                    param = ParameterSpec.get((VariableElement)variableElement);
                }
                params.add(param);
            }
            TypeName returnType = TypeName.get((TypeMirror)ee.getReturnType());
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)ee.getSimpleName().toString()).addModifiers(ee.getModifiers()).addParameters(params).returns(returnType).addAnnotation(Override.class).addAnnotation(AnnotationSpec.builder(TExternal.class).addMember("readonly", "$L", new Object[]{readonly}).addMember("payable", "$L", new Object[]{payable}).build());
            if (returnType.equals((Object)TypeName.VOID)) {
                builder.addStatement("super.$L($L)", new Object[]{ee.getSimpleName(), this.paramJoin(this.paramNames(ee))});
            } else {
                builder.addStatement("return super.$L($L)", new Object[]{ee.getSimpleName(), this.paramJoin(this.paramNames(ee))});
            }
            return builder.build();
        }
        return null;
    }

    private void addMethods(List<MethodSpec> methods, List<MethodSpec> methodSpecs, TypeElement element) {
        for (MethodSpec methodSpec : methodSpecs) {
            this.addMethod(methods, methodSpec, element);
        }
    }

    private void addMethod(List<MethodSpec> methods, MethodSpec methodSpec, TypeElement typeElement) {
        if (methodSpec != null) {
            MethodSpec conflictMethod = ProcessorUtil.getConflictMethod(methods, (MethodSpec)methodSpec);
            if (conflictMethod != null) {
                methods.remove(conflictMethod);
                CodeBlock indexed = this.eventIndexed(methodSpec);
                if (indexed != null && !indexed.equals((Object)this.eventIndexed(conflictMethod))) {
                    this.messager.warningMessage("Redeclare '%s %s(%s)' in %s", new Object[]{conflictMethod.returnType.toString(), conflictMethod.name, ProcessorUtil.parameterSpecToString((List)conflictMethod.parameters), typeElement.getQualifiedName()});
                }
            }
            methods.add(methodSpec);
        }
    }

    private CodeBlock eventIndexed(MethodSpec methodSpec) {
        return methodSpec.annotations.stream().filter(ann -> ann.type.toString().equals(EventLog.class.getName())).findAny().map(ann -> (CodeBlock)((List)ann.members.get("indexed")).get(0)).orElse(null);
    }

    private String eventSignature(ExecutableElement ee) {
        StringJoiner stringJoiner = new StringJoiner(",");
        for (VariableElement variableElement : ee.getParameters()) {
            String eventTypeString = eventTypeStrings.get(variableElement.asType().toString());
            if (eventTypeString == null) {
                throw new RuntimeException(String.format("not allowed event parameter type, %s of %s.%s", variableElement.getSimpleName(), ee.getEnclosingElement().getSimpleName(), ee.getSimpleName()));
            }
            stringJoiner.add(eventTypeString);
        }
        return String.format("\"%s(%s)\"", ee.getSimpleName(), stringJoiner);
    }

    private List<String> paramNames(ExecutableElement ee) {
        return ee.getParameters().stream().map(v -> v.getSimpleName().toString()).collect(Collectors.toList());
    }

    private String paramJoin(List<String> names) {
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (String name : names) {
            stringJoiner.add(name);
        }
        return stringJoiner.toString();
    }

    private String objectArray(List<String> names) {
        return "new Object[]{" + this.paramJoin(names) + "}";
    }

    private static boolean hasOptional(ParameterSpec p) {
        return p.annotations.stream().anyMatch(a -> a.type.equals((Object)optionalAnnName));
    }

    private List<List<ParameterSpec>> explodeOptionalParameters(List<ParameterSpec> params) {
        ArrayList<List<ParameterSpec>> specs = new ArrayList<List<ParameterSpec>>();
        ArrayList<ParameterSpec> spec = new ArrayList<ParameterSpec>();
        for (ParameterSpec p : params) {
            if (GenerateTScoreProcessor.hasOptional(p)) {
                specs.add(List.copyOf(spec));
            }
            spec.add(ParameterSpec.builder((TypeName)p.type, (String)p.name, (Modifier[])((Modifier[])p.modifiers.toArray(Modifier[]::new))).build());
        }
        specs.add(List.copyOf(spec));
        return specs;
    }

    private TypeSpec clientTypeSpec(ClassName tScoreClassName, List<MethodSpec> methods) {
        ClassName className = tScoreClassName.nestedClass("Client");
        String FILED_SCORE = "score";
        String FILED_FROM = "from";
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addField(Score.class, FILED_SCORE, new Modifier[]{Modifier.PRIVATE}).addField(Account.class, FILED_FROM, new Modifier[]{Modifier.PRIVATE}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Score.class, FILED_SCORE, new Modifier[0]).addStatement("this($L, null)", new Object[]{FILED_SCORE}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Score.class, FILED_SCORE, new Modifier[0]).addParameter(Account.class, FILED_FROM, new Modifier[0]).addStatement("this.$L = $L", new Object[]{FILED_SCORE, FILED_SCORE}).addStatement("this.$L = $L == null ? $L.getOwner() : $L", new Object[]{FILED_FROM, FILED_FROM, FILED_SCORE, FILED_FROM}).build());
        List constructorParams = methods.stream().filter(MethodSpec::isConstructor).findFirst().map(m -> m.parameters).orElse(new ArrayList());
        MethodSpec.Builder deployMethodBuilder = MethodSpec.methodBuilder((String)"deploy").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addException(Exception.class).addParameter(ServiceManager.class, "sm", new Modifier[0]).addParameter(Account.class, "caller", new Modifier[0]).addParameters((Iterable)constructorParams).returns((TypeName)className);
        if (constructorParams.size() == 0) {
            deployMethodBuilder.addStatement("return new $T(sm.deploy(caller, $T.class))", new Object[]{className, tScoreClassName});
        } else {
            deployMethodBuilder.addStatement("return new $T(sm.deploy(caller, $T.class, $L))", new Object[]{className, tScoreClassName, this.paramJoin(constructorParams.stream().map(p -> p.name).collect(Collectors.toList()))});
        }
        builder.addMethod(deployMethodBuilder.build());
        builder.addMethod(MethodSpec.methodBuilder((String)FILED_SCORE).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return $L", new Object[]{FILED_SCORE}).returns(Score.class).build());
        builder.addMethod(MethodSpec.methodBuilder((String)FILED_FROM).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Account.class, FILED_FROM, new Modifier[0]).addStatement("return new $T($L, $L)", new Object[]{className, FILED_SCORE, FILED_FROM}).returns((TypeName)className).build());
        for (MethodSpec method : methods) {
            AnnotationSpec ann = method.annotations.stream().filter(a -> a.type.equals((Object)externalAnnName)).findAny().orElse(null);
            if (ann != null) {
                boolean readonly = ((CodeBlock)((List)ann.members.get("readonly")).get(0)).toString().equals("true");
                boolean payable = ((CodeBlock)((List)ann.members.get("payable")).get(0)).toString().equals("true");
                List<List<ParameterSpec>> parameterSets = this.explodeOptionalParameters(method.parameters);
                for (List<ParameterSpec> parameters : parameterSets) {
                    MethodSpec.Builder externalMethodBuilder = MethodSpec.methodBuilder((String)method.name).addModifiers((Iterable)method.modifiers);
                    List<String> paramNames = parameters.stream().map(p -> p.name).collect(Collectors.toList());
                    Object params = this.paramJoin(paramNames);
                    if (paramNames.size() > 0) {
                        params = ", " + (String)params;
                    }
                    if (readonly) {
                        externalMethodBuilder.addStatement("return this.$L.call($T.class, \"$L\"$L)", new Object[]{FILED_SCORE, method.returnType, method.name, params}).returns(method.returnType);
                    } else if (payable) {
                        String PARAM_VALUE = this.resolveName(paramNames, "valueForPayable");
                        externalMethodBuilder.addParameter(ParameterSpec.builder(BigInteger.class, (String)PARAM_VALUE, (Modifier[])new Modifier[0]).build());
                        externalMethodBuilder.addStatement("this.$L.invoke(this.$L, $L, \"$L\"$L)", new Object[]{FILED_SCORE, FILED_FROM, PARAM_VALUE, method.name, params});
                    } else {
                        externalMethodBuilder.addStatement("this.$L.invoke(this.$L, \"$L\"$L)", new Object[]{FILED_SCORE, FILED_FROM, method.name, params});
                    }
                    builder.addMethod(externalMethodBuilder.addParameters(parameters).build());
                }
                continue;
            }
            boolean isEvent = method.annotations.stream().anyMatch(a -> a.type.equals((Object)eventAnnName));
            if (!isEvent) continue;
            String code = method.code.toString().replace("score.Context.logEvent(", String.format("return new Event(this.%s.getAddress(), ", FILED_SCORE));
            code = code.replace(TypeConverter.class.getName(), TypeConverter.class.getSimpleName());
            builder.addMethod(MethodSpec.methodBuilder((String)method.name).addModifiers((Iterable)method.modifiers).addParameters((Iterable)method.parameters).returns(Event.class).addCode(code, new Object[0]).build());
        }
        return builder.build();
    }

    private String resolveName(List<String> names, String name) {
        if (names.contains(name)) {
            return this.resolveName(names, "_" + name);
        }
        return name;
    }
}

