/*
 * Decompiled with CFR 0.152.
 */
package com.iconloop.score.test;

import com.iconloop.score.test.Account;
import com.iconloop.score.test.Event;
import com.iconloop.score.test.Score;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.List;
import score.Address;

public abstract class ServiceManager {
    private static ServiceManager sInstance;
    private static final String kServiceManagerImplementationClass = "score.ServiceManagerImpl";
    private static final String kMethodNameToGetServiceManager = "getServiceManager";

    public abstract Score deploy(Account var1, Class<?> var2, Object ... var3) throws Exception;

    public abstract Account createAccount();

    public abstract Account createAccount(int var1);

    public abstract Account getAccount(Address var1);

    public abstract Account createScoreAccount();

    public abstract Score deploy(Address var1, Account var2, Object var3);

    public abstract void invoke(Account var1, BigInteger var2, Address var3, String var4, Object ... var5);

    public abstract Object call(Account var1, BigInteger var2, Address var3, String var4, Object ... var5);

    public abstract Object call(Address var1, String var2, Object ... var3);

    public abstract <T> T call(Class<T> var1, Address var2, String var3, Object ... var4);

    public abstract void transfer(Account var1, Address var2, BigInteger var3);

    public abstract <T> T getValue(Class<T> var1, Address var2, String var3);

    public abstract void setValue(Address var1, String var2, Object var3);

    public abstract Block getBlock();

    public abstract List<Event> getLastEventLogs();

    public static ServiceManager getInstance() {
        if (sInstance == null) {
            try {
                Class<?> sm = Class.forName(kServiceManagerImplementationClass);
                Method method = sm.getDeclaredMethod(kMethodNameToGetServiceManager, new Class[0]);
                method.setAccessible(true);
                sInstance = (ServiceManager)method.invoke(sm, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("UnableToGetServiceManager", e);
            }
        }
        return sInstance;
    }

    public static interface Block {
        public long getHeight();

        public long getTimestamp();

        public void increase();

        public void increase(long var1);

        public byte[] hashOfTransactionAt(int var1);
    }
}

