/*
 * Decompiled with CFR 0.152.
 */
package score.impl;

import foundation.icon.ee.io.DataReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import score.Address;
import score.ObjectReader;

public class ObjectReaderImpl
implements ObjectReader {
    private final DataReader reader;
    private int level = 0;

    public ObjectReaderImpl(DataReader reader) {
        this.reader = reader;
    }

    @Override
    public boolean readBoolean() {
        return this.reader.readBoolean();
    }

    @Override
    public byte readByte() {
        return this.reader.readByte();
    }

    @Override
    public short readShort() {
        return this.reader.readShort();
    }

    @Override
    public char readChar() {
        return this.reader.readChar();
    }

    @Override
    public int readInt() {
        return this.reader.readInt();
    }

    @Override
    public float readFloat() {
        return this.reader.readFloat();
    }

    @Override
    public long readLong() {
        return this.reader.readLong();
    }

    @Override
    public double readDouble() {
        return this.reader.readDouble();
    }

    @Override
    public BigInteger readBigInteger() {
        return this.reader.readBigInteger();
    }

    @Override
    public String readString() {
        return this.reader.readString();
    }

    @Override
    public byte[] readByteArray() {
        return this.reader.readByteArray();
    }

    @Override
    public Address readAddress() {
        return new Address(this.reader.readByteArray());
    }

    @Override
    public <T> T read(Class<T> c) {
        if (c == Boolean.class) {
            return (T)Boolean.valueOf(this.readBoolean());
        }
        if (c == Byte.class) {
            return (T)Byte.valueOf(this.readByte());
        }
        if (c == Short.class) {
            return (T)Short.valueOf(this.readShort());
        }
        if (c == Character.class) {
            return (T)Character.valueOf(this.readChar());
        }
        if (c == Integer.class) {
            return (T)Integer.valueOf(this.readInt());
        }
        if (c == Float.class) {
            return (T)Float.valueOf(this.readFloat());
        }
        if (c == Long.class) {
            return (T)Long.valueOf(this.readLong());
        }
        if (c == Double.class) {
            return (T)Double.valueOf(this.readDouble());
        }
        if (c == String.class) {
            return (T)this.readString();
        }
        if (c == BigInteger.class) {
            return (T)this.readBigInteger();
        }
        if (c == byte[].class) {
            return (T)this.readByteArray();
        }
        if (c == Address.class) {
            return (T)this.readAddress();
        }
        try {
            Method m = c.getDeclaredMethod("readObject", ObjectReader.class);
            if ((m.getModifiers() & 8) == 0 || (m.getModifiers() & 1) == 0) {
                throw new IllegalArgumentException();
            }
            Object res = m.invoke(null, this);
            return (T)res;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new IllegalArgumentException();
        }
    }

    @Override
    public <T> T readOrDefault(Class<T> c, T def) {
        if (!this.hasNext()) {
            return def;
        }
        return this.read(c);
    }

    @Override
    public <T> T readNullable(Class<T> c) {
        if (this.reader.readNullity()) {
            return null;
        }
        return this.read(c);
    }

    @Override
    public <T> T readNullableOrDefault(Class<T> c, T def) {
        if (this.reader.readNullity()) {
            return def;
        }
        return this.readNullable(c);
    }

    @Override
    public void beginList() {
        ++this.level;
        this.reader.readListHeader();
    }

    @Override
    public boolean beginNullableList() {
        if (this.reader.readNullity()) {
            return false;
        }
        this.beginList();
        return true;
    }

    @Override
    public void beginMap() {
        ++this.level;
        this.reader.readMapHeader();
    }

    @Override
    public boolean beginNullableMap() {
        if (this.reader.readNullity()) {
            return false;
        }
        this.beginMap();
        return true;
    }

    @Override
    public void skip(int count) {
        this.reader.skip(count);
    }

    @Override
    public boolean hasNext() {
        return this.reader.hasNext();
    }

    @Override
    public void end() {
        if (this.level == 0) {
            throw new IllegalStateException();
        }
        while (this.reader.hasNext()) {
            this.reader.skip(1);
        }
        this.reader.readFooter();
        --this.level;
    }

    @Override
    public void skip() {
        this.skip(1);
    }
}

