/*
 * Decompiled with CFR 0.152.
 */
package score.impl.bls12381;

import supranational.blst.BLST_ERROR;
import supranational.blst.P1;
import supranational.blst.P1_Affine;
import supranational.blst.P2_Affine;

public class BLS12381 {
    private static final String dst = "BLS_SIG_BLS12381G2_XMD:SHA-256_SSWU_RO_POP_";
    public static final int G1_LEN = 48;
    public static final int G2_LEN = 96;
    private static final P1 I = new P1();

    public static P1 identity() {
        return I.dup();
    }

    public static byte[] aggregateG1Values(byte[] prevAgg, byte[] values) {
        try {
            P1 res;
            if (prevAgg != null) {
                res = new P1(prevAgg);
                if (!res.in_group()) {
                    throw new IllegalArgumentException("prevAgg is not in group");
                }
            } else {
                res = I.dup();
            }
            int nValues = values.length / 48;
            byte[] pk = new byte[48];
            for (int i = 0; i < nValues; ++i) {
                System.arraycopy(values, i * 48, pk, 0, 48);
                P1_Affine p1a = new P1_Affine(pk);
                if (!p1a.in_group()) {
                    throw new IllegalArgumentException("a value is not in group");
                }
                res.aggregate(p1a);
            }
            return res.compress();
        }
        catch (Throwable e) {
            if (!(e instanceof IllegalArgumentException)) {
                throw new IllegalArgumentException(e.getMessage());
            }
            return null;
        }
    }

    public static boolean verifyG2Signature(byte[] pubKey, byte[] sig, byte[] msg) {
        try {
            P1_Affine p1a = new P1_Affine(pubKey);
            P2_Affine p2a = new P2_Affine(sig);
            BLST_ERROR err = p2a.core_verify(p1a, true, msg, dst);
            return err == BLST_ERROR.BLST_SUCCESS;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }
}

