/*
 * Decompiled with CFR 0.152.
 */
package score.impl.struct;

import org.objectweb.asm.Type;
import score.impl.struct.Member;
import score.impl.struct.Property;

public class PropertyMember {
    private final int sort;
    private final Type declaringType;
    private final Member member;
    public static final int FIELD = 0;
    public static final int GETTER = 1;
    public static final int SETTER = 2;

    public PropertyMember(int sort, Type declaringType, String originalName, String descriptor) {
        this(sort, declaringType, originalName, Type.getType((String)descriptor));
    }

    public PropertyMember(int sort, Type declaringType, String originalName, Type type) {
        this.sort = sort;
        this.declaringType = declaringType;
        this.member = new Member(originalName, type);
    }

    public int getSort() {
        return this.sort;
    }

    public Type getDeclaringType() {
        return this.declaringType;
    }

    public String getOriginalName() {
        return this.member.getName();
    }

    public Type getOriginalType() {
        return this.member.getType();
    }

    public Type getType() {
        if (this.sort == 0) {
            return this.getOriginalType();
        }
        if (this.sort == 1) {
            return this.getOriginalType().getReturnType();
        }
        assert (this.sort == 2);
        return this.getOriginalType().getArgumentTypes()[0];
    }

    public String getName() {
        if (this.sort == 0) {
            return this.getOriginalName();
        }
        assert (this.sort == 1 || this.sort == 2);
        int pre = this.getOriginalName().startsWith("is") ? 2 : 3;
        return Property.decapitalize(this.getOriginalName().substring(pre));
    }

    public Member getMember() {
        return this.member;
    }
}

