/*
 * Decompiled with CFR 0.152.
 */
package com.iconloop.score.test;

import com.iconloop.score.test.ServiceManager;
import com.iconloop.score.test.WorldState;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import score.Address;

public class Account {
    private static final ServiceManager sm = ServiceManager.getInstance();
    private final Address address;
    private final WorldState state;
    private final Map<String, BigInteger> tokens = new HashMap<String, BigInteger>();

    public Address getAddress() {
        return this.address;
    }

    public Account(WorldState state, Address address) {
        this.state = state;
        this.address = address;
    }

    public String toString() {
        return this.address.toString();
    }

    public BigInteger getBalance() {
        return this.state.getBalance(this.address);
    }

    public void addBalance(BigInteger value) {
        this.state.addBalance(this.address, value);
    }

    public void subtractBalance(BigInteger value) {
        this.state.subtractBalance(this.address, value);
    }

    public BigInteger getBalance(String symbol) {
        return this.tokens.getOrDefault(symbol, BigInteger.ZERO);
    }

    public void addBalance(String symbol, BigInteger value) {
        if (value.signum() < 0) {
            throw new IllegalArgumentException("negative value change");
        }
        BigInteger balance = this.getBalance(symbol);
        this.tokens.put(symbol, balance.add(value));
    }

    public void subtractBalance(String symbol, BigInteger value) {
        if (value.signum() < 0) {
            throw new IllegalArgumentException("negative value change");
        }
        BigInteger balance = this.getBalance(symbol);
        if (balance.compareTo(value) < 0) {
            throw new IllegalArgumentException("out of balance");
        }
        this.tokens.put(symbol, balance.subtract(value));
    }

    public static Account getAccount(Address address) {
        return sm.getAccount(address);
    }

    @Deprecated
    public static Account newScoreAccount(int seed) {
        return sm.createScoreAccount();
    }
}

