/*
 * Decompiled with CFR 0.152.
 */
package com.iconloop.score.test;

import com.iconloop.score.test.DataStore;
import com.iconloop.score.test.OutOfBalanceException;
import com.iconloop.score.test.Score;
import java.math.BigInteger;
import score.Address;

public class WorldState {
    private DataStore<String, byte[]> store = new DataStore(null);
    private DataStore<Address, BigInteger> balances = new DataStore(null);
    private DataStore<Address, Score> scores = new DataStore(null);

    public void setValue(Address addr, String key, byte[] value) {
        if (value == null || value.length == 0) {
            this.store.set(addr.toString() + key, null);
        } else {
            this.store.set(addr.toString() + key, value);
        }
    }

    public byte[] getValue(Address addr, String key) {
        return this.store.get(addr.toString() + key);
    }

    public BigInteger getBalance(Address key) {
        return this.balances.getOrDefault(key, BigInteger.ZERO);
    }

    public void addBalance(Address key, BigInteger value) {
        this.balances.set(key, this.getBalance(key).add(value));
    }

    public void subtractBalance(Address key, BigInteger value) {
        BigInteger balance = this.getBalance(key);
        if (balance.compareTo(value) < 0) {
            throw new OutOfBalanceException("OutOfBalance(from=" + key + ",balance=" + balance + ",value=" + value + ")");
        }
        this.balances.set(key, this.getBalance(key).subtract(value));
    }

    public Score getScore(Address key) {
        return this.scores.get(key);
    }

    public void setScore(Address key, Score score) {
        this.scores.set(key, score);
    }

    public void push() {
        this.store = new DataStore<String, byte[]>(this.store);
        this.balances = new DataStore<Address, BigInteger>(this.balances);
        this.scores = new DataStore<Address, Score>(this.scores);
    }

    public void apply() {
        this.store.apply();
        this.balances.apply();
        this.scores.apply();
    }

    public void pop() {
        this.store = this.store.parent();
        this.balances = this.balances.parent();
        this.scores = this.scores.parent();
    }
}

