/*
 * Decompiled with CFR 0.152.
 */
package score;

public class Address {
    public static final int LENGTH = 21;
    private final byte[] raw = new byte[21];
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    public Address(byte[] raw) throws IllegalArgumentException {
        if (raw == null) {
            throw new NullPointerException();
        }
        if (raw.length != 21) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(raw, 0, this.raw, 0, 21);
    }

    public static Address fromString(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        if (str.length() != 42) {
            throw new IllegalArgumentException();
        }
        if (str.startsWith("hx") || str.startsWith("cx")) {
            byte[] bytes = new byte[21];
            bytes[0] = (byte)(!str.startsWith("hx") ? 1 : 0);
            for (int i = 1; i < 21; ++i) {
                int j = i * 2;
                bytes[i] = (byte)Integer.parseInt(str.substring(j, j + 2), 16);
            }
            return new Address(bytes);
        }
        throw new IllegalArgumentException();
    }

    public boolean isContract() {
        return this.raw[0] == 1;
    }

    public byte[] toByteArray() {
        byte[] copy = new byte[21];
        System.arraycopy(this.raw, 0, copy, 0, 21);
        return copy;
    }

    public int hashCode() {
        int code = 0;
        for (byte b : this.raw) {
            code += b;
        }
        return code;
    }

    public boolean equals(Object obj) {
        boolean isEqual;
        boolean bl = isEqual = this == obj;
        if (!isEqual && obj instanceof Address) {
            Address other = (Address)obj;
            isEqual = true;
            for (int i = 0; isEqual && i < 21; ++i) {
                isEqual = this.raw[i] == other.raw[i];
            }
        }
        return isEqual;
    }

    public String toString() {
        byte prefix = this.raw[0];
        byte[] body = new byte[20];
        System.arraycopy(this.raw, 1, body, 0, body.length);
        return (prefix == 0 ? "hx" : "cx") + Address.toHexString(body);
    }

    private static String toHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = hexArray[v >>> 4];
            hexChars[i * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

