/*
 * Decompiled with CFR 0.152.
 */
package score;

import com.iconloop.score.test.Account;
import com.iconloop.score.test.Event;
import com.iconloop.score.test.ManualRevertException;
import com.iconloop.score.test.OutOfBalanceException;
import com.iconloop.score.test.Score;
import com.iconloop.score.test.ServiceManager;
import com.iconloop.score.test.TExternal;
import com.iconloop.score.test.TOptional;
import com.iconloop.score.test.TScore;
import com.iconloop.score.test.WorldState;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import score.Address;
import score.EventLogger;
import score.RevertedException;
import score.UserRevertException;
import score.UserRevertedException;
import score.impl.AnyDBImpl;
import score.impl.Crypto;
import score.impl.TypeConverter;

class ServiceManagerImpl
extends ServiceManager
implements AnyDBImpl.ValueStore {
    private static final BigInteger ICX = BigInteger.TEN.pow(18);
    private final Stack<Frame> contexts = new Stack();
    private int nextCount = 255;
    private final WorldState state = new WorldState();
    private final Map<Address, Account> accounts = new HashMap<Address, Account>();
    private static final ThreadLocal<TransactionInfo> txInfo = new ThreadLocal();
    private EventLogger eventLogger = null;
    private List<Event> lastLogs = null;
    private static ServiceManagerImpl instance;

    private TXIScope setupTransactionInfo(boolean forTx) {
        TransactionInfo txi = txInfo.get();
        if (txi == null) {
            txInfo.set(new TransactionInfo(Block.next(), forTx ? 0 : -1));
            this.eventLogger = new EventLogger();
            return () -> {
                txInfo.set(null);
                this.lastLogs = this.eventLogger.getLogs();
                this.eventLogger = null;
            };
        }
        if (forTx) {
            txInfo.set(txi.next());
            this.eventLogger = new EventLogger();
        }
        return () -> {
            this.lastLogs = this.eventLogger.getLogs();
            this.eventLogger = null;
        };
    }

    @Override
    public Score deploy(Account caller, Class<?> mainClass, Object ... params) throws Exception {
        try (TXIScope scope = this.setupTransactionInfo(true);){
            Score score = this.deploy(caller, null, mainClass, params);
            return score;
        }
    }

    private Score deploy(Account caller, Score score, Class<?> mainClass, Object[] params) throws Exception {
        if (score == null) {
            Account acct = this.createScoreAccount();
            score = new Score(acct, caller);
        } else if (score.getOwner() != caller) {
            throw new RevertedException("NoPermissionToUpdate(owner=" + score.getOwner().getAddress() + ",caller=" + caller.getAddress());
        }
        this.pushFrame(caller, score.getAccount(), false, "<init>", BigInteger.ZERO);
        this.state.setScore(score.getAddress(), score);
        try {
            Constructor<?>[] ctor = mainClass.getConstructors();
            if (ctor.length != 1) {
                throw new AssertionError((Object)"multiple public constructors found");
            }
            score.setInstance(ctor[0].newInstance(params));
            this.applyFrame();
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw e;
        }
        finally {
            this.popFrame();
        }
        return score;
    }

    private Address nextAddress(boolean isContract) {
        byte[] ba = new byte[21];
        ba[0] = isContract ? (byte)1 : 0;
        int seed = ++this.nextCount;
        int index = ba.length - 1;
        ba[index--] = (byte)seed;
        ba[index--] = (byte)(seed >> 8);
        ba[index--] = (byte)(seed >> 16);
        ba[index] = (byte)(seed >> 24);
        return new Address(ba);
    }

    Account createAccount(Address address) {
        if (address == null) {
            throw new NullPointerException("AddressIsNull");
        }
        if (this.accounts.containsKey(address)) {
            throw new IllegalArgumentException("AlreadyCreatedAccount(addr=" + address + ")");
        }
        Account acct = new Account(this.state, address);
        this.accounts.put(address, acct);
        return acct;
    }

    @Override
    public Account createAccount() {
        return this.createAccount(this.nextAddress(false));
    }

    @Override
    public Account createAccount(int initialIcx) {
        Account acct = this.createAccount();
        acct.addBalance(ICX.multiply(BigInteger.valueOf(initialIcx)));
        return acct;
    }

    @Override
    public Account getAccount(Address addr) {
        if (addr == null) {
            throw new NullPointerException("AddressIsNull");
        }
        if (this.accounts.containsKey(addr)) {
            return this.accounts.get(addr);
        }
        return this.createAccount(addr);
    }

    @Override
    public Account createScoreAccount() {
        return new Account(this.state, this.nextAddress(true));
    }

    @Override
    public Score deploy(Address addr, Account owner, Object instance) {
        if (!addr.isContract()) {
            throw new IllegalArgumentException("AddressMustBeContract");
        }
        Account account = this.getAccount(addr);
        Score score = new Score(account, owner);
        score.setInstance(instance);
        this.state.setScore(addr, score);
        return score;
    }

    Address getOwner() {
        Address address = this.getCurrentFrame().to.getAddress();
        return this.getScoreFromAddress(address).getOwner().getAddress();
    }

    Address getOrigin() {
        return this.getFirstFrame().from.getAddress();
    }

    Address getCaller() {
        return this.getCurrentFrame().from.getAddress();
    }

    Address getAddress() {
        return this.getCurrentFrame().to.getAddress();
    }

    Account getTarget() {
        return this.getCurrentFrame().to;
    }

    private Score getScoreFromAddress(Address target) {
        Score score = this.state.getScore(target);
        if (score == null) {
            throw new IllegalArgumentException("ContractNotFound(addr=" + target + ")");
        }
        return score;
    }

    @Override
    public void invoke(Account from, BigInteger value, Address targetAddress, String method, Object ... params) {
        try (TXIScope scope = this.setupTransactionInfo(true);){
            this.handleCall(from, value, true, false, targetAddress, method, params);
        }
    }

    @Override
    public Object call(Account from, BigInteger value, Address targetAddress, String method, Object ... params) {
        if (from == null) {
            throw new NullPointerException("from is null");
        }
        try (TXIScope scope = this.setupTransactionInfo(true);){
            Object object = this.handleCall(from, value, true, false, targetAddress, method, params);
            return object;
        }
    }

    @Override
    public Object call(Address targetAddress, String method, Object ... params) {
        return this.handleCall(null, BigInteger.ZERO, false, true, targetAddress, method, params);
    }

    @Override
    public <T> T call(Class<T> cls, Address targetAddress, String method, Object ... params) {
        return TypeConverter.cast(this.handleCall(null, BigInteger.ZERO, false, true, targetAddress, method, params), cls);
    }

    Object call(BigInteger value, Address targetAddress, String method, Object ... params) {
        if (targetAddress.isContract()) {
            Score from = this.getScoreFromAddress(this.getAddress());
            if ("".equals(method)) {
                this.handleTransfer(from.getAccount(), targetAddress, value);
                return null;
            }
            return this.handleCall(from.getAccount(), value, true, false, targetAddress, method, params);
        }
        this.handleTransfer(this.getTarget(), targetAddress, value);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handleCall(Account from, BigInteger value, boolean transfer, boolean readonly, Address targetAddress, String method, Object ... params) {
        Method scoreMethod;
        if (value.signum() < 0) {
            throw new IllegalArgumentException("value is negative");
        }
        Score score = this.getScoreFromAddress(targetAddress);
        Class<?> scoreClass = score.getInstance().getClass();
        try {
            scoreMethod = ServiceManagerImpl.getMethodByName(scoreClass, method);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("NoValidMethod(score=" + score.getAddress() + ",method=" + method + ")");
        }
        if (scoreClass.isAnnotationPresent(TScore.class)) {
            TExternal external = scoreMethod.getAnnotation(TExternal.class);
            if (external == null) {
                throw new IllegalArgumentException("NotExternal(score=" + score.getAddress() + ",method=" + method + ")");
            }
            if (this.isReadonly() && !external.readonly()) {
                throw new IllegalArgumentException("PermissionDenied(score=" + score.getAddress() + ",method=" + method + ")");
            }
            readonly |= external.readonly();
            if (!external.payable() && value.signum() > 0) {
                throw new IllegalArgumentException("NotPayable(score=" + score.getAddress() + ",method=" + method + ")");
            }
            Annotation[][] parameterAnnotations = scoreMethod.getParameterAnnotations();
            int minParams = parameterAnnotations.length;
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                if (!Arrays.stream(parameterAnnotations[i]).anyMatch(a -> a.annotationType().equals(TOptional.class))) continue;
                if (i < minParams) {
                    minParams = i;
                    continue;
                }
                throw new IllegalArgumentException("InvalidOptionalTag(score=" + score.getAddress() + ",method=" + method + ")");
            }
            if (params.length < minParams) {
                throw new IllegalArgumentException("NotEnoughParams(score=" + score.getAddress() + ",method=" + method + ",min=" + minParams + ",given=" + params.length + ")");
            }
        }
        Account to = score.getAccount();
        this.pushFrame(from, to, readonly, method, value);
        try {
            if (value.signum() > 0 && transfer) {
                from.subtractBalance(value);
                to.addBalance(value);
            }
            Object obj = this.invokeMethod(score, method, params);
            this.applyFrame();
            Object object = obj;
            return object;
        }
        finally {
            this.popFrame();
        }
    }

    int getTransactionIndex() {
        TransactionInfo info = txInfo.get();
        return info != null ? info.getIndex() : 0;
    }

    byte[] getTransactionHash() {
        TransactionInfo info = txInfo.get();
        return info != null ? info.getHash() : null;
    }

    long getTransactionTimestamp() {
        TransactionInfo info = txInfo.get();
        return info != null ? info.getTimestamp() : System.currentTimeMillis() * 1000L;
    }

    @Override
    public void transfer(Account from, Address targetAddress, BigInteger value) {
        try (TXIScope scope = this.setupTransactionInfo(true);){
            this.handleTransfer(from, targetAddress, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTransfer(Account from, Address targetAddress, BigInteger value) {
        BigInteger fromBalance = from.getBalance();
        if (fromBalance.compareTo(value) < 0) {
            throw new OutOfBalanceException("OutOfBalance(from=" + from.getAddress() + ",balance=" + fromBalance + ",value=" + value + ")");
        }
        Account to = this.getAccount(targetAddress);
        try {
            this.state.push();
            from.subtractBalance(value);
            to.addBalance(value);
            if (targetAddress.isContract()) {
                this.handleCall(from, value, false, false, targetAddress, "fallback", new Object[0]);
            }
            this.state.apply();
        }
        finally {
            this.state.pop();
        }
    }

    @Override
    public <T> T getValue(Class<T> cls, Address address, String key) {
        return TypeConverter.fromBytes(cls, this.state.getValue(address, key));
    }

    @Override
    public void setValue(Address address, String key, Object value) {
        if (this.isReadonly()) {
            throw new IllegalStateException("SetValueInReadOnly(addr=" + address + ",key=" + key + ",value=" + value + ")");
        }
        this.state.setValue(address, key, TypeConverter.toBytes(value));
    }

    @Override
    public <T> T getValue(Class<T> cls, String key) {
        return this.getValue(cls, this.getAddress(), key);
    }

    @Override
    public void setValue(String key, Object value) {
        this.setValue(this.getAddress(), key, value);
    }

    @Override
    public ServiceManager.Block getBlock() {
        return Block.getLast();
    }

    private boolean isReadonly() {
        return this.contexts.empty() ? false : this.getCurrentFrame().isReadonly();
    }

    protected void pushFrame(Account from, Account to, boolean readonly, String method, BigInteger value) {
        this.contexts.push(new Frame(from, to, this.isReadonly() || readonly, method, value));
        this.state.push();
        if (this.eventLogger != null) {
            this.eventLogger.push();
        }
    }

    protected void popFrame() {
        if (this.eventLogger != null) {
            this.eventLogger.pop();
        }
        this.state.pop();
        this.contexts.pop();
    }

    void applyFrame() {
        if (this.eventLogger != null) {
            this.eventLogger.apply();
        }
        this.state.apply();
    }

    Frame getCurrentFrame() {
        return this.contexts.peek();
    }

    Frame getFirstFrame() {
        return (Frame)this.contexts.firstElement();
    }

    private ServiceManagerImpl() {
    }

    static ServiceManagerImpl getServiceManagerImpl() {
        if (instance == null) {
            instance = new ServiceManagerImpl();
        }
        return instance;
    }

    public static ServiceManager getServiceManager() {
        return ServiceManagerImpl.getServiceManagerImpl();
    }

    private static Object[] convertParameters(Method method, Object[] params) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        int numberOfParams = parameterTypes.length;
        Object[] parsedParams = new Object[numberOfParams];
        int i = 0;
        for (Class<?> parameterClass : parameterTypes) {
            if (parameterClass == Map.class || parameterClass == List.class) {
                throw new IllegalArgumentException(String.format("ProhibitedParameterType(idx=%d,target=%s)", i, parameterClass.getName()));
            }
            if (i >= params.length) {
                parsedParams[i] = null;
            } else {
                try {
                    parsedParams[i] = TypeConverter.cast(params[i], parameterClass);
                }
                catch (RuntimeException e) {
                    throw new IllegalArgumentException(String.format("InvalidParameter(idx=%d,target=%s,source=%s)", i, parameterClass.getName(), params[i].getClass().getName()), e);
                }
            }
            ++i;
        }
        return parsedParams;
    }

    private Object invokeMethod(Score score, String methodName, Object[] params) {
        try {
            Object scoreObj = score.getInstance();
            Method method = ServiceManagerImpl.getMethodByName(scoreObj.getClass(), methodName);
            Object[] methodParameters = ServiceManagerImpl.convertParameters(method, params);
            return method.invoke(scoreObj, methodParameters);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalArgumentException("NoValidMethod(score=" + score.getAddress() + ",method=" + methodName + ")");
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getCause();
            if (target instanceof UserRevertException) {
                UserRevertException ure = (UserRevertException)target;
                throw new UserRevertedException(ure.getCode(), target.getMessage(), target);
            }
            if (target instanceof ManualRevertException) {
                ManualRevertException cre = (ManualRevertException)target;
                throw new UserRevertedException(cre.getCode(), target.getMessage(), target);
            }
            throw new RevertedException(target.getMessage(), target);
        }
    }

    private static Method getMethodByName(Class<?> clazz, String name) throws NoSuchMethodException {
        Method[] m;
        for (Method method : m = clazz.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        throw new NoSuchMethodException("NoSuchMethod(class=" + clazz + ",method=" + name + ")");
    }

    public void logEvent(Object[] indexed, Object[] data) {
        if (this.isReadonly() || this.eventLogger == null) {
            throw new IllegalStateException("ReadOnly mode");
        }
        this.eventLogger.addLog(new Event(this.getAddress(), indexed, data));
    }

    @Override
    public List<Event> getLastEventLogs() {
        return this.lastLogs;
    }

    public static class Frame {
        Account from;
        Account to;
        String method;
        boolean readonly;
        BigInteger value;

        public Frame(Account from, Account to, boolean readonly, String method, BigInteger value) {
            this.from = from;
            this.to = to;
            this.readonly = readonly;
            this.method = method;
            this.value = value;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public BigInteger getValue() {
            return this.value;
        }
    }

    public static class Block
    implements ServiceManager.Block {
        private static Block sLast;
        private static long sBlockInterval;
        private final long height;
        private final long timestamp;

        private Block(long height, long timestamp) {
            this.height = height;
            this.timestamp = timestamp;
        }

        public static Block getLast() {
            if (sLast == null) {
                Random rand = new Random();
                sLast = new Block(rand.nextInt(1000), System.currentTimeMillis() * 1000L);
            }
            return sLast;
        }

        @Override
        public long getHeight() {
            return this.height;
        }

        @Override
        public long getTimestamp() {
            return this.timestamp;
        }

        @Override
        public void increase() {
            Block.next(1L);
        }

        @Override
        public void increase(long delta) {
            Block.next(delta);
        }

        public String toString() {
            return "Block(height=" + this.height + ",ts=" + this.timestamp + ")";
        }

        @Override
        public byte[] hashOfTransactionAt(int idx) {
            return Crypto.sha3_256((this + ":" + idx).getBytes());
        }

        static Block next() {
            return Block.next(1L);
        }

        static Block next(long delta) {
            return Block.next(delta, delta * sBlockInterval);
        }

        static Block next(long delta, long duration) {
            if (txInfo.get() != null) {
                throw new IllegalStateException("NotAllowedToAdvanceBlock");
            }
            if (delta <= 0L) {
                throw new IllegalArgumentException("InvalidHeightDelta(delta=" + delta + ")");
            }
            if (duration <= 0L) {
                throw new IllegalArgumentException("InvalidBlockDuration(duration=" + delta + ")");
            }
            Block last = Block.getLast();
            sLast = new Block(last.height + delta, last.timestamp + duration);
            return sLast;
        }

        static {
            sBlockInterval = 2000000L;
        }
    }

    private static interface TXIScope
    extends AutoCloseable {
        @Override
        public void close();
    }

    static class TransactionInfo {
        private final int index;
        private final byte[] txHash;
        private final Block block;
        private final long ts;
        private static final int kInvalidIndex = -1;

        TransactionInfo(Block blk, int index) {
            this.block = blk;
            if (index >= 0) {
                this.index = index;
                this.txHash = blk.hashOfTransactionAt(index);
                this.ts = blk.getTimestamp() + (long)(index * 10);
            } else {
                this.index = -1;
                this.txHash = null;
                this.ts = 0L;
            }
        }

        public byte[] getHash() {
            return this.txHash != null ? Arrays.copyOf(this.txHash, this.txHash.length) : null;
        }

        public int getIndex() {
            if (this.index < 0) {
                throw new IllegalStateException("NotInTransaction");
            }
            return this.index;
        }

        public long getTimestamp() {
            if (this.index < 0) {
                throw new IllegalStateException("NotInTransaction");
            }
            return this.ts;
        }

        public TransactionInfo next() {
            return new TransactionInfo(this.block, this.index + 1);
        }
    }
}

