/*
 * Decompiled with CFR 0.152.
 */
package score.impl;

import org.bouncycastle.util.encoders.Hex;
import score.ArrayDB;
import score.BranchDB;
import score.DictDB;
import score.VarDB;
import score.impl.AnyDB;
import score.impl.TypeConverter;

public class AnyDBImpl
implements AnyDB {
    private final ValueStore store;
    private final String prefix;
    private final Class<?> leafValue;

    private AnyDBImpl(ValueStore store, String id, Class<?> valueClass) {
        this.store = store;
        this.prefix = id;
        this.leafValue = valueClass;
    }

    private String getSubId(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("null key was supplied");
        }
        byte[] kv = TypeConverter.toBytes(key);
        return this.prefix + "|" + Hex.toHexString((byte[])kv);
    }

    private String getStorageKey(Object k, Type type) {
        return type.name() + this.getSubId(k);
    }

    private String getStorageKey(Type type) {
        return type.name() + this.prefix;
    }

    private void setValue(String key, Object value) {
        this.store.setValue(key, value);
    }

    private <T> T getValue(Class<T> cls, String key) {
        return this.store.getValue(cls, key);
    }

    public void set(Object key, Object value) {
        this.setValue(this.getStorageKey(key, Type.DictDB), value);
    }

    public Object get(Object key) {
        return this.getValue(this.leafValue, this.getStorageKey(key, Type.DictDB));
    }

    public Object getOrDefault(Object key, Object defaultValue) {
        Object v = this.getValue(this.leafValue, this.getStorageKey(key, Type.DictDB));
        return v != null ? v : defaultValue;
    }

    public Object at(Object key) {
        return new AnyDBImpl(this.store, this.getSubId(key), this.leafValue);
    }

    public void add(Object value) {
        int size = this.size();
        this.setValue(this.getStorageKey(size, Type.ArrayDB), value);
        this.setValue(this.getStorageKey(Type.ArrayDB), size + 1);
    }

    public void set(int index, Object value) {
        int size = this.size();
        if (index >= size || index < 0) {
            throw new IllegalArgumentException();
        }
        this.setValue(this.getStorageKey(index, Type.ArrayDB), value);
    }

    @Override
    public void removeLast() {
        this.pop();
    }

    public Object get(int index) {
        int size = this.size();
        if (index >= size || index < 0) {
            throw new IllegalArgumentException();
        }
        return this.getValue(this.leafValue, this.getStorageKey(index, Type.ArrayDB));
    }

    @Override
    public int size() {
        Integer v = this.getValue(Integer.class, this.getStorageKey(Type.ArrayDB));
        if (v == null) {
            return 0;
        }
        return v;
    }

    public Object pop() {
        int size = this.size();
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        Object v = this.getValue(this.leafValue, this.getStorageKey(size - 1, Type.ArrayDB));
        this.setValue(this.getStorageKey(size - 1, Type.ArrayDB), null);
        this.setValue(this.getStorageKey(Type.ArrayDB), size - 1);
        return v;
    }

    public void set(Object value) {
        this.setValue(this.getStorageKey(Type.VarDB), value);
    }

    public Object get() {
        return this.getValue(this.leafValue, this.getStorageKey(Type.VarDB));
    }

    public Object getOrDefault(Object defaultValue) {
        Object v = this.getValue(this.leafValue, this.getStorageKey(Type.VarDB));
        return v != null ? v : defaultValue;
    }

    public static <K, V> BranchDB<K, V> newBranchDB(ValueStore store, String id, Class<?> leafClass) {
        return new AnyDBImpl(store, id, leafClass);
    }

    public static <K, V> DictDB<K, V> newDictDB(ValueStore store, String id, Class<V> leafClass) {
        return new AnyDBImpl(store, id, leafClass);
    }

    public static <E> ArrayDB<E> newArrayDB(ValueStore store, String id, Class<E> leafClass) {
        return new AnyDBImpl(store, id, leafClass);
    }

    public static <E> VarDB<E> newVarDB(ValueStore store, String id, Class<E> leafClass) {
        return new AnyDBImpl(store, id, leafClass);
    }

    public static interface ValueStore {
        public <T> T getValue(Class<T> var1, String var2);

        public void setValue(String var1, Object var2);
    }

    private static enum Type {
        ArrayDB,
        DictDB,
        VarDB;

    }
}

