/*
 * Decompiled with CFR 0.152.
 */
package score.impl;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;
import org.bouncycastle.math.ec.rfc8032.Ed25519;
import org.bouncycastle.util.BigIntegers;
import score.impl.bls12381.BLS12381;

public class Crypto {
    private static final X9ECParameters curveParams = CustomNamedCurves.getByName((String)"secp256k1");
    private static final ECDomainParameters curve = new ECDomainParameters(curveParams.getCurve(), curveParams.getG(), curveParams.getN(), curveParams.getH());

    public static byte[] sha3_256(byte[] msg) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA3-256");
            return digest.digest(msg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unexpected throwable", e);
        }
    }

    public static byte[] sha256(byte[] msg) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(msg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unexpected throwable", e);
        }
    }

    public static byte[] keccack256(byte[] msg) {
        Keccak.Digest256 keccak = new Keccak.Digest256();
        keccak.update(msg);
        return keccak.digest();
    }

    static void require(boolean cond, String msg) {
        if (!cond) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static byte[] hash(String alg, byte[] msg) {
        switch (alg) {
            case "sha-256": {
                return Crypto.sha256(msg);
            }
            case "sha3-256": {
                return Crypto.sha3_256(msg);
            }
            case "keccak-256": {
                return Crypto.keccack256(msg);
            }
        }
        throw new IllegalArgumentException("Unsupported algorithm " + alg);
    }

    public static boolean verifySignature(String alg, byte[] msg, byte[] sig, byte[] pk) {
        switch (alg) {
            case "ed25519": {
                Crypto.require(sig.length == 64, "invalid signature length");
                Crypto.require(pk.length == 32, "invalid public key length");
                return Ed25519.verify((byte[])sig, (int)0, (byte[])pk, (int)0, (byte[])msg, (int)0, (int)msg.length);
            }
            case "ecdsa-secp256k1": {
                Crypto.require(msg.length == 32, "the length of message must be 32");
                Crypto.require(sig.length == 65, "the length of signature must be 65");
                Crypto.require(pk.length == 33 || pk.length == 65, "invalid public key length");
                byte[] recovered = Crypto.recoverECDSAKey(msg, sig, pk.length == 33);
                return Arrays.equals(recovered, pk);
            }
            case "bls12-381-g2": {
                Crypto.require(pk.length == 48, "invalid public key length");
                Crypto.require(sig.length == 96, "invalid signature length");
                return BLS12381.verifyG2Signature(pk, sig, msg);
            }
        }
        throw new IllegalArgumentException("Unsupported algorithm " + alg);
    }

    public static byte[] recoverKey(String alg, byte[] msg, byte[] sig, boolean compressed) {
        if ("ecdsa-secp256k1".equals(alg)) {
            Crypto.require(msg.length == 32, "the length of msgHash must be 32");
            Crypto.require(sig.length == 65, "the length of signature must be 65");
            return Crypto.recoverECDSAKey(msg, sig, compressed);
        }
        throw new IllegalArgumentException("Unsupported algorithm " + alg);
    }

    public static byte[] aggregate(String type, byte[] prevAgg, byte[] values) {
        switch (type) {
            case "bls12-381-g1": {
                Crypto.require(prevAgg == null || prevAgg.length == 48, "invalid prevAgg");
                Crypto.require(values.length % 48 == 0, "invalid values length");
                return BLS12381.aggregateG1Values(prevAgg, values);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + type);
    }

    private static byte[] recoverECDSAKey(byte[] msgHash, byte[] signature, boolean compressed) {
        BigInteger r = BigIntegers.fromUnsignedByteArray((byte[])signature, (int)0, (int)32);
        BigInteger s = BigIntegers.fromUnsignedByteArray((byte[])signature, (int)32, (int)32);
        return Crypto.recoverFromSignature(signature[64], r, s, msgHash, compressed);
    }

    public static byte[] getAddressBytesFromKey(byte[] pubKey) {
        Crypto.checkArgument(pubKey.length == 33 || pubKey.length == 65, "Invalid key length");
        byte[] uncompressed = pubKey.length == 33 ? Crypto.uncompressKey(pubKey) : pubKey;
        byte[] hash = Crypto.sha3_256(Arrays.copyOfRange(uncompressed, 1, uncompressed.length));
        byte[] address = new byte[21];
        System.arraycopy(hash, hash.length - 20, address, 1, 20);
        return address;
    }

    private static byte[] uncompressKey(byte[] compKey) {
        ECPoint point = curve.getCurve().decodePoint(compKey);
        byte[] x = point.getXCoord().getEncoded();
        byte[] y = point.getYCoord().getEncoded();
        byte[] key = new byte[x.length + y.length + 1];
        key[0] = 4;
        System.arraycopy(x, 0, key, 1, x.length);
        System.arraycopy(y, 0, key, x.length + 1, y.length);
        return key;
    }

    private static ECPoint decompressKey(BigInteger xBN, boolean yBit) {
        X9IntegerConverter x9 = new X9IntegerConverter();
        byte[] compEnc = x9.integerToBytes(xBN, 1 + x9.getByteLength(curve.getCurve()));
        compEnc[0] = (byte)(yBit ? 3 : 2);
        return curve.getCurve().decodePoint(compEnc);
    }

    private static byte[] recoverFromSignature(int recId, BigInteger r, BigInteger s, byte[] message, boolean compressed) {
        Crypto.checkArgument(recId >= 0, "recId must be positive");
        Crypto.checkArgument(r.signum() >= 0, "r must be positive");
        Crypto.checkArgument(s.signum() >= 0, "s must be positive");
        BigInteger n = curve.getN();
        BigInteger i = BigInteger.valueOf((long)recId / 2L);
        BigInteger x = r.add(i.multiply(n));
        BigInteger prime = SecP256K1Curve.q;
        if (x.compareTo(prime) >= 0) {
            return null;
        }
        ECPoint ecPoint = Crypto.decompressKey(x, (recId & 1) == 1);
        if (!ecPoint.multiply(n).isInfinity()) {
            return null;
        }
        BigInteger e = new BigInteger(1, message);
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(n);
        BigInteger rInv = r.modInverse(n);
        BigInteger srInv = rInv.multiply(s).mod(n);
        BigInteger eInvrInv = rInv.multiply(eInv).mod(n);
        ECPoint q = ECAlgorithms.sumOfTwoMultiplies((ECPoint)curve.getG(), (BigInteger)eInvrInv, (ECPoint)ecPoint, (BigInteger)srInv);
        return q.getEncoded(compressed);
    }

    private static void checkArgument(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static byte[] bls12381G1Add(byte[] data, boolean compressed) {
        try {
            return BLS12381.g1Add(data, compressed);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static byte[] bls12381G2Add(byte[] data, boolean compressed) {
        try {
            return BLS12381.g2Add(data, compressed);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static byte[] bls12381G1ScalarMul(byte[] scalar, byte[] data, boolean compressed) {
        try {
            return BLS12381.g1ScalarMul(scalar, data, compressed);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static byte[] bls12381G2ScalarMul(byte[] scalar, byte[] data, boolean compressed) {
        try {
            return BLS12381.g2ScalarMul(scalar, data, compressed);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static boolean bls12381PairingCheck(byte[] data, boolean compressed) {
        try {
            return BLS12381.pairingCheck(data, compressed);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }
}

