/*
 * Decompiled with CFR 0.152.
 */
package score.impl;

import foundation.icon.ee.io.DataWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Objects;
import score.Address;
import score.ByteArrayObjectWriter;
import score.ObjectWriter;

public class ObjectWriterImpl
implements ByteArrayObjectWriter {
    private final DataWriter writer;
    private int level = 0;

    public ObjectWriterImpl(DataWriter writer) {
        this.writer = writer;
    }

    @Override
    public void write(boolean v) {
        this.writer.write(v);
    }

    @Override
    public void write(byte v) {
        this.writer.write(v);
    }

    @Override
    public void write(short v) {
        this.writer.write(v);
    }

    @Override
    public void write(char v) {
        this.writer.write(v);
    }

    @Override
    public void write(int v) {
        this.writer.write(v);
    }

    @Override
    public void write(float v) {
        this.writer.write(v);
    }

    @Override
    public void write(long v) {
        this.writer.write(v);
    }

    @Override
    public void write(double v) {
        this.writer.write(v);
    }

    @Override
    public void write(BigInteger v) {
        this.writer.write(v);
    }

    @Override
    public void write(String v) {
        this.writer.write(v);
    }

    @Override
    public void write(byte[] v) {
        this.writer.write(v);
    }

    @Override
    public void write(Address v) {
        this.writer.write(v.toByteArray());
    }

    @Override
    public void write(Object v) {
        Objects.requireNonNull(v);
        Class<?> c = v.getClass();
        if (c == Boolean.class) {
            this.write((Boolean)v);
        } else if (c == Byte.class) {
            this.write((Byte)v);
        } else if (c == Short.class) {
            this.write((Short)v);
        } else if (c == Character.class) {
            this.write(((Character)v).charValue());
        } else if (c == Integer.class) {
            this.write((Integer)v);
        } else if (c == Float.class) {
            this.write(((Float)v).floatValue());
        } else if (c == Long.class) {
            this.write((Long)v);
        } else if (c == Double.class) {
            this.write((Double)v);
        } else if (c == BigInteger.class) {
            this.write((BigInteger)v);
        } else if (c == String.class) {
            this.write((String)v);
        } else if (c == byte[].class) {
            this.write((byte[])v);
        } else if (c == Address.class) {
            this.write((Address)v);
        } else {
            try {
                Method m = c.getDeclaredMethod("writeObject", ObjectWriter.class, c);
                if ((m.getModifiers() & 8) == 0 || (m.getModifiers() & 1) == 0) {
                    throw new IllegalArgumentException();
                }
                m.invoke(null, this, v);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void writeNullable(Object v) {
        this.writer.writeNullity(v == null);
        if (v != null) {
            this.write(v);
        }
    }

    @Override
    public void write(Object ... v) {
        for (Object obj : v) {
            this.write(obj);
        }
    }

    @Override
    public void writeNullable(Object ... v) {
        for (Object e : v) {
            this.writeNullable(e);
        }
    }

    @Override
    public void writeNull() {
        this.writer.writeNullity(true);
    }

    @Override
    public void beginList(int l) {
        ++this.level;
        this.writer.writeListHeader(l);
    }

    @Override
    public void beginNullableList(int l) {
        this.writer.writeNullity(false);
        this.beginList(l);
    }

    @Override
    public void writeListOf(Object ... v) {
        this.beginList(v.length);
        this.write(v);
        this.end();
    }

    @Override
    public void writeListOfNullable(Object ... v) {
        this.beginList(v.length);
        this.writeNullable(v);
        this.end();
    }

    @Override
    public void beginMap(int l) {
        ++this.level;
        this.writer.writeMapHeader(l);
    }

    @Override
    public void beginNullableMap(int l) {
        this.writer.writeNullity(false);
        this.beginMap(l);
    }

    @Override
    public void end() {
        if (this.level == 0) {
            throw new IllegalStateException();
        }
        this.writer.writeFooter();
        --this.level;
    }

    @Override
    public byte[] toByteArray() {
        return this.writer.toByteArray();
    }
}

