/*
 * Decompiled with CFR 0.152.
 */
package score.impl;

import foundation.icon.ee.io.RLPNDataReader;
import foundation.icon.ee.io.RLPNDataWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import score.Address;
import score.impl.ObjectReaderImpl;
import score.impl.ObjectWriterImpl;
import score.impl.struct.Property;
import score.impl.struct.ReadableProperty;
import score.impl.struct.WritableProperty;

public class TypeConverter {
    private static final BigInteger CharacterMAX = BigInteger.valueOf(65535L);
    private static final BigInteger CharacterMIN = BigInteger.valueOf(0L);

    private static Object normalize(Object so) {
        return TypeConverter.normalize(so, false);
    }

    private static Object normalize(Object so, boolean ret) {
        if (so == null) {
            return null;
        }
        Class<?> clz = so.getClass();
        if (so instanceof Boolean) {
            return so;
        }
        if (so instanceof Character) {
            return BigInteger.valueOf(((Character)so).charValue());
        }
        if (so instanceof Byte) {
            return BigInteger.valueOf(((Byte)so).byteValue());
        }
        if (so instanceof Short) {
            return BigInteger.valueOf(((Short)so).shortValue());
        }
        if (so instanceof Integer) {
            return BigInteger.valueOf(((Integer)so).intValue());
        }
        if (so instanceof Long) {
            return BigInteger.valueOf((Long)so);
        }
        if (so instanceof String) {
            return so;
        }
        if (so instanceof BigInteger) {
            return so;
        }
        if (so instanceof Address) {
            Address o = (Address)so;
            return new Address(o.toByteArray());
        }
        if (so instanceof byte[]) {
            byte[] o = (byte[])so;
            byte[] no = new byte[o.length];
            System.arraycopy(o, 0, no, 0, o.length);
            return no;
        }
        if (so instanceof boolean[]) {
            boolean[] o = (boolean[])so;
            Object[] no = new Object[o.length];
            for (int i = 0; i < o.length; ++i) {
                no[i] = o[i];
            }
            return ret ? List.of(no) : no;
        }
        if (so instanceof char[]) {
            char[] o = (char[])so;
            Object[] no = new Object[o.length];
            for (int i = 0; i < o.length; ++i) {
                no[i] = BigInteger.valueOf(o[i]);
            }
            return ret ? List.of(no) : no;
        }
        if (so instanceof short[]) {
            short[] o = (short[])so;
            Object[] no = new Object[o.length];
            for (int i = 0; i < o.length; ++i) {
                no[i] = BigInteger.valueOf(o[i]);
            }
            return ret ? List.of(no) : no;
        }
        if (so instanceof int[]) {
            int[] o = (int[])so;
            Object[] no = new Object[o.length];
            for (int i = 0; i < o.length; ++i) {
                no[i] = BigInteger.valueOf(o[i]);
            }
            return ret ? List.of(no) : no;
        }
        if (so instanceof long[]) {
            long[] o = (long[])so;
            Object[] no = new Object[o.length];
            for (int i = 0; i < o.length; ++i) {
                no[i] = BigInteger.valueOf(o[i]);
            }
            return ret ? List.of(no) : no;
        }
        if (so instanceof List) {
            List o = (List)so;
            Object[] no = new Object[o.size()];
            for (int i = 0; i < no.length; ++i) {
                no[i] = TypeConverter.normalize(o.get(i), ret);
            }
            return ret ? List.of(no) : no;
        }
        if (so instanceof Map) {
            Map o = (Map)so;
            LinkedHashMap no = new LinkedHashMap();
            for (Map.Entry pair : o.entrySet()) {
                no.put(pair.getKey(), TypeConverter.normalize(pair.getValue(), ret));
            }
            return no;
        }
        if (clz.isArray()) {
            Object[] o = (Object[])so;
            Object[] no = new Object[o.length];
            for (int i = 0; i < o.length; ++i) {
                no[i] = TypeConverter.normalize(o[i], ret);
            }
            return ret ? List.of(no) : no;
        }
        List<ReadableProperty> rProps = Property.getReadableProperties(so);
        if (rProps.isEmpty()) {
            throw new IllegalArgumentException();
        }
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (ReadableProperty rp : rProps) {
            try {
                map.put(rp.getName(), TypeConverter.normalize(rp.get(so), ret));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return map;
    }

    protected static void requireCharacterRange(BigInteger value) {
        if (value.compareTo(CharacterMAX) > 0 || value.compareTo(CharacterMIN) < 0) {
            throw new ArithmeticException("out of char range");
        }
    }

    public static Object castArray(Object so, Class<?> arrayCls) {
        Class<?> cls = arrayCls.getComponentType();
        if (cls == Character.TYPE) {
            Object[] o = (Object[])so;
            char[] no = new char[o.length];
            for (int i = 0; i < o.length; ++i) {
                BigInteger value = (BigInteger)o[i];
                TypeConverter.requireCharacterRange(value);
                no[i] = (char)value.intValueExact();
            }
            return no;
        }
        if (cls == Boolean.TYPE) {
            Object[] o = (Object[])so;
            boolean[] no = new boolean[o.length];
            for (int i = 0; i < o.length; ++i) {
                no[i] = (Boolean)o[i];
            }
            return no;
        }
        if (cls == Short.TYPE) {
            Object[] o = (Object[])so;
            short[] no = new short[o.length];
            for (int i = 0; i < o.length; ++i) {
                no[i] = ((BigInteger)o[i]).shortValueExact();
            }
            return no;
        }
        if (cls == Integer.TYPE) {
            Object[] o = (Object[])so;
            int[] no = new int[o.length];
            for (int i = 0; i < o.length; ++i) {
                no[i] = ((BigInteger)o[i]).intValueExact();
            }
            return no;
        }
        if (cls == Long.TYPE) {
            Object[] o = (Object[])so;
            long[] no = new long[o.length];
            for (int i = 0; i < o.length; ++i) {
                no[i] = ((BigInteger)o[i]).longValueExact();
            }
            return no;
        }
        Object[] o = (Object[])so;
        Object no = Array.newInstance(cls, o.length);
        for (int i = 0; i < o.length; ++i) {
            Array.set(no, i, TypeConverter.specialize(o[i], cls));
        }
        return no;
    }

    public static <T> T cast(Object so, Class<T> cls) {
        return (T)TypeConverter.specialize(TypeConverter.normalize(so), cls);
    }

    public static Object cast(Object so) {
        return TypeConverter.normalize(so, true);
    }

    private static Object specialize(Object so, Class<?> cls) {
        if (so == null) {
            return null;
        }
        if (cls == so.getClass() || cls == Boolean.TYPE) {
            return so;
        }
        if (cls == Byte.TYPE) {
            BigInteger o = (BigInteger)so;
            return o.byteValueExact();
        }
        if (cls == Character.TYPE) {
            BigInteger o = (BigInteger)so;
            TypeConverter.requireCharacterRange(o);
            return Character.valueOf((char)o.intValue());
        }
        if (cls == Short.TYPE) {
            BigInteger o = (BigInteger)so;
            return o.shortValueExact();
        }
        if (cls == Integer.TYPE) {
            return ((BigInteger)so).intValueExact();
        }
        if (cls == Long.TYPE) {
            return ((BigInteger)so).longValueExact();
        }
        if (cls == List.class) {
            Object[] o = (Object[])so;
            return Collections.unmodifiableList(Arrays.asList(o));
        }
        if (cls == Map.class) {
            Map o = (Map)so;
            return Map.copyOf(o);
        }
        if (cls.isArray()) {
            return TypeConverter.castArray(so, cls);
        }
        if (cls == Address.class) {
            return so;
        }
        if (so instanceof Map) {
            try {
                Map o = (Map)so;
                Constructor<?> ctor = cls.getConstructor(new Class[0]);
                Object res = ctor.newInstance(new Object[0]);
                for (Map.Entry e : o.entrySet()) {
                    WritableProperty wp = Property.getWritableProperty(cls, (String)e.getKey());
                    if (wp == null) {
                        throw new IllegalArgumentException("no prop for " + (String)e.getKey());
                    }
                    wp.set(res, TypeConverter.specialize(e.getValue(), wp.getType()));
                }
                return res;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalArgumentException(String.format("InvalidStructType(target=%s)", cls.getName()), e);
            }
        }
        throw new IllegalArgumentException(String.format("UnsupportedTargetClass(target=%s,source=%s)", cls.getName(), so.getClass().getName()));
    }

    public static boolean isValidEventValue(Object obj) {
        if (obj == null || obj instanceof BigInteger || obj instanceof Boolean || obj instanceof String || obj instanceof Address) {
            return true;
        }
        Class<?> clz = obj.getClass();
        return clz.isArray() && clz.getComponentType() == Byte.TYPE;
    }

    public static Object[] asEventObjects(Object[] objs) {
        Object[] normalized = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            normalized[i] = TypeConverter.normalize(objs[i], false);
        }
        return normalized;
    }

    public static byte[] toBytes(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return ((String)v).getBytes(StandardCharsets.UTF_8);
        }
        if (v instanceof byte[]) {
            byte[] value = (byte[])v;
            return Arrays.copyOf(value, value.length);
        }
        if (v instanceof Boolean) {
            return BigInteger.valueOf((Boolean)v != false ? 1L : 0L).toByteArray();
        }
        if (v instanceof Byte) {
            return BigInteger.valueOf(((Byte)v).byteValue()).toByteArray();
        }
        if (v instanceof Character) {
            return BigInteger.valueOf(((Character)v).charValue()).toByteArray();
        }
        if (v instanceof Short) {
            return BigInteger.valueOf(((Short)v).shortValue()).toByteArray();
        }
        if (v instanceof Integer) {
            return BigInteger.valueOf(((Integer)v).intValue()).toByteArray();
        }
        if (v instanceof Long) {
            return BigInteger.valueOf((Long)v).toByteArray();
        }
        if (v instanceof BigInteger) {
            return ((BigInteger)v).toByteArray();
        }
        if (v instanceof Address) {
            return ((Address)v).toByteArray();
        }
        ObjectWriterImpl w = new ObjectWriterImpl(new RLPNDataWriter());
        w.write(v);
        return w.toByteArray();
    }

    public static <T> T fromBytes(Class<T> cls, byte[] bs) {
        return cls.cast(TypeConverter.fromBytesReal(cls, bs));
    }

    private static Object fromBytesReal(Class<?> cls, byte[] bs) {
        if (bs == null) {
            return null;
        }
        if (cls == byte[].class) {
            return Arrays.copyOf(bs, bs.length);
        }
        if (cls == Boolean.class) {
            if (bs.length != 1) {
                throw new IllegalArgumentException("invalid length for boolean len=" + bs.length);
            }
            if (bs[0] == 1) {
                return Boolean.TRUE;
            }
            if (bs[0] == 0) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("invalid value for boolean value=" + bs[0]);
        }
        if (cls == Byte.class) {
            BigInteger value = new BigInteger(bs);
            return value.byteValueExact();
        }
        if (cls == Character.class) {
            BigInteger value = new BigInteger(bs);
            TypeConverter.requireCharacterRange(value);
            return Character.valueOf((char)value.intValue());
        }
        if (cls == Short.class) {
            BigInteger value = new BigInteger(bs);
            return value.shortValueExact();
        }
        if (cls == Integer.class) {
            BigInteger value = new BigInteger(bs);
            return value.intValueExact();
        }
        if (cls == Long.class) {
            BigInteger value = new BigInteger(bs);
            return value.longValueExact();
        }
        if (cls == BigInteger.class) {
            return new BigInteger(bs);
        }
        if (cls == String.class) {
            return new String(bs, StandardCharsets.UTF_8);
        }
        if (cls == Address.class) {
            return new Address(bs);
        }
        ObjectReaderImpl r = new ObjectReaderImpl(new RLPNDataReader(bs));
        return r.read(cls);
    }
}

