/*
 * Decompiled with CFR 0.152.
 */
package score.impl.bls12381;

import supranational.blst.BLST_ERROR;
import supranational.blst.P1;
import supranational.blst.P1_Affine;
import supranational.blst.P2;
import supranational.blst.P2_Affine;
import supranational.blst.PT;
import supranational.blst.Scalar;

public class BLS12381 {
    private static final String dst = "BLS_SIG_BLS12381G2_XMD:SHA-256_SSWU_RO_POP_";
    public static final int G1_LEN = 48;
    public static final int G2_LEN = 96;
    private static final P1 I = new P1();

    public static P1 identity() {
        return I.dup();
    }

    public static byte[] aggregateG1Values(byte[] prevAgg, byte[] values) {
        try {
            P1 res;
            if (prevAgg != null) {
                res = new P1(prevAgg);
                if (!res.in_group()) {
                    throw new IllegalArgumentException("prevAgg is not in group");
                }
            } else {
                res = I.dup();
            }
            int nValues = values.length / 48;
            byte[] pk = new byte[48];
            for (int i = 0; i < nValues; ++i) {
                System.arraycopy(values, i * 48, pk, 0, 48);
                P1_Affine p1a = new P1_Affine(pk);
                if (!p1a.in_group()) {
                    throw new IllegalArgumentException("a value is not in group");
                }
                res.aggregate(p1a);
            }
            return res.compress();
        }
        catch (Throwable e) {
            if (!(e instanceof IllegalArgumentException)) {
                throw new IllegalArgumentException(e.getMessage());
            }
            return null;
        }
    }

    public static boolean verifyG2Signature(byte[] pubKey, byte[] sig, byte[] msg) {
        try {
            P1_Affine p1a = new P1_Affine(pubKey);
            P2_Affine p2a = new P2_Affine(sig);
            BLST_ERROR err = p2a.core_verify(p1a, true, msg, dst);
            return err == BLST_ERROR.BLST_SUCCESS;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static byte[] g1Add(byte[] data, boolean compressed) {
        int size;
        P1 acc = new P1();
        int n = size = compressed ? 48 : 96;
        if (data.length == 0 || data.length % size != 0) {
            throw new IllegalArgumentException("BLS12-381: g1Add: invalid data layout: expected a multiple of " + size + " bytes, got " + data.length);
        }
        byte[] buf = new byte[size];
        for (int i = 0; i < data.length; i += size) {
            System.arraycopy(data, i, buf, 0, size);
            acc = acc.add(new P1(buf));
        }
        return compressed ? acc.compress() : acc.serialize();
    }

    public static byte[] g2Add(byte[] data, boolean compressed) {
        int size;
        P2 acc = new P2();
        int n = size = compressed ? 96 : 192;
        if (data.length == 0 || data.length % size != 0) {
            throw new IllegalArgumentException("BLS12-381: g2Add: invalid data layout: expected a multiple of " + size + " bytes, got " + data.length);
        }
        byte[] buf = new byte[size];
        for (int i = 0; i < data.length; i += size) {
            System.arraycopy(data, i, buf, 0, size);
            acc = acc.add(new P2(buf));
        }
        return compressed ? acc.compress() : acc.serialize();
    }

    public static byte[] g1ScalarMul(byte[] scalarBytes, byte[] data, boolean compressed) {
        int size = compressed ? 48 : 96;
        Scalar scalar = new Scalar().from_bendian(scalarBytes);
        if (data.length != size) {
            throw new IllegalArgumentException("BLS12-381: g1ScalarMul: invalid data layout: expected " + size + " bytes, got " + data.length);
        }
        P1 p = new P1(data);
        p = p.mult(scalar);
        return compressed ? p.compress() : p.serialize();
    }

    public static byte[] g2ScalarMul(byte[] scalarBytes, byte[] data, boolean compressed) {
        int size = compressed ? 96 : 192;
        Scalar scalar = new Scalar().from_bendian(scalarBytes);
        if (data.length != size) {
            throw new IllegalArgumentException("BLS12-381: g2ScalarMul: invalid data layout: expected " + size + " bytes, got " + data.length);
        }
        P2 p = new P2(data);
        p = p.mult(scalar);
        return compressed ? p.compress() : p.serialize();
    }

    public static boolean pairingCheck(byte[] data, boolean compressed) {
        int g1Size = compressed ? 48 : 96;
        int g2Size = compressed ? 96 : 192;
        int size = g1Size + g2Size;
        if (data.length == 0 || data.length % size != 0) {
            throw new IllegalArgumentException("BLS12-381: pairingCheck: invalid data layout: expected a multiple of " + size + " bytes, got " + data.length);
        }
        PT acc = PT.one();
        byte[] p1buf = new byte[g1Size];
        byte[] p2buf = new byte[g2Size];
        for (int i = 0; i < data.length; i += size) {
            System.arraycopy(data, i, p1buf, 0, g1Size);
            System.arraycopy(data, i + g1Size, p2buf, 0, g2Size);
            P1 p1 = new P1(p1buf);
            P2 p2 = new P2(p2buf);
            if (!p1.in_group() || !p2.in_group()) {
                throw new IllegalArgumentException("G1 or G2 point not in subgroup!");
            }
            if (p1.is_inf() || p2.is_inf()) continue;
            acc = acc.mul(new PT(p1, p2));
        }
        return acc.final_exp().is_one();
    }
}

