/*
 * Decompiled with CFR 0.152.
 */
package com.iconloop.score.test;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import score.Address;

public class Account {
    private static final Map<Address, Account> accounts = new HashMap<Address, Account>();
    private final Address address;
    private final Map<String, BigInteger> balances = new HashMap<String, BigInteger>();

    public static Account newExternalAccount(int seed) {
        Account acct = new Account(0, seed);
        accounts.put(acct.getAddress(), acct);
        return acct;
    }

    public static Account newScoreAccount(int seed) {
        Account acct = new Account(1, seed);
        accounts.put(acct.getAddress(), acct);
        return acct;
    }

    public static Account getAccount(Address address) {
        return accounts.get(address);
    }

    private Account(int type, int seed) {
        byte[] ba = new byte[21];
        ba[0] = (byte)type;
        int index = ba.length - 1;
        ba[index--] = (byte)seed;
        ba[index--] = (byte)(seed >> 8);
        ba[index--] = (byte)(seed >> 16);
        ba[index] = (byte)(seed >> 24);
        this.address = new Address(ba);
    }

    public Address getAddress() {
        return this.address;
    }

    public void addBalance(String symbol, BigInteger value) {
        this.balances.put(symbol, this.getBalance(symbol).add(value));
    }

    public void subtractBalance(String symbol, BigInteger value) {
        this.balances.put(symbol, this.getBalance(symbol).subtract(value));
    }

    public BigInteger getBalance(String symbol) {
        return this.balances.getOrDefault(symbol, BigInteger.ZERO);
    }

    public BigInteger getBalance() {
        return this.getBalance("ICX");
    }

    public String toString() {
        return "Account{address=" + this.address + ", balances=" + this.balances + "}";
    }
}

