/*
 * Decompiled with CFR 0.152.
 */
package com.iconloop.score.test;

import com.iconloop.score.test.Account;
import com.iconloop.score.test.ServiceManager;
import com.iconloop.score.test.TestBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import score.Address;

public class Score
extends TestBase {
    private static final ServiceManager sm = Score.getServiceManager();
    private final Account score;
    private final Account owner;
    private Object instance;

    public Score(Account score, Account owner) {
        this.score = score;
        this.owner = owner;
    }

    public Account getAccount() {
        return this.score;
    }

    public Address getAddress() {
        return this.score.getAddress();
    }

    public Account getOwner() {
        return this.owner;
    }

    public void setInstance(Object newInstance) {
        this.instance = newInstance;
    }

    public Object getInstance() {
        return this.instance;
    }

    public Object call(String method, Object ... params) {
        return this.call(null, true, BigInteger.ZERO, method, params);
    }

    public void invoke(Account from, String method, Object ... params) {
        sm.getBlock().increase();
        this.call(from, false, BigInteger.ZERO, method, params);
    }

    Object call(Account from, boolean readonly, BigInteger value, String method, Object ... params) {
        sm.pushFrame(from, this.score, readonly, method, value);
        Class[] paramClasses = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            Class<?> type = params[i].getClass();
            paramClasses[i] = type == Boolean.class ? Boolean.TYPE : type;
        }
        try {
            Class<?> clazz = this.instance.getClass();
            Method m = clazz.getMethod(method, paramClasses);
            Object object = m.invoke(this.instance, params);
            return object;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new AssertionError((Object)e.getTargetException().getMessage());
        }
        finally {
            sm.popFrame();
        }
    }
}

