/*
 * Decompiled with CFR 0.152.
 */
package com.iconloop.score.test;

import com.iconloop.score.test.Account;
import com.iconloop.score.test.Score;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import score.Address;

public class ServiceManager {
    private static final BigInteger ICX = BigInteger.TEN.pow(18);
    private final Stack<Frame> contexts = new Stack();
    private final Map<Class<?>, Score> classScoreMap = new HashMap();
    private final Map<Address, Score> addressScoreMap = new HashMap<Address, Score>();
    private final Map<String, Object> storageMap = new HashMap<String, Object>();
    private int nextCount = 1;

    public Score deploy(Account owner, Class<?> mainClass, Object ... params) throws Exception {
        this.getBlock().increase();
        Score score = new Score(Account.newScoreAccount(this.nextCount++), owner);
        this.classScoreMap.put(mainClass, score);
        this.addressScoreMap.put(score.getAddress(), score);
        this.pushFrame(owner, score.getAccount(), false, "<init>", BigInteger.ZERO);
        try {
            Constructor<?>[] ctor = mainClass.getConstructors();
            if (ctor.length != 1) {
                throw new AssertionError((Object)"multiple public constructors found");
            }
            score.setInstance(ctor[0].newInstance(params));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.popFrame();
        }
        return score;
    }

    public Account createAccount() {
        return this.createAccount(0);
    }

    public Account createAccount(int initialIcx) {
        Account acct = Account.newExternalAccount(this.nextCount++);
        acct.addBalance("ICX", ICX.multiply(BigInteger.valueOf(initialIcx)));
        return acct;
    }

    public Address getOwner() {
        Address address = this.getCurrentFrame().to.getAddress();
        return this.getScoreFromAddress(address).getOwner().getAddress();
    }

    public Address getOrigin() {
        return this.getFirstFrame().from.getAddress();
    }

    public Address getCaller() {
        return this.getCurrentFrame().from.getAddress();
    }

    public Address getAddress() {
        return this.getCurrentFrame().to.getAddress();
    }

    private Score getScoreFromClass(Class<?> caller) {
        Score score = this.classScoreMap.get(caller);
        if (score == null) {
            for (Class<?> clazz : this.classScoreMap.keySet()) {
                Class<?> superclass = clazz.getSuperclass();
                while (!"java.lang.Object".equals(superclass.getName())) {
                    if (superclass.equals(caller)) {
                        return this.classScoreMap.get(clazz);
                    }
                    superclass = superclass.getSuperclass();
                }
            }
            throw new IllegalStateException(caller.getName() + " not found");
        }
        return score;
    }

    private Score getScoreFromAddress(Address target) {
        Score score = this.addressScoreMap.get(target);
        if (score == null) {
            throw new IllegalStateException("ScoreNotFound");
        }
        return score;
    }

    public Object call(Account from, BigInteger value, Address targetAddress, String method, Object ... params) {
        Score score = this.getScoreFromAddress(targetAddress);
        return score.call(from, false, value, method, params);
    }

    public Object call(Class<?> caller, BigInteger value, Address targetAddress, String method, Object ... params) {
        Score from = this.getScoreFromClass(caller);
        if ("fallback".equals(method) || "".equals(method)) {
            this.transfer(from.getAccount(), targetAddress, value);
            return null;
        }
        return this.call(from.getAccount(), value, targetAddress, method, params);
    }

    public void transfer(Account from, Address targetAddress, BigInteger value) {
        this.getBlock().increase();
        BigInteger fromBalance = from.getBalance();
        if (fromBalance.compareTo(value) < 0) {
            throw new IllegalStateException("OutOfBalance");
        }
        Account to = Account.getAccount(targetAddress);
        if (to == null) {
            throw new IllegalStateException("NoAccount");
        }
        from.subtractBalance("ICX", value);
        to.addBalance("ICX", value);
        if (targetAddress.isContract()) {
            this.call(from, value, targetAddress, "fallback", new Object[0]);
        }
    }

    public void putStorage(String key, Object value) {
        this.storageMap.put(this.getAddress().toString() + key, value);
    }

    public Object getStorage(String key) {
        return this.storageMap.get(this.getAddress().toString() + key);
    }

    public Block getBlock() {
        return Block.getInstance();
    }

    protected void pushFrame(Account from, Account to, boolean readonly, String method, BigInteger value) {
        this.contexts.push(new Frame(from, to, readonly, method, value));
    }

    protected void popFrame() {
        this.contexts.pop();
    }

    public Frame getCurrentFrame() {
        return this.contexts.peek();
    }

    public Frame getFirstFrame() {
        return (Frame)this.contexts.firstElement();
    }

    public static class Frame {
        Account from;
        Account to;
        String method;
        boolean readonly;
        BigInteger value;

        public Frame(Account from, Account to, boolean readonly, String method, BigInteger value) {
            this.from = from;
            this.to = to;
            this.readonly = readonly;
            this.method = method;
            this.value = value;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public BigInteger getValue() {
            return this.value;
        }
    }

    public static class Block {
        private static Block sInstance;
        private long height;
        private long timestamp;

        public Block(long height, long timestamp) {
            this.height = height;
            this.timestamp = timestamp;
        }

        public static Block getInstance() {
            if (sInstance == null) {
                Random rand = new Random();
                sInstance = new Block(rand.nextInt(1000), System.nanoTime() / 1000L);
            }
            return sInstance;
        }

        public long getHeight() {
            return this.height;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void increase() {
            this.increase(1L);
        }

        public void increase(long delta) {
            this.height += delta;
            this.timestamp = System.nanoTime() / 1000L;
        }
    }
}

