/*
 * Decompiled with CFR 0.152.
 */
package score.impl;

import com.iconloop.score.test.ServiceManager;
import com.iconloop.score.test.TestBase;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import score.Address;
import score.impl.AnyDB;

public class AnyDBImpl
extends TestBase
implements AnyDB {
    private static final ServiceManager sm = AnyDBImpl.getServiceManager();
    private final String prefix;
    private final Class<?> leafValue;

    public AnyDBImpl(String id, Class<?> valueClass) {
        this.prefix = id;
        this.leafValue = valueClass;
    }

    private String getSubId(Object key) {
        return this.prefix + this.encodeKey(key);
    }

    private String encodeKey(Object v) {
        if (v == null) {
            return "";
        }
        if (v instanceof String) {
            return (String)v;
        }
        if (v instanceof byte[]) {
            return new String((byte[])v, StandardCharsets.UTF_8);
        }
        if (v instanceof Integer) {
            return BigInteger.valueOf(((Integer)v).intValue()).toString(16);
        }
        if (v instanceof BigInteger) {
            return ((BigInteger)v).toString(16);
        }
        if (v instanceof Address) {
            return v.toString();
        }
        throw new IllegalArgumentException("Unsupported type: " + v.getClass());
    }

    private String getStorageKey(Object k, Type type) {
        return type.name() + this.getSubId(k);
    }

    private void setValue(String key, Object value) {
        sm.putStorage(key, value);
    }

    private Object getValue(String key) {
        return sm.getStorage(key);
    }

    public void set(Object key, Object value) {
        if (sm.getCurrentFrame().isReadonly()) {
            throw new IllegalStateException("read-only context");
        }
        this.setValue(this.getStorageKey(key, Type.DictDB), value);
    }

    public Object get(Object key) {
        return this.getValue(this.getStorageKey(key, Type.DictDB));
    }

    public Object getOrDefault(Object key, Object defaultValue) {
        Object v = this.getValue(this.getStorageKey(key, Type.DictDB));
        return v != null ? v : defaultValue;
    }

    public Object at(Object key) {
        return new AnyDBImpl(this.getSubId(key), this.leafValue);
    }

    public void add(Object value) {
        if (sm.getCurrentFrame().isReadonly()) {
            throw new IllegalStateException("read-only context");
        }
        int size = this.size();
        this.setValue(this.getStorageKey(size, Type.ArrayDB), value);
        this.setValue(this.getStorageKey(null, Type.ArrayDB), size + 1);
    }

    public void set(int index, Object value) {
        if (sm.getCurrentFrame().isReadonly()) {
            throw new IllegalStateException("read-only context");
        }
        int size = this.size();
        if (index >= size || index < 0) {
            throw new IllegalArgumentException();
        }
        this.setValue(this.getStorageKey(index, Type.ArrayDB), value);
    }

    @Override
    public void removeLast() {
        this.pop();
    }

    public Object get(int index) {
        int size = this.size();
        if (index >= size || index < 0) {
            throw new IllegalArgumentException();
        }
        return this.getValue(this.getStorageKey(index, Type.ArrayDB));
    }

    @Override
    public int size() {
        Object v = this.getValue(this.getStorageKey(null, Type.ArrayDB));
        if (v == null) {
            return 0;
        }
        return (Integer)v;
    }

    public Object pop() {
        if (sm.getCurrentFrame().isReadonly()) {
            throw new IllegalStateException("read-only context");
        }
        int size = this.size();
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        Object v = this.getValue(this.getStorageKey(size - 1, Type.ArrayDB));
        this.setValue(this.getStorageKey(size - 1, Type.ArrayDB), null);
        this.setValue(this.getStorageKey(null, Type.ArrayDB), size - 1);
        return v;
    }

    public void set(Object value) {
        if (sm.getCurrentFrame().isReadonly()) {
            throw new IllegalStateException("read-only context");
        }
        this.setValue(this.getStorageKey(null, Type.VarDB), value);
    }

    public Object get() {
        return this.getValue(this.getStorageKey(null, Type.VarDB));
    }

    public Object getOrDefault(Object defaultValue) {
        Object v = this.getValue(this.getStorageKey(null, Type.VarDB));
        return v != null ? v : defaultValue;
    }

    private static enum Type {
        ArrayDB,
        DictDB,
        VarDB;

    }
}

