/*
 * Decompiled with CFR 0.152.
 */
package score.impl;

import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import score.Address;
import score.ByteArrayObjectWriter;
import score.ObjectWriter;

public class RLPObjectWriter
implements ByteArrayObjectWriter {
    private static final int SHORT_BASE = 128;
    private static final int SHORT_LEN_LIMIT = 55;
    private static final int LONG_BASE = 183;
    private final ArrayList<ByteArrayBuilder> frames = new ArrayList();
    private ByteArrayBuilder os = new ByteArrayBuilder();
    private int level = 0;

    public RLPObjectWriter() {
        this.frames.add(this.os);
    }

    private void writeRLPString(byte[] bs) {
        int l = bs.length;
        if (l == 1 && (bs[0] & 0xFF) < 128) {
            this.os.write(bs[0]);
        } else if (l <= 55) {
            this.os.write(128 + l);
            this.os.write(bs, 0, l);
        } else if (l <= 255) {
            this.os.write(184);
            this.os.write(l);
            this.os.write(bs, 0, l);
        } else if (l <= 65535) {
            this.os.write(185);
            this.os.write(l >> 8);
            this.os.write(l);
            this.os.write(bs, 0, l);
        } else if (l <= 0xFFFFFF) {
            this.os.write(186);
            this.os.write(l >> 16);
            this.os.write(l >> 8);
            this.os.write(l);
            this.os.write(bs, 0, l);
        } else {
            this.os.write(187);
            this.os.write(l >> 24);
            this.os.write(l >> 16);
            this.os.write(l >> 8);
            this.os.write(l);
            this.os.write(bs, 0, l);
        }
    }

    @Override
    public void write(boolean v) {
        this.writeRLPString(BigInteger.valueOf(v ? 1L : 0L).toByteArray());
    }

    @Override
    public void write(byte v) {
        this.writeRLPString(BigInteger.valueOf(v).toByteArray());
    }

    @Override
    public void write(short v) {
        this.writeRLPString(BigInteger.valueOf(v).toByteArray());
    }

    @Override
    public void write(char v) {
        this.writeRLPString(BigInteger.valueOf(v).toByteArray());
    }

    @Override
    public void write(int v) {
        this.writeRLPString(BigInteger.valueOf(v).toByteArray());
    }

    @Override
    public void write(float v) {
        int i = Float.floatToRawIntBits(v);
        this.os.write(132);
        this.os.write(i >> 24 & 0xFF);
        this.os.write(i >> 16 & 0xFF);
        this.os.write(i >> 8 & 0xFF);
        this.os.write(i & 0xFF);
    }

    @Override
    public void write(long v) {
        this.writeRLPString(BigInteger.valueOf(v).toByteArray());
    }

    @Override
    public void write(double v) {
        long i = Double.doubleToRawLongBits(v);
        this.os.write(136);
        this.os.write((int)(i >> 54) & 0xFF);
        this.os.write((int)(i >> 48) & 0xFF);
        this.os.write((int)(i >> 40) & 0xFF);
        this.os.write((int)(i >> 32) & 0xFF);
        this.os.write((int)(i >> 24) & 0xFF);
        this.os.write((int)(i >> 16) & 0xFF);
        this.os.write((int)(i >> 8) & 0xFF);
        this.os.write((int)i & 0xFF);
    }

    @Override
    public void write(BigInteger v) {
        this.writeRLPString(v.toByteArray());
    }

    @Override
    public void write(String v) {
        this.writeRLPString(v.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void write(byte[] v) {
        this.writeRLPString(v);
    }

    @Override
    public void write(Address v) {
        this.writeRLPString(v.toByteArray());
    }

    @Override
    public void write(Object v) {
        Objects.requireNonNull(v);
        Class<?> c = v.getClass();
        if (c == Boolean.class) {
            this.write((Boolean)v);
        } else if (c == Byte.class) {
            this.write((Byte)v);
        } else if (c == Short.class) {
            this.write((Short)v);
        } else if (c == Character.class) {
            this.write(((Character)v).charValue());
        } else if (c == Integer.class) {
            this.write((Integer)v);
        } else if (c == Float.class) {
            this.write(((Float)v).floatValue());
        } else if (c == Long.class) {
            this.write((Long)v);
        } else if (c == Double.class) {
            this.write((Double)v);
        } else if (c == BigInteger.class) {
            this.write((BigInteger)v);
        } else if (c == String.class) {
            this.write((String)v);
        } else if (c == byte[].class) {
            this.write((byte[])v);
        } else if (c == Address.class) {
            this.write((Address)v);
        } else {
            try {
                Method m = c.getDeclaredMethod("writeObject", ObjectWriter.class, c);
                if ((m.getModifiers() & 8) == 0 || (m.getModifiers() & 1) == 0) {
                    throw new IllegalArgumentException();
                }
                m.invoke(null, this, v);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void writeNullable(Object v) {
        this.writeNullity(v == null);
        if (v != null) {
            this.write(v);
        }
    }

    @Override
    public void write(Object ... v) {
        for (Object e : v) {
            this.write(e);
        }
    }

    @Override
    public void writeNullable(Object ... v) {
        for (Object e : v) {
            this.writeNullable(e);
        }
    }

    @Override
    public void writeNull() {
        this.os.write(248);
        this.os.write(0);
    }

    private void writeNullity(boolean nullity) {
        if (nullity) {
            this.writeNull();
        }
    }

    @Override
    public void beginList(int l) {
        ++this.level;
        this.writeListHeader(l);
    }

    @Override
    public void writeListOf(Object ... v) {
        this.writeListHeader(v.length);
        this.write(v);
        this.writeFooter();
    }

    @Override
    public void beginNullableList(int l) {
        ++this.level;
        this.writeNullity(false);
        this.writeListHeader(l);
    }

    @Override
    public void writeListOfNullable(Object ... v) {
        this.writeListHeader(v.length);
        this.writeNullable(v);
        this.writeFooter();
    }

    @Override
    public void beginMap(int l) {
        ++this.level;
        this.writeMapHeader(l);
    }

    @Override
    public void beginNullableMap(int l) {
        ++this.level;
        this.writeNullity(false);
        this.writeMapHeader(l);
    }

    @Override
    public void end() {
        if (this.level == 0) {
            throw new IllegalStateException();
        }
        this.writeFooter();
        --this.level;
    }

    private void writeListHeader(int l) {
        this._writeRLPListHeader();
    }

    private void writeMapHeader(int l) {
        this._writeRLPListHeader();
    }

    private void _writeRLPListHeader() {
        this.os = new ByteArrayBuilder();
        this.frames.add(this.os);
    }

    private void _writeRLPListFooter() {
        ByteArrayBuilder prev = this.os;
        int l = prev.size();
        this.frames.remove(this.frames.size() - 1);
        this.os = this.frames.get(this.frames.size() - 1);
        if (l <= 55) {
            this.os.write(192 + l);
            this.os.write(prev.array(), 0, prev.size());
        } else if (l <= 255) {
            this.os.write(248);
            this.os.write(l);
            this.os.write(prev.array(), 0, prev.size());
        } else if (l <= 65535) {
            this.os.write(249);
            this.os.write(l >> 8 & 0xFF);
            this.os.write(l & 0xFF);
            this.os.write(prev.array(), 0, prev.size());
        } else if (l <= 0xFFFFFF) {
            this.os.write(250);
            this.os.write(l >> 16 & 0xFF);
            this.os.write(l >> 8 & 0xFF);
            this.os.write(l & 0xFF);
            this.os.write(prev.array(), 0, prev.size());
        } else {
            this.os.write(251);
            this.os.write(l >> 24 & 0xFF);
            this.os.write(l >> 16 & 0xFF);
            this.os.write(l >> 8 & 0xFF);
            this.os.write(l & 0xFF);
            this.os.write(prev.array(), 0, prev.size());
        }
    }

    private void writeFooter() {
        this._writeRLPListFooter();
    }

    private void flush() {
        this.os.flush();
    }

    @Override
    public byte[] toByteArray() {
        this.flush();
        return Arrays.copyOfRange(this.os.array(), 0, this.os.size());
    }

    private long getTotalWrittenBytes() {
        return this.os.size();
    }

    public static class ByteArrayBuilder
    extends OutputStream {
        private static final int INITIAL_CAP = 8;
        private byte[] buf = new byte[8];
        private int size;

        private void ensureCap(int req) {
            if (req > this.buf.length) {
                int newCap = this.buf.length * 2;
                if (newCap < req) {
                    newCap = req;
                }
                this.buf = Arrays.copyOf(this.buf, newCap);
            }
        }

        @Override
        public void write(int b) {
            this.ensureCap(this.size + 1);
            this.buf[this.size++] = (byte)b;
        }

        @Override
        public void write(byte[] b) {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.ensureCap(this.size + len);
            System.arraycopy(b, off, this.buf, this.size, len);
            this.size += len;
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        public byte[] array() {
            return this.buf;
        }

        public int size() {
            return this.size;
        }
    }
}

