/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.workers;

import foxtrot.AbstractWorkerThread;
import foxtrot.Task;

public class SingleWorkerThread
extends AbstractWorkerThread
implements Runnable {
    private static int sequence = 0;
    static final boolean debug = false;
    private Thread thread;
    private Link current;
    private boolean pending;

    public void start() {
        if (this.isAlive()) {
            return;
        }
        this.stop();
        this.thread = new Thread((Runnable)this, this.getThreadName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected String getThreadName() {
        return "Foxtrot Single Worker Thread #" + SingleWorkerThread.nextSequence();
    }

    static synchronized int nextSequence() {
        return ++sequence;
    }

    protected void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    public boolean isAlive() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.isAlive() && !this.isThreadInterrupted();
    }

    public boolean isWorkerThread() {
        return Thread.currentThread() == this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postTask(Task t) {
        if (!this.isAlive()) {
            this.start();
        }
        SingleWorkerThread singleWorkerThread = this;
        synchronized (singleWorkerThread) {
            if (this.hasTasks()) {
                Link item = this.current;
                while (item.next != null) {
                    item = item.next;
                }
                item.next = new Link(t);
            } else {
                this.current = new Link(t);
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Task takeTask() throws InterruptedException {
        SingleWorkerThread singleWorkerThread = this;
        synchronized (singleWorkerThread) {
            while (!this.hasTasks()) {
                this.pending = false;
                this.wait();
            }
            this.pending = true;
            Task t = this.current.task;
            this.current = this.current.next;
            return t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasTasks() {
        SingleWorkerThread singleWorkerThread = this;
        synchronized (singleWorkerThread) {
            return this.current != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasPendingTasks() {
        SingleWorkerThread singleWorkerThread = this;
        synchronized (singleWorkerThread) {
            return this.pending;
        }
    }

    protected boolean isThreadInterrupted() {
        return this.thread.isInterrupted();
    }

    public void run() {
        while (!this.isThreadInterrupted()) {
            try {
                Task t = this.takeTask();
                this.run(t);
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    protected void run(Task task) {
        this.runTask(task);
    }

    private static class Link {
        private Link next;
        private final Task task;

        private Link(Task task) {
            this.task = task;
        }
    }
}

