/*
 * Decompiled with CFR 0.152.
 */
package fr.abes.cbs.commandes;

import fr.abes.cbs.connector.Cbs;
import fr.abes.cbs.exception.CBSException;
import fr.abes.cbs.utilitaire.Constants;

public class Commandes {
    private boolean isLogged;
    private boolean isConnected;
    private Cbs connector = new Cbs();
    private String rcr = "";

    public boolean isCmdOk() {
        return this.connector.isCmdOk();
    }

    public void setCmdOk(boolean cmdOk) {
        this.connector.setCmdOk(cmdOk);
    }

    public String log(String login, String pwd) throws CBSException {
        String query = "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CPCSCR 00";
        String resu = this.connector.tcpReq(query);
        if (!this.connector.isCmdOk()) {
            this.isLogged = false;
            return resu;
        }
        resu = this.connector.tcpReq("CUS\\LOG " + login + " " + pwd);
        if (!this.connector.isCmdOk()) {
            this.isLogged = false;
            return resu;
        }
        if ("M03".equals(resu.substring(0, 3)) || "02".equals(resu.substring(0, 2))) {
            this.isLogged = false;
            return resu;
        }
        this.isLogged = true;
        return resu;
    }

    public String connect(String tip, int port1) throws CBSException {
        String errorMsg = this.connector.connect(tip, port1);
        this.isConnected = errorMsg.isEmpty();
        return errorMsg;
    }

    public void disconnect() throws CBSException {
        this.connector.close();
        this.isConnected = false;
        this.isLogged = false;
    }

    public String getErrorMessage() {
        return this.connector.getErrorMessage();
    }

    public void setErrorMessage(String errorMessage) {
        this.connector.setErrorMessage(errorMessage);
    }

    public String view(String noLigne, String lotEncours, String fOrigine) throws CBSException {
        String query = "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CUS\\too S" + lotEncours + "    " + noLigne + " " + fOrigine;
        return this.connector.tcpReq(query);
    }

    public String next(String lotEncours, int pos) throws CBSException {
        String query = "CUS\\too s" + lotEncours + " " + pos + " K";
        return this.connector.tcpReq(query);
    }

    public String valMod(String notice, int lgnotice, String lotEncours, String ppnEncours, String noRecordEnEdit, String noticedeb, String leact) throws CBSException {
        String query = "VSE" + lotEncours + Constants.STR_1D + "VTI1" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CPC\\MUT \\PPN " + ppnEncours + " UNM;\\TOO S" + lotEncours + " " + noRecordEnEdit + " " + "UNMA" + Constants.STR_1D + "BBWVDA0" + Constants.STR_1E + "VTX0T" + noticedeb + Constants.STR_1F + "D" + lgnotice + Constants.STR_1F + "I" + leact + notice + Constants.STR_0D + Constants.STR_0D + Constants.STR_0D + Constants.STR_1F + Constants.STR_1E;
        return this.connector.tcpReq(query);
    }

    public String transliterer(String notice, String leact, String timeStpEnCours, String lotEnCours, String ppnEncours) throws CBSException {
        int lettsp = Integer.parseInt(timeStpEnCours.substring(0, 4));
        String query = "VSE" + lotEnCours + Constants.STR_1D + "VTI1" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CPC\\TRA \\PPN " + ppnEncours.replaceAll("\\$a", "") + " " + "UNM" + Constants.STR_1D + "BBWVDA0" + Constants.STR_1E + "VTX0TBIB" + timeStpEnCours + Constants.STR_1F + "D" + --lettsp + Constants.STR_1F + "I" + leact + notice + Constants.STR_1F + Constants.STR_1E + Constants.STR_1D;
        return this.connector.tcpReq(query);
    }

    public String translitererSansPPN(String notice) throws CBSException {
        String query = "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CUScre e";
        String resu = this.connector.tcpReq(query);
        if (this.connector.isCmdOk() && this.connector.getErrorMessage().isEmpty() && resu.contains("VOK")) {
            query = "VSE3" + Constants.STR_1D + "VTI1" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CPC\\TRA \\2 UNM" + Constants.STR_1D + "BBWVDA0" + Constants.STR_1E + "VTX0TBIB000200:00:00.000" + Constants.STR_1F + "D" + "1" + Constants.STR_1F + "I" + notice + Constants.FINLIGNE;
            return this.connector.tcpReq(query);
        }
        return resu;
    }

    public String sup(String nonotice, String lotEncours, String ppnEncours) throws CBSException {
        String query = "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CPC\\KIL \\PPN " + ppnEncours + ";\\TOO S" + lotEncours + " " + nonotice + " " + "UNMA";
        return this.connector.tcpReq(query);
    }

    public String supL(String lotEncours) throws CBSException {
        String query = "VTI1" + Constants.STR_1D + "VSE" + lotEncours + Constants.STR_1D + "VPRUNM" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CUSsup l";
        return this.connector.tcpReq(query);
    }

    public String valSupL(String lotEncours, String ppnEncours) throws CBSException {
        String query = "VSE" + lotEncours + Constants.STR_1D + "VTI1" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CPC\\KIL \\PPN " + ppnEncours + " L;\\TOO S" + lotEncours + " 1 " + "UNM" + Constants.STR_1D;
        return this.connector.tcpReq(query);
    }

    public String setParams(String[] params) throws CBSException {
        String triResultats = params[0];
        String triVol = params[1];
        String cleBal = params[2];
        String cleRech = params[3];
        String formatList = params[4];
        String formatListPEB = params[5];
        String formatDetail = params[6];
        String formatUnload = params[7];
        String formatModif = params[8];
        String nbResuAut = params[9];
        String reinitLim = params[10];
        String numLots = params[11];
        String rechNotLies = params[12];
        String triAuto = params[13];
        String affautoBU = params[14];
        String inconnu1 = params[15];
        String telechFormat = params[16];
        String affExemplaires = params[17];
        String inconnu2 = params[18];
        String formatDetailPEB = params[19];
        String triresults = params[20];
        String forceCollation = params[21];
        String erreurval = params[22];
        String query = "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CPC\\MUT \\PAR" + Constants.STR_1D + "BPAVSS0" + triResultats + Constants.STR_1E + "VMP0" + triVol + Constants.STR_1E + "VMS0" + cleBal + Constants.STR_1E + "VMZ0" + cleRech + Constants.STR_1E + "VDK0" + formatList + Constants.STR_1E + "VAK0" + formatListPEB + Constants.STR_1E + "VDL0" + formatDetail + Constants.STR_1E + "VDD0" + formatUnload + Constants.STR_1E + "VDB0" + formatModif + Constants.STR_1E + "VLI0" + nbResuAut + Constants.STR_1E + "VRE0" + reinitLim + Constants.STR_1E + "VNR0" + numLots + Constants.STR_1E + "VZR0" + rechNotLies + Constants.STR_1E + "VSB0" + triAuto + Constants.STR_1E + "VSL0" + affautoBU + Constants.STR_1E + "VEK0" + inconnu1 + Constants.STR_1E + "VMI0" + telechFormat + Constants.STR_1E + "VCM0" + affExemplaires + Constants.STR_1E + "VFC0" + inconnu2 + Constants.STR_1E + "VAL0" + formatDetailPEB + Constants.STR_1E + "VSM0" + triresults + Constants.STR_1E + "VCS0" + forceCollation + Constants.STR_1E + "VVR0" + erreurval + Constants.STR_1E + Constants.STR_1D;
        return this.connector.tcpReq(query);
    }

    public String affBib(String rcr) throws CBSException {
        String query = "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CUSaff bib " + rcr + Constants.STR_1D;
        return this.connector.tcpReq(query);
    }

    public String che(String req) throws CBSException {
        String query = "Cutf-8" + Constants.STR_1D + "VSE1" + Constants.STR_1D + "VPRK" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTI1" + Constants.STR_1D + " " + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CUS" + req;
        return this.connector.tcpReq(query);
    }

    public String creE(String numEx, String lotEncours) throws CBSException {
        String query = "VTI1" + Constants.STR_1D + "VSE" + lotEncours + Constants.STR_1D + "VPRUNM" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "CUScre e" + numEx;
        return this.connector.tcpReq(query);
    }

    public String creL(String lotEncours) throws CBSException {
        String query = "VTI1" + Constants.STR_1D + "VSE" + lotEncours + Constants.STR_1D + "VPRUNM" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CUScre l";
        return this.connector.tcpReq(query);
    }

    public String modE(String numEx, String lotEncours) throws CBSException {
        String query = "VTI1" + Constants.STR_1D + "VSE" + lotEncours + Constants.STR_1D + "VPRUNM" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "CUSmod e" + numEx;
        return this.connector.tcpReq(query);
    }

    public String cre(String notice, int flag) throws CBSException {
        String query = "CPC\\INV \\" + flag + " UNM" + Constants.STR_1D + "BBWVTX0T" + "BIB000200:00:00.000" + Constants.STR_1F + "D1" + Constants.STR_1F + "I" + notice + Constants.FINLIGNE;
        return this.connector.tcpReq(query);
    }

    public String valCreE(String exemplaire, String lotEncours, String ppnEncours) throws CBSException {
        String query = "VSE" + lotEncours + Constants.STR_1D + "VTI1" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CPC\\INV \\PPN " + ppnEncours + " E" + exemplaire.substring(1, 3) + " UNM;\\TOO S" + lotEncours + " 1 UNM" + Constants.STR_1D + "BBWVTX0T" + "E" + exemplaire.substring(1, 3) + "000200:00:00.000" + Constants.STR_1F + "D1" + Constants.STR_1F + "I" + exemplaire + Constants.STR_0D + Constants.STR_0D + Constants.STR_1F + Constants.STR_1E;
        return this.connector.tcpReq(query);
    }

    public String valModE(String exemplaire, String numEx, String lotEncours, String noticedeb, String ppnEncours, int lgexemp) throws CBSException {
        String query = "VSE" + lotEncours + Constants.STR_1D + "VTI1" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CPC\\MUT \\PPN " + ppnEncours + " E" + numEx + " UNM;\\TOO S" + lotEncours + " 1 " + "UNMA" + Constants.STR_1D + "BBWVTX0T" + "E" + noticedeb + Constants.STR_1F + "D" + lgexemp + Constants.STR_1F + "I" + exemplaire + Constants.STR_0D + Constants.STR_1F + Constants.STR_1E + Constants.STR_1D;
        return this.connector.tcpReq(query);
    }

    public String back(String lotEncours) throws CBSException {
        String query = "VSE" + lotEncours + Constants.STR_1D + "VTI1" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CUS\\too S" + lotEncours + " 1 " + "UNM" + Constants.STR_1D;
        return this.connector.tcpReq(query);
    }

    public String creUsa(String[] user) throws CBSException {
        String login = user[1];
        String group = user[0];
        String shortname = user[2];
        String passwd = user[3];
        String library = user[4];
        String language = user[5];
        String dbid = user[6];
        String usertype = user[7];
        String identify = user[8];
        String allowed = user[9];
        String sysmanager = user[10];
        String orgmanager = user[11];
        String depmanager = user[12];
        String ccholder = user[13];
        String logstats = user[14];
        String comment = user.length == 16 ? user[15] : "";
        String usa = login + Constants.STR_1D + "BUAVU20" + group + Constants.STR_1E + "VU10" + login + Constants.STR_1E + "VU60" + shortname + Constants.STR_1E + "VU40" + passwd + Constants.STR_1E + "VU30" + library + Constants.STR_1E + "VU70" + language + Constants.STR_1E + "VU80" + Constants.STR_1E + "VUR0" + dbid + Constants.STR_1E + "VU90" + identify + Constants.STR_1E + "VUA0" + allowed + Constants.STR_1E + "VUC0" + sysmanager + Constants.STR_1E + "VUE0" + orgmanager + Constants.STR_1E + "VUF0" + depmanager + Constants.STR_1E + "VUG0" + usertype + Constants.STR_1E + "VUI0" + Constants.STR_1E + "VUT0" + ccholder + Constants.STR_1E + "VUM0" + logstats + Constants.STR_1E + "VUH0" + Constants.STR_1E + "VUO0" + Constants.STR_1E + "VUS0" + comment + Constants.STR_1E;
        String query = "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CPC\\INV \\USE " + usa + Constants.STR_1D;
        return this.connector.tcpReq(query);
    }

    public String valSupUsa(String user) throws CBSException {
        String query = "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CPC\\WIS \\USE " + user;
        return this.connector.tcpReq(query);
    }

    public String affUsa() throws CBSException {
        String query = "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CUS" + "aff usa" + Constants.STR_1D;
        return this.connector.tcpReq(query);
    }

    public String affFormat(String format, String lotEncours) throws CBSException {
        String query = "VSE" + lotEncours + Constants.STR_1D + "VTI1" + Constants.STR_1D + "VPRI" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CUSaff " + format + Constants.STR_0D;
        return this.connector.tcpReq(query);
    }

    public String supE(String exemplaire, String lotEncours, String ppnEncours) throws CBSException {
        String query = "VSE" + lotEncours + Constants.STR_1D + "VTI1" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CPC\\KIL \\PPN " + ppnEncours + " " + exemplaire + ";\\TOO S" + lotEncours + " 1 " + "UNMA" + Constants.STR_1D;
        return this.connector.tcpReq(query);
    }

    public String sup(String lotEncours, String ppnEncours) throws CBSException {
        String query = "VSE" + lotEncours + Constants.STR_1D + "VTI1" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CPC\\KIL \\PPN " + ppnEncours + Constants.STR_1D;
        return this.connector.tcpReq(query);
    }

    public String modLoc(String lotEncours) throws CBSException {
        String query = "VSE" + lotEncours + Constants.STR_1D + "VTI1" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VPRUNMA" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "CUSmod l" + Constants.STR_1D;
        return this.connector.tcpReq(query);
    }

    public String valModLoc(String notice, String ppnEncours, String lotEncours, String vloc) throws CBSException {
        String query = "VSE" + lotEncours + Constants.STR_1D + "VTI1" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CPC\\MUT \\PPN " + ppnEncours + " L" + " UNM;\\TOO S" + lotEncours + " 1 " + "UNMA" + Constants.STR_1D + "BBWVTX0T" + notice + Constants.STR_1F + "D" + (Integer.parseInt(notice.substring(3, 7)) - 1) + Constants.STR_1F + "I" + vloc + Constants.STR_0D + Constants.STR_0D + Constants.STR_1F + Constants.STR_1E;
        return this.connector.tcpReq(query);
    }

    public String valCreLoc(String ppnEncours, String lotEncours, String vloc) throws CBSException {
        String query = "VSE" + lotEncours + Constants.STR_1D + "VTI1" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CPC\\INV \\PPN " + ppnEncours + " L" + " UNM;\\TOO S" + lotEncours + " 1 " + "UNMA" + Constants.STR_1D + "BBWVTX0T" + "LOK000200:00:00.000" + Constants.STR_1F + "D1" + Constants.STR_1F + "I" + vloc + Constants.STR_0D + Constants.STR_0D + Constants.STR_1F + Constants.STR_1E;
        return this.connector.tcpReq(query);
    }

    public String mod(String noRecord, String lotEncours) throws CBSException {
        String query = "VTI1" + Constants.STR_1D + "VSE" + lotEncours + Constants.STR_1D + "VPRUNM" + Constants.STR_1D + "V!T1" + Constants.STR_1D + "VTAFR" + Constants.STR_1D + "V!Cutf-8" + Constants.STR_1D + "CUS\\MUT S" + lotEncours + " " + noRecord + " " + "UNM" + Constants.STR_1D;
        return this.connector.tcpReq(query);
    }

    public boolean isLogged() {
        return this.isLogged;
    }

    public void setLogged(boolean isLogged) {
        this.isLogged = isLogged;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean isConnected) {
        this.isConnected = isConnected;
    }

    public String getRcr() {
        return this.rcr;
    }
}

