/*
 * Decompiled with CFR 0.152.
 */
package fr.abes.cbs.connector;

import fr.abes.cbs.exception.CBSException;
import fr.abes.cbs.utilitaire.Constants;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class Cbs {
    private boolean cmdOk;
    private String errorMessage;
    private Socket s;

    public void close() throws CBSException {
        this.disconnect();
    }

    public String connect(String tip, int port) throws CBSException {
        this.errorMessage = this.connectTcp(tip, port);
        return this.errorMessage;
    }

    public String tcpReq(String query) throws CBSException {
        String resu = this.req(query);
        this.checkForErrors(resu);
        return resu;
    }

    private String connectTcp(String tip, int port) throws CBSException {
        try {
            this.s = new Socket(tip, port);
            if (this.s.isConnected()) {
                return "";
            }
            return "connect ko";
        }
        catch (Exception e) {
            throw new CBSException("Error connecting to " + tip + " " + port, e.getMessage());
        }
    }

    private void disconnect() throws CBSException {
        try {
            if (this.s.isConnected()) {
                this.s.close();
            }
        }
        catch (Exception e) {
            throw new CBSException("Error disconnecting socket", e.getMessage());
        }
    }

    private String req(String query) {
        try {
            DataInputStream in = new DataInputStream(this.s.getInputStream());
            DataOutputStream out = new DataOutputStream(this.s.getOutputStream());
            String chaine1 = String.valueOf('\u001d');
            String chaine2 = String.valueOf('\u0003');
            String myString = query + chaine1 + chaine2;
            byte[] bytes = myString.getBytes("UTF-8");
            out.write(bytes, 0, bytes.length);
            int nbtours = 0;
            StringBuilder resu = new StringBuilder();
            int nb = in.read();
            while (nb > 0) {
                byte[] red = new byte[nb];
                in.read(red, 0, nb);
                String res = new String(red, "UTF-8");
                resu.append(res);
                nb = in.available();
                while (nbtours < 20 && nb == 0 && !resu.toString().contains("\u0003")) {
                    ++nbtours;
                    Thread.sleep(10L);
                    nb = in.available();
                }
            }
            String res = resu.toString();
            this.errorMessage = res.contains("VERROR") ? res : "";
            this.cmdOk = true;
            return res;
        }
        catch (IOException | InterruptedException e) {
            this.cmdOk = false;
            return "Req ko " + e.toString();
        }
    }

    private void checkForErrors(String resu) throws CBSException {
        if (resu.contains("V/VREJECT")) {
            this.setCmdOk(false);
            throw new CBSException("V/VREJECT", resu.substring(2, resu.indexOf(Constants.STR_1D)));
        }
        if (resu.contains("V/VERROR")) {
            this.setCmdOk(false);
            throw new CBSException("V/VERROR", resu.substring(resu.indexOf("M02") + 3, resu.indexOf(Constants.STR_1D, resu.indexOf("M02") + 3)));
        }
        this.setCmdOk(true);
    }

    public boolean isCmdOk() {
        return this.cmdOk;
    }

    public void setCmdOk(boolean cmdOk) {
        this.cmdOk = cmdOk;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

