/*
 * Decompiled with CFR 0.152.
 */
package fr.abes.cbs.notices;

import fr.abes.cbs.exception.ZoneException;
import fr.abes.cbs.notices.FORMATS;
import fr.abes.cbs.notices.Notice;
import fr.abes.cbs.notices.TYPE_NOTICE;
import fr.abes.cbs.notices.Zone;
import fr.abes.cbs.utilitaire.Constants;
import fr.abes.cbs.utilitaire.Utilitaire;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.jshell.spi.ExecutionControl;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class Autorite
extends Notice {
    @Override
    public String getNumEx() throws ExecutionControl.NotImplementedException {
        throw new ExecutionControl.NotImplementedException("Impossible de r\u00e9cup\u00e9rer l'exemplaire d'une notice autorit\u00e9");
    }

    @Override
    public TYPE_NOTICE getType() {
        return TYPE_NOTICE.AUTORITE;
    }

    public Autorite(String notice) throws ZoneException {
        this.createAutoriteFromUnimarc(notice);
    }

    public Autorite(String notice, FORMATS format) throws ZoneException, ParseException, DocumentException {
        switch (format) {
            case UNM: {
                this.createAutoriteFromUnimarc(notice);
                break;
            }
            case XML: {
                this.createAutoriteFromXml(notice);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + format);
            }
        }
    }

    private void createAutoriteFromXml(String noticeXml) throws DocumentException, ZoneException, ParseException {
        Document doc = DocumentHelper.parseText((String)noticeXml);
        List listeZone = doc.selectNodes("//record/*");
        for (int i = 0; i < listeZone.size(); ++i) {
            Node zone = (Node)listeZone.get(i);
            if ("datafield".equals(zone.getName())) {
                this.generateDataField(zone);
                continue;
            }
            if ("controlfield".equals(zone.getName())) {
                this.generateControlField(zone);
                continue;
            }
            this.generateLeader(zone);
        }
        this.addZone("00A", "$0", "0");
        this.addZone("00U", "$0", "utf8");
    }

    private void generateLeader(Node zone) {
    }

    private void generateControlField(Node zone) throws ParseException, ZoneException {
        String labelZone;
        switch (labelZone = ((Element)zone).attributeValue("tag")) {
            case "001": {
                Zone zone003 = new Zone("003", this.getType(), zone.getStringValue());
                this.addZone(zone003);
                break;
            }
            case "004": {
                SimpleDateFormat dateFormatXml4 = new SimpleDateFormat("yyyyMMdd");
                SimpleDateFormat dateFormatSudoc4 = new SimpleDateFormat("dd-MM-yy");
                Date dateXml = dateFormatXml4.parse(zone.getStringValue());
                this.addZone("004", dateFormatSudoc4.format(dateXml));
                break;
            }
            case "005": {
                SimpleDateFormat dateFormatXml5 = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
                SimpleDateFormat dateFormatSudoc5 = new SimpleDateFormat("dd-MM-yy HH:mm:ss.SSS");
                Date dateXml = dateFormatXml5.parse(zone.getStringValue());
                this.addZone("005", dateFormatSudoc5.format(dateXml));
                break;
            }
            case "006": {
                StringBuilder zone004String = new StringBuilder(this.findZone("004", 0).getValeur());
                StringBuilder zone005String = new StringBuilder(this.findZone("005", 0).getValeur());
                StringBuilder zone006String = new StringBuilder(zone.getStringValue());
                zone006String.append(':');
                zone004String.insert(0, zone006String);
                zone005String.insert(0, zone006String);
                this.deleteZone("005");
                this.deleteZone("004");
                this.addZone("004", zone004String.toString());
                this.addZone("005", zone005String.toString());
                this.addZone("006", zone004String.toString());
                break;
            }
            case "008": {
                this.addZone("008", "$a", zone.getStringValue());
                break;
            }
        }
    }

    private void generateDataField(Node zone) throws ZoneException {
        String zoneId = ((Element)zone).attributeValue("tag");
        if (!(zoneId.equals("100") || zoneId.equals("152") || zoneId.equals("801") || Integer.parseInt(zoneId) >= 900)) {
            int indexZone = this.findZones(zoneId).size();
            char[] indicateurs = Autorite.getIndicateurs(zone);
            List listeSousZones = zone.selectNodes("*");
            this.traiterSousZonesXml(zoneId, indicateurs, listeSousZones, indexZone);
        }
    }

    @Override
    protected void traiterSousZonesXml(String zoneId, char[] indicateurs, List<Node> listeSousZones, Integer indexZone) throws ZoneException {
        boolean isFirst = true;
        for (int k = 0; k < listeSousZones.size(); ++k) {
            if (!"subfield".equals(listeSousZones.get(k).getName())) continue;
            String codeId = ((Element)listeSousZones.get(k)).attributeValue("code");
            if (this.generate120(zoneId, listeSousZones.get(k), indicateurs) || codeId.equals("7") || listeSousZones.get(k).getStringValue() == null) continue;
            if (isFirst) {
                if (zoneId.matches("e\\d\\d")) {
                    this.addZone(zoneId, "$" + codeId, listeSousZones.get(k).getStringValue());
                } else {
                    this.addZone(zoneId, "$" + codeId, listeSousZones.get(k).getStringValue(), indicateurs);
                }
                isFirst = false;
                continue;
            }
            this.addSousZone(zoneId, "$" + codeId, listeSousZones.get(k).getStringValue(), indexZone);
        }
    }

    private boolean generate120(String zoneId, Node node, char[] indicateurs) throws ZoneException {
        if (zoneId.equals("120")) {
            this.addZone("120", "$a", node.getStringValue().substring(0, 1), indicateurs);
            return true;
        }
        return false;
    }

    public void createAutoriteFromUnimarc(String autoriteUnm) throws ZoneException {
        String autoriteToCreate = autoriteUnm.substring(autoriteUnm.indexOf(Constants.STR_1F) + 1, autoriteUnm.indexOf(Constants.STR_1E));
        String[] tabAutorite = autoriteToCreate.split("\\r");
        Pattern standarZoneRegexPattern = Pattern.compile("[0-8][\\d][\\w]\\s.*[$].*");
        Pattern standarZoneSansSousZonePattern = Pattern.compile("[0-8][\\d]{2}\\s[^$].*");
        String zonePrecedente = "";
        int indexZone = 0;
        for (String lineZone : tabAutorite) {
            Matcher standardZoneRegexFinded = standarZoneRegexPattern.matcher(lineZone);
            Matcher standardZoneSansSousZoneFinded = standarZoneSansSousZonePattern.matcher(lineZone);
            String labelZone = "";
            char[] indicateurs = new char[2];
            boolean firstSousZone = true;
            if (standardZoneRegexFinded.find()) {
                Pattern pattern = Pattern.compile(Utilitaire.setStandardZoneRegex(50));
                Matcher matcher = pattern.matcher(lineZone);
                while (matcher.find()) {
                    if (matcher.group("zStaName") != null) {
                        labelZone = matcher.group("zStaName");
                        int n = indexZone = labelZone.equals(zonePrecedente) ? indexZone + 1 : 0;
                    }
                    if (matcher.group("zStaHash") != null) {
                        indicateurs = matcher.group("zStaHash").toCharArray();
                    }
                    for (int i = 0; i <= 50; ++i) {
                        if (matcher.group("szv" + i) == null) continue;
                        if (firstSousZone) {
                            if (indicateurs.length > 0) {
                                this.addZone(labelZone, matcher.group("szk" + i), matcher.group("szv" + i), indicateurs);
                            } else {
                                this.addZone(labelZone, matcher.group("szk" + i), matcher.group("szv" + i));
                            }
                            firstSousZone = false;
                            continue;
                        }
                        this.addSousZone(labelZone, matcher.group("szk" + i), matcher.group("szv" + i), indexZone);
                    }
                    zonePrecedente = labelZone;
                }
                continue;
            }
            if (!standardZoneSansSousZoneFinded.find()) continue;
            this.genererZonesSansSousZone(lineZone, labelZone);
        }
    }
}

