/*
 * Decompiled with CFR 0.152.
 */
package fr.abes.cbs.notices;

import fr.abes.cbs.exception.ZoneException;
import fr.abes.cbs.notices.FORMATS;
import fr.abes.cbs.notices.Notice;
import fr.abes.cbs.notices.TYPE_NOTICE;
import fr.abes.cbs.utilitaire.Constants;
import fr.abes.cbs.utilitaire.Utilitaire;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.jshell.spi.ExecutionControl;
import org.dom4j.DocumentException;

public class Biblio
extends Notice {
    public Biblio() {
    }

    public Biblio(String biblioUnm) throws ZoneException {
        this.createBiblioFromUnm(biblioUnm);
    }

    public Biblio(String notice, FORMATS format) throws ZoneException, DocumentException {
        switch (format) {
            case UNM: {
                this.createBiblioFromUnm(notice);
                break;
            }
            case XML: {
                this.createBiblioFromXml(notice);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + format);
            }
        }
    }

    public void createBiblioFromUnm(String biblioUnm) throws ZoneException {
        String biblioToCreate = biblioUnm.substring(biblioUnm.indexOf(Constants.STR_1F) + 1, biblioUnm.indexOf(Constants.STR_1E));
        String[] tabBiblio = biblioToCreate.split("\\r");
        Pattern standarZoneRegexPattern = Pattern.compile("[0-8][\\d][\\w]\\s.*[$].*");
        Pattern standarZoneSansSousZonePattern = Pattern.compile("[0-8][\\d]{2}\\s[^$].*");
        String zonePrecedente = "";
        Integer indexZone = 0;
        for (String lineZone : tabBiblio) {
            Matcher standardZoneRegexFinded = standarZoneRegexPattern.matcher(lineZone);
            Matcher standardZoneSansSousZoneFinded = standarZoneSansSousZonePattern.matcher(lineZone);
            String labelZone = "";
            char[] indicateurs = new char[2];
            boolean firstSousZone = true;
            if (standardZoneRegexFinded.find()) {
                Pattern pattern = Pattern.compile(Utilitaire.setStandardZoneRegex(50));
                Matcher matcher = pattern.matcher(lineZone);
                while (matcher.find()) {
                    if (matcher.group("zStaName") != null) {
                        labelZone = matcher.group("zStaName");
                        indexZone = labelZone.equals(zonePrecedente) ? indexZone + 1 : 0;
                    }
                    if (matcher.group("zStaHash") != null) {
                        indicateurs = matcher.group("zStaHash").toCharArray();
                    }
                    for (int i = 0; i <= 50; ++i) {
                        if (matcher.group("szv" + i) == null) continue;
                        if (firstSousZone) {
                            if (indicateurs.length > 0) {
                                this.addZone(labelZone, matcher.group("szk" + i), matcher.group("szv" + i), indicateurs);
                            } else {
                                this.addZone(labelZone, matcher.group("szk" + i), matcher.group("szv" + i));
                            }
                            firstSousZone = false;
                            continue;
                        }
                        this.addSousZone(labelZone, matcher.group("szk" + i), matcher.group("szv" + i), indexZone);
                    }
                    zonePrecedente = labelZone;
                }
                continue;
            }
            if (!standardZoneSansSousZoneFinded.find()) continue;
            this.genererZonesSansSousZone(lineZone, labelZone);
        }
    }

    public void createBiblioFromXml(String noticeXml) throws ZoneException, DocumentException {
        this.createNoticeFromXml(noticeXml);
    }

    @Override
    public String getNumEx() throws ExecutionControl.NotImplementedException {
        throw new ExecutionControl.NotImplementedException("Impossible de r\u00e9cup\u00e9rer l'exemplaire d'une notice bibliographique");
    }

    @Override
    public TYPE_NOTICE getType() {
        return TYPE_NOTICE.BIBLIOGRAPHIQUE;
    }

    public Boolean isTheseElectronique() {
        return this.findZones("008").get(0).findSubLabel("$a").startsWith("O") && this.findZones("105").get(0).findSubLabel("$b").startsWith("m");
    }
}

