/*
 * Decompiled with CFR 0.152.
 */
package fr.abes.cbs.notices;

import fr.abes.cbs.exception.ZoneException;
import fr.abes.cbs.notices.FORMATS;
import fr.abes.cbs.notices.Notice;
import fr.abes.cbs.notices.TYPE_NOTICE;
import fr.abes.cbs.utilitaire.Constants;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.jshell.spi.ExecutionControl;
import org.dom4j.DocumentException;

public class DonneeLocale
extends Notice {
    public DonneeLocale(String notice) throws ZoneException {
        this.createLocaleFromUnimarc(notice);
    }

    public DonneeLocale(String notice, FORMATS format) throws ZoneException, DocumentException {
        switch (format) {
            case UNM: {
                this.createLocaleFromUnimarc(notice);
                break;
            }
            case XML: {
                this.createLocaleFromXml(notice);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + format);
            }
        }
    }

    private void createLocaleFromXml(String noticeXml) throws ZoneException, DocumentException {
        this.createNoticeFromXml(noticeXml);
    }

    public void createLocaleFromUnimarc(String donneesLocales) throws ZoneException {
        String donneesLocalesToCreate = donneesLocales.substring(donneesLocales.indexOf(Constants.STR_1F) + 1, donneesLocales.indexOf(Constants.STR_1E));
        String[] tabZonesDonneesLocales = donneesLocalesToCreate.split("\\r");
        Pattern standardZoneRegexPattern = Pattern.compile("^[L]?[0-9][0-9][0-9]");
        Pattern systemZonesRegexPattern = Pattern.compile("L005");
        for (String linezone : tabZonesDonneesLocales) {
            Matcher matcher;
            Pattern pattern;
            Matcher standardZoneRegexFinded = standardZoneRegexPattern.matcher(linezone);
            Matcher systemZonesRegexFinded = systemZonesRegexPattern.matcher(linezone);
            String labelzone = "";
            char[] indicateurs = new char[2];
            boolean firstSousZone = true;
            if (systemZonesRegexFinded.find()) {
                pattern = Pattern.compile("^(?<zSysName>L005)? *(?<zSysSpace>\\s*)? *(?<zSysv0>[\\d][\\d][-][\\d][\\d][-][\\d][\\d])? *(?<zSysv1>\\d\\d:\\d\\d:\\d\\d.?\\d?\\d?\\d?)? *(?<zSysSpace2>\\s*)?");
                matcher = pattern.matcher(linezone);
                while (matcher.find()) {
                    if (matcher.group("zSysName") != null) {
                        labelzone = matcher.group("zSysName");
                    }
                    if (matcher.group("zSysv0") == null || matcher.group("zSysv1") == null) continue;
                    this.addZone(labelzone, matcher.group("zSysv0") + " " + matcher.group("zSysv1"));
                }
                continue;
            }
            if (!standardZoneRegexFinded.find()) continue;
            pattern = Pattern.compile("^(?<zStaName>[L]?[0-9][0-9][0-9])(?<zStaSpace>\\s*)(?<zStaHash>[\\d]*[#]*[\\d]*) *((?<szk0>[$][a-z])(?<szv0>[^$]*))? *((?<szk1>[$][a-z])(?<szv1>[^$]*))? *((?<szk2>[$][a-z])(?<szv2>[^$]*))? *((?<szk3>[$][a-z])(?<szv3>[^$]*))? *((?<szk4>[$][a-z])(?<szv4>[^$]*))? *((?<szk5>[$][a-z])(?<szv5>[^$]*))? *((?<szk6>[$][a-z])(?<szv6>[^$]*))? *((?<szk7>[$][a-z])(?<szv7>[^$]*))? *((?<szk8>[$][a-z])(?<szv8>[^$]*))? *((?<szk9>[$][a-z])(?<szv9>[^$]*))? *((?<szk10>[$][a-z])(?<szv10>[^$]*))? *((?<szk11>[$][a-z])(?<szv11>[^$]*))? *((?<szk12>[$][a-z])(?<szv12>[^$]*))? *((?<szk13>[$][a-z])(?<szv13>[^$]*))? *((?<szk14>[$][a-z])(?<szv14>[^$]*))? *((?<szk15>[$][a-z])(?<szv15>[^$]*))? *((?<szk16>[$][a-z])(?<szv16>[^$]*))? *((?<szk17>[$][a-z])(?<szv17>[^$]*))? *((?<szk18>[$][a-z])(?<szv18>[^$]*))? *((?<szk19>[$][a-z])(?<szv19>[^$]*))? *((?<szk20>[$][a-z])(?<szv20>[^$]*))? *((?<szk21>[$][a-z])(?<szv21>[^$]*))? *((?<szk22>[$][a-z])(?<szv22>[^$]*))? *((?<szk23>[$][a-z])(?<szv23>[^$]*))? *((?<szk24>[$][a-z])(?<szv24>[^$]*))? *((?<szk25>[$][a-z])(?<szv25>[^$]*))? *((?<szk26>[$][a-z])(?<szv26>[^$]*))? *((?<szk27>[$][a-z])(?<szv27>[^$]*))? *((?<szk28>[$][a-z])(?<szv28>[^$]*))? *((?<szk29>[$][a-z])(?<szv29>[^$]*))? *((?<szk30>[$][a-z])(?<szv30>[^$]*))? *((?<szk31>[$][a-z])(?<szv31>[^$]*))? *((?<szk32>[$][a-z])(?<szv32>[^$]*))? *((?<szk33>[$][a-z])(?<szv33>[^$]*))? *((?<szk34>[$][a-z])(?<szv34>[^$]*))? *((?<szk35>[$][a-z])(?<szv35>[^$]*))? *((?<szk36>[$][a-z])(?<szv36>[^$]*))? *((?<szk37>[$][a-z])(?<szv37>[^$]*))? *((?<szk38>[$][a-z])(?<szv38>[^$]*))? *((?<szk39>[$][a-z])(?<szv39>[^$]*))? *((?<szk40>[$][a-z])(?<szv40>[^$]*))? *((?<szk41>[$][a-z])(?<szv41>[^$]*))? *((?<szk42>[$][a-z])(?<szv42>[^$]*))? *((?<szk43>[$][a-z])(?<szv43>[^$]*))? *((?<szk44>[$][a-z])(?<szv44>[^$]*))? *((?<szk45>[$][a-z])(?<szv45>[^$]*))? *((?<szk46>[$][a-z])(?<szv46>[^$]*))? *((?<szk47>[$][a-z])(?<szv47>[^$]*))? *((?<szk48>[$][a-z])(?<szv48>[^$]*))? *((?<szk49>[$][a-z])(?<szv49>[^$]*))? *((?<szk50>[$][a-z])(?<szv50>[^$]*))?");
            matcher = pattern.matcher(linezone);
            while (matcher.find()) {
                if (matcher.group("zStaName") != null) {
                    labelzone = matcher.group("zStaName");
                }
                if (matcher.group("zStaHash") != null) {
                    indicateurs = matcher.group("zStaHash").toCharArray();
                }
                for (int i = 0; i <= 50; ++i) {
                    if (matcher.group("szv" + i) == null) continue;
                    if (firstSousZone) {
                        if (indicateurs.length > 0) {
                            this.addZone(labelzone, matcher.group("szk" + i), matcher.group("szv" + i), indicateurs);
                        } else {
                            this.addZone(labelzone, matcher.group("szk" + i), matcher.group("szv" + i));
                        }
                        firstSousZone = false;
                        continue;
                    }
                    this.addSousZone(labelzone, matcher.group("szk" + i), matcher.group("szv" + i));
                }
            }
        }
    }

    @Override
    public String getNumEx() throws ExecutionControl.NotImplementedException {
        throw new ExecutionControl.NotImplementedException("Impossible de r\u00e9cup\u00e9rer l'exemplaire d'une donn\u00e9e locale");
    }

    @Override
    public TYPE_NOTICE getType() {
        return TYPE_NOTICE.LOCALE;
    }
}

