/*
 * Decompiled with CFR 0.152.
 */
package fr.abes.cbs.notices;

import com.google.common.collect.ListMultimap;
import fr.abes.cbs.exception.NoticeException;
import fr.abes.cbs.exception.ZoneException;
import fr.abes.cbs.notices.FORMATS;
import fr.abes.cbs.notices.Notice;
import fr.abes.cbs.notices.TYPE_NOTICE;
import fr.abes.cbs.notices.Zone;
import fr.abes.cbs.notices.ZoneEtatColl;
import fr.abes.cbs.notices.sequences.SequenceEtatColl;
import fr.abes.cbs.notices.sequences.SequenceParallele;
import fr.abes.cbs.notices.sequences.SequencePrimaire;
import fr.abes.cbs.utilitaire.Constants;
import fr.abes.cbs.utilitaire.Utilitaire;
import fr.abes.cbs.zones.enumSousZones.Zone_955;
import fr.abes.cbs.zones.enumSousZones.Zone_956;
import fr.abes.cbs.zones.enumSousZones.Zone_957;
import fr.abes.cbs.zones.enumSousZones.Zone_959;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.DocumentException;

public class Exemplaire
extends Notice {
    public Exemplaire() {
    }

    public Exemplaire(ListMultimap<String, Zone> listeZones) {
        this.listeZones = listeZones;
    }

    public Exemplaire(List<Zone> listeZones) {
        for (Zone zone : listeZones) {
            this.listeZones.put((Object)zone.getLabel(), (Object)zone);
        }
    }

    public Exemplaire(String notice) throws ZoneException {
        this.createExemplaireFromUnimarc(notice);
    }

    public Exemplaire(String notice, FORMATS format) throws ZoneException, NoticeException, DocumentException {
        switch (format) {
            case UNM: {
                this.createExemplaireFromUnimarc(notice);
                break;
            }
            case XML: {
                this.createExemplaireFromXml(notice);
                break;
            }
            default: {
                throw new NoticeException("Format non pris en charge dans la cr\u00e9ation de notice");
            }
        }
    }

    private void createExemplaireFromXml(String noticeXml) throws ZoneException, DocumentException {
        this.createNoticeFromXml(noticeXml);
    }

    public void createExemplaireFromUnimarc(String exemplaire) throws ZoneException {
        String exempToCreate = exemplaire.substring(exemplaire.indexOf(Constants.STR_1F) + 1, exemplaire.indexOf(Constants.STR_1E));
        String[] tabZonesExemp = exempToCreate.split("\\r");
        Pattern standardZoneRegexPattern = Pattern.compile("^[^A][E/i]?\\d*");
        Pattern systemZonesRegexPattern = Pattern.compile("^[A][9][789]\\d*");
        Pattern systemZone97RegexPattern = Pattern.compile("^[A][9][7]\\d*");
        Pattern systemZone98RegexPattern = Pattern.compile("^[A][9][8]\\d*");
        Pattern standardZoneEtatCollRegexPattern = Pattern.compile("^[9][5][5679]\\d*");
        String zonePrecedente = "";
        Integer indexZone = 0;
        for (String lineZone : tabZonesExemp) {
            Matcher standardZoneRegexFinded = standardZoneRegexPattern.matcher(lineZone);
            Matcher systemZonesRegexFinded = systemZonesRegexPattern.matcher(lineZone);
            Matcher systemZones97RegexFinded = systemZone97RegexPattern.matcher(lineZone);
            Matcher standardZoneEtatCollRegexFinded = standardZoneEtatCollRegexPattern.matcher(lineZone);
            Matcher systemZones98RegexFinded = systemZone98RegexPattern.matcher(lineZone);
            String labelZone = "";
            char[] indicateurs = new char[2];
            boolean firstSousZone = true;
            if (standardZoneEtatCollRegexFinded.find()) {
                this.genererEtatCollection(lineZone);
                continue;
            }
            if (standardZoneRegexFinded.find()) {
                Pattern pattern = Pattern.compile(Utilitaire.setStandardZoneRegex(50));
                Matcher matcher = pattern.matcher(lineZone);
                while (matcher.find()) {
                    if (matcher.group("zStaName") != null) {
                        labelZone = matcher.group("zStaName");
                        indexZone = labelZone.equals(zonePrecedente) ? indexZone + 1 : 0;
                    }
                    if (matcher.group("zStaHash") != null) {
                        indicateurs = matcher.group("zStaHash").toCharArray();
                    }
                    for (int i = 0; i <= 50; ++i) {
                        if (matcher.group("szv" + i) == null) continue;
                        if (firstSousZone) {
                            if (indicateurs.length > 0) {
                                this.addZone(labelZone, matcher.group("szk" + i), matcher.group("szv" + i), indicateurs);
                            } else {
                                this.addZone(labelZone, matcher.group("szk" + i), matcher.group("szv" + i));
                            }
                            firstSousZone = false;
                            continue;
                        }
                        this.addSousZone(labelZone, matcher.group("szk" + i), matcher.group("szv" + i), indexZone);
                    }
                    zonePrecedente = labelZone;
                }
                continue;
            }
            if (!systemZonesRegexFinded.find()) continue;
            if (systemZones97RegexFinded.find()) {
                this.genererZoneA97(lineZone, labelZone);
                continue;
            }
            if (systemZones98RegexFinded.find()) {
                this.genererZoneA98(lineZone, labelZone);
                continue;
            }
            this.genererZoneA99(lineZone, labelZone);
        }
    }

    private void genererZoneA99(String lineZone, String labelZone) throws ZoneException {
        Pattern pattern = Pattern.compile("^(?<zSysName>[A][\\d]*)? *(?<zSysSpace>\\s*)? *(?<zSysv0>\\d{1,9}X?:?)? *(?<zSysSpace2>\\s*)?");
        Matcher matcher = pattern.matcher(lineZone);
        while (matcher.find()) {
            if (matcher.group("zSysName") != null) {
                labelZone = matcher.group("zSysName");
            }
            if (matcher.group("zSysv0") == null) continue;
            this.addZone(labelZone, matcher.group("zSysv0"));
        }
    }

    private void genererZoneA98(String lineZone, String labelZone) throws ZoneException {
        Pattern pattern = Pattern.compile("^(?<zSysName>[A][\\d]*)? *(?<zSysSpace>\\s*)? *(?<zSysv0>\\d{1,9}:?)? *(?<zSysv1>\\d\\d-\\d\\d-\\d\\d)?");
        Matcher matcher = pattern.matcher(lineZone);
        while (matcher.find()) {
            if (matcher.group("zSysName") != null) {
                labelZone = matcher.group("zSysName");
            }
            if (matcher.group("zSysv0") == null || matcher.group("zSysv1") == null) continue;
            this.addZone(labelZone, matcher.group("zSysv0") + matcher.group("zSysv1"));
        }
    }

    private void genererZoneA97(String lineZone, String labelZone) throws ZoneException {
        Pattern pattern = Pattern.compile("^(?<zSysName>[A][\\d]*)? *(?<zSysSpace>\\s*)? *(?<zSysv0>[\\d][\\d][-][\\d][\\d][-][\\d][\\d])? *(?<zSysv1>\\d\\d:\\d\\d:\\d\\d.?\\d?\\d?\\d?)? *(?<zSysSpace2>\\s*)?");
        Matcher matcher = pattern.matcher(lineZone);
        while (matcher.find()) {
            if (matcher.group("zSysName") != null) {
                labelZone = matcher.group("zSysName");
            }
            if (matcher.group("zSysv0") == null || matcher.group("zSysv1") == null) continue;
            this.addZone(labelZone, matcher.group("zSysv0") + " " + matcher.group("zSysv1"));
        }
    }

    private void genererEtatCollection(String lineZone) throws ZoneException {
        int nbSousZones;
        String labelZone = "";
        String valeurZone = "";
        ZoneEtatColl zoneEtatColl = new ZoneEtatColl();
        char[] indicateurs = new char[2];
        Pattern pattern = Pattern.compile("^(?<zStaName>[^A][^E][\\d]*)(?<zStaSpace>\\s*)(?<zStaHash>[\\d]*[#]*[\\d]*) *(?<szv>.+)?");
        Matcher matcher = pattern.matcher(lineZone);
        while (matcher.find()) {
            String[] tabSequence;
            if (matcher.group("zStaName") != null) {
                labelZone = matcher.group("zStaName");
            }
            if (matcher.group("zStaHash") != null) {
                indicateurs = matcher.group("zStaHash").toCharArray();
            }
            zoneEtatColl = new ZoneEtatColl(labelZone, indicateurs);
            if (matcher.group("szv") != null) {
                valeurZone = matcher.group("szv");
            }
            for (String sequence : tabSequence = valeurZone.split("[$]0\\s")) {
                String sequencePrimaireStr;
                String sequenceParaStr = "";
                SequenceParallele sequencePara = null;
                String[] tabNumerotationPara = sequence.split("[$]5\\s");
                if (tabNumerotationPara.length == 2) {
                    sequenceParaStr = tabNumerotationPara[1];
                    sequencePrimaireStr = tabNumerotationPara[0];
                } else {
                    sequencePrimaireStr = tabNumerotationPara[0];
                }
                if (!sequenceParaStr.isEmpty()) {
                    sequencePara = new SequenceParallele(sequenceParaStr);
                }
                SequencePrimaire sequencePrimaire = new SequencePrimaire(sequencePrimaireStr, labelZone);
                SequenceEtatColl sequenceEtatColl = new SequenceEtatColl(sequencePrimaire, sequencePara);
                zoneEtatColl.addSequence(sequenceEtatColl);
            }
            zoneEtatColl.setLabel(labelZone);
            zoneEtatColl.setIndicateurs(indicateurs);
        }
        switch (zoneEtatColl.getLabel()) {
            case "955": {
                pattern = Pattern.compile(Utilitaire.setEtatCollZoneRestantes(Zone_955.values()));
                nbSousZones = Zone_955.values().length;
                break;
            }
            case "956": {
                pattern = Pattern.compile(Utilitaire.setEtatCollZoneRestantes(Zone_956.values()));
                nbSousZones = Zone_956.values().length;
                break;
            }
            case "957": {
                pattern = Pattern.compile(Utilitaire.setEtatCollZoneRestantes(Zone_957.values()));
                nbSousZones = Zone_957.values().length;
                break;
            }
            default: {
                pattern = Pattern.compile(Utilitaire.setEtatCollZoneRestantes(Zone_959.values()));
                nbSousZones = Zone_959.values().length;
            }
        }
        matcher = pattern.matcher(lineZone);
        if (matcher.find()) {
            for (int i = 0; i < nbSousZones; ++i) {
                if (matcher.group("szk" + i) == null) continue;
                zoneEtatColl.addSubLabel(matcher.group("szk" + i), matcher.group("szv" + i));
            }
        }
        this.addZone(zoneEtatColl);
    }

    public void creerNoticeFromUnimarc(String notice) throws ZoneException {
        this.listeZones = new Exemplaire((String)notice).listeZones;
    }

    @Override
    public void addZoneEtatCollection(String zone, String sousZone, String valeur, char[] indicateurs) throws ZoneException {
        ZoneEtatColl buffer = new ZoneEtatColl(zone, indicateurs);
        SequencePrimaire sequencePrimaire = new SequencePrimaire(sousZone + valeur, zone);
        SequenceEtatColl sequenceEtatColl = new SequenceEtatColl(sequencePrimaire);
        buffer.addSequence(sequenceEtatColl);
        this.listeZones.put((Object)zone, (Object)buffer);
    }

    @Override
    public String getNumEx() {
        return ((Zone)this.listeZones.values().iterator().next()).getLabel().toString().substring(1);
    }

    @Override
    public TYPE_NOTICE getType() {
        return TYPE_NOTICE.EXEMPLAIRE;
    }
}

